/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;

public class QueryStringQuery
extends RelevanceQuery<QueryStringQueryBuilder> {
    public QueryStringQuery() {
        super(ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"allow_leading_wildcard", (b, v) -> b.allowLeadingWildcard(Boolean.valueOf(Boolean.parseBoolean(v.stringValue())))).put((Object)"analyze_wildcard", (b, v) -> b.analyzeWildcard(Boolean.valueOf(Boolean.parseBoolean(v.stringValue())))).put((Object)"auto_generate_synonyms_phrase_query", (b, v) -> b.autoGenerateSynonymsPhraseQuery(Boolean.parseBoolean(v.stringValue()))).put((Object)"boost", (b, v) -> (QueryStringQueryBuilder)b.boost(Float.parseFloat(v.stringValue()))).put((Object)"default_operator", (b, v) -> b.defaultOperator(Operator.fromString((String)v.stringValue()))).put((Object)"enable_position_increments", (b, v) -> b.enablePositionIncrements(Boolean.parseBoolean(v.stringValue()))).put((Object)"fuzziness", (b, v) -> b.fuzziness(Fuzziness.build((Object)v.stringValue()))).put((Object)"fuzzy_rewrite", (b, v) -> b.fuzzyRewrite(v.stringValue())).put((Object)"escape", (b, v) -> b.escape(Boolean.parseBoolean(v.stringValue()))).put((Object)"fuzzy_max_expansions", (b, v) -> b.fuzzyMaxExpansions(Integer.parseInt(v.stringValue()))).put((Object)"fuzzy_prefix_length", (b, v) -> b.fuzzyPrefixLength(Integer.parseInt(v.stringValue()))).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(Boolean.parseBoolean(v.stringValue()))).put((Object)"lenient", (b, v) -> b.lenient(Boolean.valueOf(Boolean.parseBoolean(v.stringValue())))).put((Object)"max_determinized_states", (b, v) -> b.maxDeterminizedStates(Integer.parseInt(v.stringValue()))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"quote_analyzer", (b, v) -> b.quoteAnalyzer(v.stringValue())).put((Object)"phrase_slop", (b, v) -> b.phraseSlop(Integer.parseInt(v.stringValue()))).put((Object)"quote_field_suffix", (b, v) -> b.quoteFieldSuffix(v.stringValue())).put((Object)"rewrite", (b, v) -> b.rewrite(v.stringValue())).put((Object)"type", (b, v) -> b.type(MultiMatchQueryBuilder.Type.parse((String)v.stringValue(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE))).put((Object)"tie_breaker", (b, v) -> b.tieBreaker(Float.parseFloat(v.stringValue()))).put((Object)"time_zone", (b, v) -> b.timeZone(v.stringValue())).build());
    }

    @Override
    public QueryBuilder build(FunctionExpression func) {
        Iterator iterator = func.getArguments().iterator();
        if (func.getArguments().size() < 2) {
            throw new SemanticCheckException("'query_string' must have at least two arguments");
        }
        NamedArgumentExpression fields = (NamedArgumentExpression)iterator.next();
        NamedArgumentExpression query = (NamedArgumentExpression)iterator.next();
        ImmutableMap fieldsAndWeights = (ImmutableMap)fields.getValue().valueOf(null).tupleValue().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((ExprValue)e.getValue()).floatValue()));
        QueryStringQueryBuilder queryBuilder = this.createQueryBuilder(null, query.getValue().valueOf(null).stringValue()).fields((Map)fieldsAndWeights);
        while (iterator.hasNext()) {
            NamedArgumentExpression arg = (NamedArgumentExpression)iterator.next();
            if (!this.queryBuildActions.containsKey(arg.getArgName())) {
                throw new SemanticCheckException(String.format("Parameter %s is invalid for %s function.", arg.getArgName(), queryBuilder.getWriteableName()));
            }
            Objects.requireNonNull((RelevanceQuery.QueryBuilderStep)this.queryBuildActions.get(arg.getArgName())).apply(queryBuilder, arg.getValue().valueOf(null));
        }
        return queryBuilder;
    }

    @Override
    protected QueryStringQueryBuilder createQueryBuilder(String field, String query) {
        return QueryBuilders.queryStringQuery((String)query);
    }
}

