/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;

public class MultiMatchQuery
extends RelevanceQuery<MultiMatchQueryBuilder> {
    public MultiMatchQuery() {
        super(ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"auto_generate_synonyms_phrase_query", (b, v) -> b.autoGenerateSynonymsPhraseQuery(Boolean.parseBoolean(v.stringValue()))).put((Object)"boost", (b, v) -> (MultiMatchQueryBuilder)b.boost(Float.parseFloat(v.stringValue()))).put((Object)"cutoff_frequency", (b, v) -> b.cutoffFrequency(Float.parseFloat(v.stringValue()))).put((Object)"fuzziness", (b, v) -> b.fuzziness((Object)v.stringValue())).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(Boolean.parseBoolean(v.stringValue()))).put((Object)"lenient", (b, v) -> b.lenient(Boolean.parseBoolean(v.stringValue()))).put((Object)"max_expansions", (b, v) -> b.maxExpansions(Integer.parseInt(v.stringValue()))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"operator", (b, v) -> b.operator(Operator.fromString((String)v.stringValue()))).put((Object)"prefix_length", (b, v) -> b.prefixLength(Integer.parseInt(v.stringValue()))).put((Object)"tie_breaker", (b, v) -> b.tieBreaker(Float.parseFloat(v.stringValue()))).put((Object)"type", (b, v) -> b.type((Object)v.stringValue())).put((Object)"slop", (b, v) -> b.slop(Integer.parseInt(v.stringValue()))).put((Object)"zero_terms_query", (b, v) -> b.zeroTermsQuery(MatchQuery.ZeroTermsQuery.valueOf((String)v.stringValue()))).build());
    }

    @Override
    public QueryBuilder build(FunctionExpression func) {
        if (func.getArguments().size() < 2) {
            throw new SemanticCheckException("'multi_match' must have at least two arguments");
        }
        Iterator iterator = func.getArguments().iterator();
        NamedArgumentExpression fields = (NamedArgumentExpression)iterator.next();
        NamedArgumentExpression query = (NamedArgumentExpression)iterator.next();
        ImmutableMap fieldsAndWeights = (ImmutableMap)fields.getValue().valueOf(null).tupleValue().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((ExprValue)e.getValue()).floatValue()));
        MultiMatchQueryBuilder queryBuilder = this.createQueryBuilder(null, query.getValue().valueOf(null).stringValue()).fields((Map)fieldsAndWeights);
        while (iterator.hasNext()) {
            NamedArgumentExpression arg = (NamedArgumentExpression)iterator.next();
            if (!this.queryBuildActions.containsKey(arg.getArgName())) {
                throw new SemanticCheckException(String.format("Parameter %s is invalid for %s function.", arg.getArgName(), queryBuilder.getWriteableName()));
            }
            Objects.requireNonNull((RelevanceQuery.QueryBuilderStep)this.queryBuildActions.get(arg.getArgName())).apply(queryBuilder, arg.getValue().valueOf(null));
        }
        return queryBuilder;
    }

    @Override
    protected MultiMatchQueryBuilder createQueryBuilder(String field, String query) {
        return QueryBuilders.multiMatchQuery((Object)query, (String[])new String[0]);
    }
}

