/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.error;

import java.util.Locale;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.sql.opensearch.response.error.ErrorMessage;

public class OpenSearchErrorMessage
extends ErrorMessage {
    OpenSearchErrorMessage(OpenSearchException exception, int status) {
        super((Throwable)exception, status);
    }

    @Override
    protected String fetchReason() {
        return "Error occurred in OpenSearch engine: " + this.exception.getMessage();
    }

    @Override
    protected String fetchDetails() {
        StringBuilder details = new StringBuilder();
        if (this.exception instanceof SearchPhaseExecutionException) {
            details.append(this.fetchSearchPhaseExecutionExceptionDetails((SearchPhaseExecutionException)this.exception));
        } else {
            details.append(((OpenSearchException)this.exception).getDetailedMessage());
        }
        details.append("\nFor more details, please send request for Json format to see the raw response from OpenSearch engine.");
        return details.toString();
    }

    private String fetchSearchPhaseExecutionExceptionDetails(SearchPhaseExecutionException exception) {
        ShardSearchFailure[] shardFailures;
        StringBuilder details = new StringBuilder();
        for (ShardSearchFailure failure : shardFailures = exception.shardFailures()) {
            details.append(String.format(Locale.ROOT, "Shard[%d]: %s\n", failure.shardId(), failure.getCause().toString()));
        }
        return details.toString();
    }
}

