/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.logical.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import java.util.Set;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalIndexScan;
import org.opensearch.sql.opensearch.planner.logical.rule.OptimizationRuleUtils;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;

public class PushProjectAndRelation
implements Rule<LogicalProject> {
    private final Capture<LogicalRelation> relationCapture = Capture.newCapture();
    private final Pattern<LogicalProject> pattern = Pattern.typeOf(LogicalProject.class).matching(project -> {
        this.pushDownProjects = OptimizationRuleUtils.findReferenceExpressions(project.getProjectList());
        return !this.pushDownProjects.isEmpty();
    }).with(Patterns.source().matching(Pattern.typeOf(LogicalRelation.class).capturedAs(this.relationCapture)));
    private Set<ReferenceExpression> pushDownProjects;

    public Pattern<LogicalProject> pattern() {
        return this.pattern;
    }

    public LogicalPlan apply(LogicalProject project, Captures captures) {
        LogicalRelation relation = (LogicalRelation)captures.get(this.relationCapture);
        return new LogicalProject((LogicalPlan)OpenSearchLogicalIndexScan.builder().relationName(relation.getRelationName()).projectList(OptimizationRuleUtils.findReferenceExpressions(project.getProjectList())).build(), project.getProjectList(), project.getNamedParseExpressions());
    }
}

