/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.logical.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.planner.logical.LogicalSort;

public final class OptimizationRuleUtils {
    public static boolean sortByFieldsOnly(LogicalSort logicalSort) {
        return logicalSort.getSortList().stream().map(sort -> sort.getRight() instanceof ReferenceExpression).reduce(true, Boolean::logicalAnd);
    }

    public static Set<ReferenceExpression> findReferenceExpressions(List<NamedExpression> expressions) {
        HashSet<ReferenceExpression> projectList = new HashSet<ReferenceExpression>();
        for (NamedExpression namedExpression : expressions) {
            projectList.addAll(OptimizationRuleUtils.findReferenceExpression(namedExpression));
        }
        return projectList;
    }

    public static List<ReferenceExpression> findReferenceExpression(NamedExpression expression) {
        final ArrayList<ReferenceExpression> results = new ArrayList<ReferenceExpression>();
        expression.accept((ExpressionNodeVisitor)new ExpressionNodeVisitor<Object, Object>(){

            public Object visitReference(ReferenceExpression node, Object context) {
                return results.add(node);
            }
        }, null);
        return results;
    }

    @Generated
    private OptimizationRuleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

