/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.client;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.mapping.IndexMapping;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.threadpool.ThreadPool;

public class OpenSearchNodeClient
implements OpenSearchClient {
    public static final Function<String, Predicate<String>> ALL_FIELDS = anyIndex -> anyField -> true;
    private final ClusterService clusterService;
    private final NodeClient client;
    private final IndexNameExpressionResolver resolver;
    private static final String SQL_WORKER_THREAD_POOL_NAME = "sql-worker";

    public OpenSearchNodeClient(ClusterService clusterService, NodeClient client) {
        this.clusterService = clusterService;
        this.client = client;
        this.resolver = new IndexNameExpressionResolver(client.threadPool().getThreadContext());
    }

    @Override
    public Map<String, IndexMapping> getIndexMappings(String ... indexExpression) {
        try {
            ClusterState state = this.clusterService.state();
            String[] concreteIndices = this.resolveIndexExpression(state, indexExpression);
            return this.populateIndexMappings((ImmutableOpenMap<String, MappingMetadata>)state.metadata().findMappings(concreteIndices, ALL_FIELDS));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read mapping in cluster state for index pattern [" + indexExpression + "]", e);
        }
    }

    @Override
    public OpenSearchResponse search(OpenSearchRequest request) {
        return request.search(req -> (SearchResponse)this.client.search(req).actionGet(), req -> (SearchResponse)this.client.searchScroll(req).actionGet());
    }

    @Override
    public List<String> indices() {
        GetIndexResponse indexResponse = (GetIndexResponse)((GetIndexRequestBuilder)this.client.admin().indices().prepareGetIndex().setLocal(true)).get();
        Stream<String> aliasStream = ImmutableList.copyOf((Iterator)indexResponse.aliases().valuesIt()).stream().flatMap(Collection::stream).map(AliasMetadata::alias);
        return Stream.concat(Arrays.stream(indexResponse.getIndices()), aliasStream).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> meta() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"CLUSTER_NAME", (Object)this.clusterService.getClusterName().value());
        return builder.build();
    }

    @Override
    public void cleanup(OpenSearchRequest request) {
        request.clean(scrollId -> this.client.prepareClearScroll().addScrollId(scrollId).get());
    }

    @Override
    public void schedule(Runnable task) {
        ThreadPool threadPool = this.client.threadPool();
        threadPool.schedule(OpenSearchNodeClient.withCurrentContext(task), new TimeValue(0L), SQL_WORKER_THREAD_POOL_NAME);
    }

    @Override
    public NodeClient getNodeClient() {
        return this.client;
    }

    private String[] resolveIndexExpression(ClusterState state, String[] indices) {
        return this.resolver.concreteIndexNames(state, IndicesOptions.strictExpandOpen(), true, indices);
    }

    private Map<String, IndexMapping> populateIndexMappings(ImmutableOpenMap<String, MappingMetadata> indexMappings) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ObjectObjectCursor cursor : indexMappings) {
            result.put((Object)((String)cursor.key), (Object)new IndexMapping((MappingMetadata)cursor.value));
        }
        return result.build();
    }

    private static Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }
}

