/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.stats.eval.impl;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.IStatistic;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.vals.NamedAggregateValue;

abstract class MinMaxCommon
implements IStatistic<NamedAggregateValue> {
    private final Number initialVal;
    private Number oldVal;
    private String oldKey;
    private boolean empty;

    public MinMaxCommon(Number initialVal) {
        this.initialVal = initialVal;
        this.oldVal = initialVal;
        this.oldKey = "";
        this.empty = true;
    }

    abstract boolean shouldUpdate(Number var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculate(String key, Number value) {
        MinMaxCommon minMaxCommon = this;
        synchronized (minMaxCommon) {
            if (this.shouldUpdate(value)) {
                this.oldVal = value;
                this.oldKey = key;
            }
        }
        this.empty = false;
    }

    @Override
    public synchronized List<NamedAggregateValue> get() {
        return Collections.singletonList(new NamedAggregateValue(this.oldVal, this.type(), this.oldKey));
    }

    public Number getOldVal() {
        return this.oldVal;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }
}

