/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.CreateTableColumnStep;
import org.jooq.CreateTableConstraintStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertValuesStepN;
import org.jooq.JSONFormat;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.ClusterTemperatureSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.NodeLevelDimensionalSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.util.SQLiteQueryUtils;
import org.opensearch.performanceanalyzer.rca.persistence.PersistorBase;
import org.opensearch.performanceanalyzer.rca.persistence.RefColumn;
import org.opensearch.performanceanalyzer.rca.persistence.ValueColumn;
import org.opensearch.performanceanalyzer.rca.response.RcaResponse;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.ClusterTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.NodeTemperatureRca;

class SQLitePersistor
extends PersistorBase {
    private static final String DB_URL = "jdbc:sqlite:";
    private DSLContext create;
    private Map<String, List<Field<?>>> jooqTableColumns;
    private static final Logger LOG = LogManager.getLogger(SQLitePersistor.class);
    private static final String LAST_INSERT_ROWID = "last_insert_rowid()";
    private static final String PRIMARY_KEY_AUTOINCREMENT_POSTFIX = " INTEGER PRIMARY KEY AUTOINCREMENT";
    private Map<String, Class<?>> tableNameToJavaClassMap;
    private static final String[] GETTER_PREFIXES = new String[]{"get", "is"};
    private static final String[] SETTER_PREFIXES = new String[]{"set"};
    private static final String TABLE_NAME_JSON_KEY = "tableName";
    private static final String ROW_IDS_JSON_KEY = "rowIds";
    private Map<Class<?>, Map<java.lang.reflect.Field, GetterSetterPairs>> fieldGetterSetterPairsMap;
    private Map<Class<?>, Map<String, GetterSetterPairs>> classFieldNamesToGetterSetterMap;
    private static final String NESTED_OBJECT_COLUMN_PREFIX = "__table__";
    private static int id_test = 1;

    SQLitePersistor(String dir, String filename, String storageFileRetentionCount, TimeUnit rotationTime, long rotationPeriod) throws SQLException, IOException {
        super(dir, filename, DB_URL, storageFileRetentionCount, rotationTime, rotationPeriod);
        this.create = DSL.using((Connection)this.conn, (SQLDialect)SQLDialect.SQLITE);
        this.jooqTableColumns = new HashMap();
        this.tableNameToJavaClassMap = new HashMap();
        this.fieldGetterSetterPairsMap = new HashMap();
        this.classFieldNamesToGetterSetterMap = new HashMap();
    }

    @Override
    synchronized void createNewDSLContext() {
        if (this.create != null) {
            this.create.close();
        }
        this.create = DSL.using((Connection)this.conn, (SQLDialect)SQLDialect.SQLITE);
        this.jooqTableColumns = new HashMap();
        this.tableNameToJavaClassMap = new HashMap();
    }

    @Override
    synchronized void createTable(String tableName, List<Field<?>> columns) throws SQLException {
        CreateTableColumnStep constraintStep = this.create.createTable(tableName).column(DSL.field((String)(this.getPrimaryKeyColumnName(tableName) + PRIMARY_KEY_AUTOINCREMENT_POSTFIX))).columns(columns);
        try {
            constraintStep.execute();
            LOG.debug("Successfully created table: {}", (Object)tableName);
        }
        catch (DataAccessException ex) {
            String msg = "table " + tableName + " already exists";
            if (ex.getMessage().contains(msg)) {
                LOG.debug(ex.getMessage());
            }
            LOG.error((Object)ex);
            throw new SQLException(ex);
        }
        this.tableNames.add(tableName);
        this.jooqTableColumns.put(tableName, columns);
        LOG.debug("Added table '{}' and its columns: '{}' to in-memory registry.", (Object)tableName, columns);
    }

    @Override
    synchronized void createTable(String tableName, List<Field<?>> columns, String referenceTableName, String referenceTablePrimaryKeyFieldName) throws SQLException {
        Field foreignKeyField = DSL.field((String)referenceTablePrimaryKeyFieldName, Integer.class);
        columns.add(foreignKeyField);
        try {
            LOG.debug("Trying to create a summary table: {} that references {}", (Object)tableName, (Object)referenceTableName);
            Table referenceTable = DSL.table((String)referenceTableName);
            CreateTableConstraintStep constraintStep = this.create.createTable(tableName).column(DSL.field((String)(this.getPrimaryKeyColumnName(tableName) + PRIMARY_KEY_AUTOINCREMENT_POSTFIX))).columns(columns).constraints(new Constraint[]{DSL.constraint((String)(foreignKeyField.getName() + "_FK")).foreignKey(foreignKeyField).references(referenceTable, DSL.field((String)referenceTablePrimaryKeyFieldName))});
            constraintStep.execute();
            LOG.debug("table with fk created: {}", (Object)constraintStep.toString());
        }
        catch (DataAccessException e) {
            String msg = "table " + tableName + " already exists";
            if (e.getMessage().contains(msg)) {
                LOG.debug(e.getMessage());
            }
            LOG.error("Error creating table: {}", (Object)tableName, (Object)e);
            throw new SQLException(e);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new SQLException(ex);
        }
        this.tableNames.add(tableName);
        this.jooqTableColumns.put(tableName, columns);
    }

    @Override
    synchronized int insertRow(String tableName, List<Object> row) throws SQLException {
        int lastPrimaryKey = -1;
        String sqlQuery = "SELECT last_insert_rowid()";
        Objects.requireNonNull(this.create, "DSLContext cannot be null");
        Table table = DSL.table((String)tableName);
        List<Field<?>> columnsForTable = this.jooqTableColumns.get(tableName);
        if (columnsForTable == null) {
            LOG.error("NO columns found for table: {}. Tables: {}, columns: {}", (Object)tableName, (Object)this.tableNames, this.jooqTableColumns);
            throw new SQLException("No columns exist for table.");
        }
        InsertValuesStepN insertValuesStepN = this.create.insertInto(table).columns(columnsForTable).values(row);
        try {
            insertValuesStepN.execute();
            LOG.debug("sql insert: {}", (Object)insertValuesStepN.toString());
            lastPrimaryKey = (Integer)((Record)this.create.fetch(sqlQuery).get(0)).get(LAST_INSERT_ROWID, Integer.class);
        }
        catch (Exception e) {
            LOG.error("Failed to insert into the table {}", (Object)tableName, (Object)e);
            throw new SQLException(e);
        }
        LOG.debug("most recently inserted primary key = {}", (Object)lastPrimaryKey);
        return lastPrimaryKey;
    }

    @Override
    public synchronized <T> @Nullable T read(Class<T> clz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, DataAccessException {
        return this.read(clz, -1);
    }

    public synchronized <T> @Nullable T read(Class<T> clz, int rowId) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Result recordList;
        String tableName = SQLitePersistor.getTableNameFromClassName(clz);
        String primaryKeyCol = SQLiteQueryUtils.getPrimaryKeyColumnName(tableName);
        Field primaryKeyField = DSL.field((String)primaryKeyCol, Integer.class);
        if (rowId == -1) {
            try {
                recordList = this.create.select(new SelectField[0]).from(tableName).orderBy((OrderField)primaryKeyField.desc()).limit(1).fetch();
            }
            catch (DataAccessException dex) {
                LOG.debug("Error querying table {}", (Object)tableName, (Object)dex);
                return null;
            }
        }
        try {
            recordList = this.create.select(new SelectField[0]).from(tableName).where(new Condition[]{DSL.field((String)primaryKeyCol, Integer.class).eq((Object)rowId)}).fetch();
        }
        catch (DataAccessException dex) {
            LOG.error("Could not find data for table {}", (Object)tableName, (Object)dex);
            throw dex;
        }
        if (recordList.size() != 1) {
            throw new IllegalStateException("Expected one row, found: '" + (List)recordList + "'");
        }
        return this.readFields(clz, (Record)recordList.get(0), tableName);
    }

    @Override
    public synchronized <T, E> @Nullable List<T> readAllForMaxField(Class<T> clz, String fieldName, Class<E> fieldClz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, DataAccessException {
        Result recordsWithMaxFieldValue;
        String tableName = SQLitePersistor.getTableNameFromClassName(clz);
        Field field = DSL.field((String)fieldName, fieldClz);
        try {
            recordsWithMaxFieldValue = this.create.select(new SelectField[0]).from(tableName).where(new Condition[]{DSL.field((SelectField)field).eq((Select)this.create.select((SelectField)DSL.max((Field)field)).from(tableName))}).fetch();
        }
        catch (DataAccessException dex) {
            LOG.debug("Error querying table {}", (Object)tableName, (Object)dex);
            return null;
        }
        ArrayList<T> objList = new ArrayList<T>();
        LOG.debug("Record List {}", (Object)recordsWithMaxFieldValue);
        for (Record record : recordsWithMaxFieldValue) {
            objList.add(this.readFields(clz, record, tableName));
        }
        return objList;
    }

    public synchronized <T> @Nullable T readFields(Class<T> clz, Record record, String tableName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Map<String, GetterSetterPairs> fieldNameToGetterSetterMap = this.classFieldNamesToGetterSetterMap.get(clz);
        String primaryKeyCol = SQLiteQueryUtils.getPrimaryKeyColumnName(tableName);
        Field[] fields = record.fields();
        T obj = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field jooqField : fields) {
            String columnName = jooqField.getName();
            if (columnName.equals(primaryKeyCol)) continue;
            if (columnName.startsWith(NESTED_OBJECT_COLUMN_PREFIX)) {
                String nestedTableName = columnName.replace(NESTED_OBJECT_COLUMN_PREFIX, "");
                if (jooqField.getType() == String.class) {
                    String value = (String)jooqField.getValue(record);
                    JsonArray array = new JsonParser().parse(value).getAsJsonArray();
                    Method setter = fieldNameToGetterSetterMap.get((Object)nestedTableName).setter;
                    ArrayList collection = new ArrayList();
                    for (JsonElement element : array) {
                        JsonObject jsonObject = element.getAsJsonObject();
                        String actualTableName = jsonObject.get(TABLE_NAME_JSON_KEY).getAsString();
                        Class<?> actualTableClass = this.tableNameToJavaClassMap.get(actualTableName);
                        if (actualTableClass == null) {
                            throw new IllegalStateException("The table name '" + actualTableName + "' does not exist in the table to class mapping. Butthe database row mentions it: " + element.toString());
                        }
                        for (JsonElement rowIdElem : jsonObject.get(ROW_IDS_JSON_KEY).getAsJsonArray()) {
                            int rowIdNestedTable = rowIdElem.getAsInt();
                            Object nestedObj = this.read(actualTableClass, rowIdNestedTable);
                            collection.add(nestedObj);
                        }
                    }
                    setter.invoke(obj, collection);
                    continue;
                }
                if (jooqField.getType() == Integer.class) {
                    if (fieldNameToGetterSetterMap.get(nestedTableName) == null) {
                        throw new IllegalStateException("No Field Mapping exist for column name " + jooqField.getName() + " of table " + tableName);
                    }
                    Method setter = fieldNameToGetterSetterMap.get((Object)nestedTableName).setter;
                    if (setter.getParameterTypes().length != 1) {
                        throw new IllegalStateException("A setter " + setter.getName() + " of class " + clz.getSimpleName() + " accepts more than one arguments.");
                    }
                    Class<?> setterType = setter.getParameterTypes()[0];
                    int nestedRowId = (Integer)jooqField.cast(Integer.class).getValue(record);
                    Object nestedObj = this.read(setterType, nestedRowId);
                    setter.invoke(obj, nestedObj);
                    continue;
                }
                throw new IllegalStateException("ReferenceColumn can be either Integer or String.");
            }
            Method setter = fieldNameToGetterSetterMap.get((Object)jooqField.getName()).setter;
            setter.invoke(obj, jooqField.getType().cast(jooqField.getValue(record)));
        }
        return obj;
    }

    @Override
    synchronized <T> void writeImpl(T obj) throws IllegalStateException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SQLException, IllegalAccessException {
        this.writeImplInner(obj);
    }

    private static String getTableNameFromClassName(Class<?> clz) {
        return clz.getSimpleName();
    }

    private Class<?> getGenericParamTypeOfMethodReturn(Method method) {
        ParameterizedType mtype = (ParameterizedType)method.getGenericReturnType();
        return this.getFirstTypeFromParameterizedTypes(mtype, method.getName());
    }

    private Class<?> getGenericFieldType(java.lang.reflect.Field field) {
        ParameterizedType mtype = (ParameterizedType)field.getGenericType();
        return this.getFirstTypeFromParameterizedTypes(mtype, field.getName());
    }

    private Class<?> getFirstTypeFromParameterizedTypes(ParameterizedType mtype, String name) {
        Type[] mTypeArguments = mtype.getActualTypeArguments();
        if (mTypeArguments.length != 1) {
            throw new IllegalStateException("Expected list of a single type. Please check field/method: " + name);
        }
        Class mTypeArgClass = (Class)mTypeArguments[0];
        return mTypeArgClass;
    }

    private void checkPublic(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException("Found '" + method.getName() + "'. But it is not public.");
        }
    }

    private String capitalize(String name) {
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private void checkValidType(java.lang.reflect.Field field, Class<?> clz) {
        Type type = field.getGenericType();
        Annotation[] annotation = field.getAnnotations();
        StringBuilder err = new StringBuilder();
        err.append("[class: ").append(clz.getSimpleName()).append(":field:").append(field.getName()).append("]::");
        if (annotation.length != 1) {
            err.append("A field can have either ").append(ValueColumn.class.getSimpleName()).append(" or ").append(RefColumn.class.getSimpleName()).append(" not both");
            throw new IllegalStateException(err.toString());
        }
        if (annotation[0].annotationType() == RefColumn.class) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
                if (actualType.isPrimitive() || actualType == String.class) {
                    err.append("RefColumn can only be used for a user defined class or a Collection of user-defined class NOT a primitive or String type");
                    throw new IllegalStateException(err.toString());
                }
            } else {
                Class<?> justType = field.getType();
                if (justType.isPrimitive() || justType == String.class) {
                    err.append("RefColumn can only be used for a user defined class or a Collection of user-defined class NOT a primitive or String type");
                    throw new IllegalStateException(err.toString());
                }
            }
        } else if (type instanceof ParameterizedType) {
            err.append("persisting Primitives or Strings as Parameterized Types is not supported.");
            throw new IllegalStateException(err.toString());
        }
    }

    private <T> void createFieldRegistry(Class<T> clz) throws IllegalStateException, NoSuchMethodException {
        this.fieldGetterSetterPairsMap.putIfAbsent(clz, new HashMap());
        this.classFieldNamesToGetterSetterMap.putIfAbsent(clz, new HashMap());
        Map<java.lang.reflect.Field, GetterSetterPairs> fieldToGetterSetterMap = this.fieldGetterSetterPairsMap.get(clz);
        Map<String, GetterSetterPairs> fieldNameToGetterSetterMap = this.classFieldNamesToGetterSetterMap.get(clz);
        for (java.lang.reflect.Field field : clz.getDeclaredFields()) {
            Method method;
            String key;
            if (!field.isAnnotationPresent(ValueColumn.class) && !field.isAnnotationPresent(RefColumn.class)) continue;
            this.checkValidType(field, clz);
            GetterSetterPairs pair = new GetterSetterPairs();
            String capitalizedFieldName = this.capitalize(field.getName());
            for (String prefix : GETTER_PREFIXES) {
                key = prefix + capitalizedFieldName;
                try {
                    method = clz.getDeclaredMethod(key, new Class[0]);
                }
                catch (NoSuchMethodException nom) {
                    continue;
                }
                if (method.getReturnType() != field.getType()) {
                    StringBuilder sb = new StringBuilder("The return type of the getter '");
                    sb.append(key).append("' (").append(method.getReturnType()).append(") and field '").append(field.getName()).append("' (").append(field.getType()).append(") don't match.");
                    throw new NoSuchMethodException(sb.toString());
                }
                this.checkPublic(method);
                pair.getter = method;
                break;
            }
            for (String prefix : SETTER_PREFIXES) {
                key = prefix + capitalizedFieldName;
                try {
                    method = clz.getDeclaredMethod(key, field.getType());
                    this.checkPublic(method);
                    pair.setter = method;
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            if (pair.getter == null) {
                throw new NoSuchMethodException(this.getNoGetterSetterExist(clz, field, GetterOrSetter.GETTER));
            }
            if (pair.setter == null) {
                throw new NoSuchMethodException(this.getNoGetterSetterExist(clz, field, GetterOrSetter.SETTER));
            }
            fieldToGetterSetterMap.put(field, pair);
            fieldNameToGetterSetterMap.put(field.getName(), pair);
        }
    }

    private String getNoGetterSetterExist(Class<?> clz, java.lang.reflect.Field field, GetterOrSetter getterOrSetter) {
        String type;
        switch (getterOrSetter) {
            case GETTER: {
                type = "getter";
                break;
            }
            case SETTER: {
                type = "setter";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized type: " + getterOrSetter);
            }
        }
        StringBuilder sb = new StringBuilder("Could not find '");
        sb.append(type).append("' for the field '").append(field.getName()).append("' of class '").append(clz.getName()).append("'. Getters are expected to start with 'get' or 'is' and setters are expected to start with 'set' and they are required to end with the name of the field (case insensitive.)");
        return sb.toString();
    }

    private <T> ColumnValuePair writeCollectionReferenceColumn(java.lang.reflect.Field field, Method getter, T obj) throws InvocationTargetException, IllegalAccessException, SQLException, NoSuchMethodException {
        ColumnValuePair columnValuePair = new ColumnValuePair();
        String columnName = NESTED_OBJECT_COLUMN_PREFIX + field.getName();
        Collection collection = (Collection)getter.getReturnType().cast(getter.invoke(obj, new Object[0]));
        HashMap nestedPrimaryKeys = new HashMap();
        for (Object o : collection) {
            String myActualType = o.getClass().getSimpleName();
            nestedPrimaryKeys.putIfAbsent(myActualType, new ArrayList());
            Class<?> typeArgClass = this.getGenericParamTypeOfMethodReturn(getter);
            int id = this.writeImplInner(typeArgClass.cast(o));
            ((List)nestedPrimaryKeys.get(myActualType)).add(id);
        }
        JsonArray json = new JsonArray();
        for (Map.Entry colNameEntry : nestedPrimaryKeys.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArrayInner = new JsonArray();
            ((List)colNameEntry.getValue()).forEach(rowId -> jsonArrayInner.add((Number)rowId));
            jsonObject.addProperty(TABLE_NAME_JSON_KEY, (String)colNameEntry.getKey());
            jsonObject.add(ROW_IDS_JSON_KEY, (JsonElement)jsonArrayInner);
            json.add((JsonElement)jsonObject);
        }
        columnValuePair.field = DSL.field((Name)DSL.name((String)columnName), String.class);
        columnValuePair.value = json.toString();
        return columnValuePair;
    }

    private <T> int writeImplInner(T obj) throws IllegalStateException, IllegalAccessException, InvocationTargetException, SQLException, NoSuchMethodException {
        Class<?> clz = obj.getClass();
        String tableName = SQLitePersistor.getTableNameFromClassName(clz);
        Table table = DSL.table((String)tableName);
        if (this.jooqTableColumns.containsKey(tableName)) {
            Class<?> alreadyStoredTableClass = this.tableNameToJavaClassMap.get(tableName);
            Objects.requireNonNull(alreadyStoredTableClass, "A table exists with this name but the table is not mapped to a Java class.");
            if (alreadyStoredTableClass != clz) {
                throw new IllegalStateException("There is already a table in the Database with the same name. It belongs to the class: '" + alreadyStoredTableClass + "'. Please consider re-naming your classes.");
            }
            Objects.requireNonNull(this.fieldGetterSetterPairsMap.get(clz), "Because the class is already persisted once, we should have the mapping for field to their corresponding getter and setters.");
        } else {
            this.createFieldRegistry(clz);
        }
        Map<java.lang.reflect.Field, GetterSetterPairs> fieldToGetterSetterMap = this.fieldGetterSetterPairsMap.get(clz);
        ArrayList fields = new ArrayList();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<java.lang.reflect.Field, GetterSetterPairs> entry : fieldToGetterSetterMap.entrySet()) {
            Method getter = entry.getValue().getter;
            java.lang.reflect.Field classField = entry.getKey();
            Object columnName = classField.getName();
            Class<?> retType = getter.getReturnType();
            if (classField.isAnnotationPresent(RefColumn.class)) {
                columnName = NESTED_OBJECT_COLUMN_PREFIX + (String)columnName;
                if (Collection.class.isAssignableFrom(retType)) {
                    ColumnValuePair columnValuePair = this.writeCollectionReferenceColumn(classField, getter, obj);
                    fields.add(columnValuePair.field);
                    values.add(columnValuePair.value);
                    continue;
                }
                int id = this.writeImplInner(retType.cast(getter.invoke(obj, new Object[0])));
                fields.add(DSL.field((Name)DSL.name((String)columnName), Integer.class));
                values.add(id);
                continue;
            }
            if (retType.isPrimitive()) {
                fields.add(DSL.field((Name)DSL.name((String)columnName), retType));
                values.add(getter.invoke(obj, new Object[0]));
                continue;
            }
            if (retType != String.class) continue;
            fields.add(DSL.field((Name)DSL.name((String)columnName), String.class));
            values.add(getter.invoke(obj, new Object[0]));
        }
        if (fields.size() == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Class ").append(clz.getSimpleName()).append(" was asked to be persisted but there are no fields with annotations: ").append(ValueColumn.class.getSimpleName()).append(" or ").append(RefColumn.class.getSimpleName());
            throw new IllegalStateException(sb.toString());
        }
        if (!this.jooqTableColumns.containsKey(tableName)) {
            this.createTable(tableName, fields);
            this.tableNameToJavaClassMap.put(tableName, obj.getClass());
        }
        try {
            int sb = this.create.insertInto(table).columns(fields).values(values).execute();
        }
        catch (Exception e) {
            LOG.error("Inserting row '{}' into table '{}' failed", values, (Object)tableName, (Object)e);
            throw new SQLException(e);
        }
        int lastRowId = -1;
        String sqlQuery = "SELECT last_insert_rowid()";
        try {
            lastRowId = (Integer)((Record)this.create.fetch(sqlQuery).get(0)).get(LAST_INSERT_ROWID, Integer.class);
        }
        catch (Exception e) {
            LOG.error("Failed to insert into the table {}", (Object)table, (Object)e);
            throw new SQLException(e);
        }
        LOG.debug("most recently inserted primary key = {}", (Object)lastRowId);
        return lastRowId;
    }

    @Override
    synchronized String readTables() {
        JsonParser jsonParser = new JsonParser();
        JsonObject tablesObject = new JsonObject();
        this.tableNames.forEach(table -> {
            String tableStr = this.readTable((String)table);
            try {
                JsonElement tableElement = jsonParser.parse(tableStr);
                tablesObject.add(table, tableElement);
            }
            catch (JsonSyntaxException se) {
                LOG.error("RCA: Json parsing fails when reading from table {}", table);
            }
        });
        return tablesObject.toString();
    }

    @Override
    @VisibleForTesting
    public synchronized Map<String, Result<Record>> getRecordsForAllTables() {
        HashMap<String, Result<Record>> results = new HashMap<String, Result<Record>>();
        this.tableNames.forEach(table -> results.put((String)table, this.getRecords((String)table)));
        return results;
    }

    @Override
    public synchronized List<String> getAllPersistedRcas() {
        List<String> uniquePersistedRcas = new ArrayList<String>();
        try {
            uniquePersistedRcas = this.create.selectDistinct(ResourceFlowUnit.ResourceFlowUnitFieldValue.RCA_NAME_FILELD.getField()).from("RCA").fetch(0).stream().collect(Collectors.toList());
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        return uniquePersistedRcas;
    }

    private synchronized String readTable(String tableName) {
        String tableStr;
        try {
            Result result = tableName.equals("RCA") ? this.create.select(new SelectField[0]).from(tableName).orderBy(ResourceFlowUnit.ResourceFlowUnitFieldValue.RCA_NAME_FILELD.getField()).fetch() : this.create.select(new SelectField[0]).from(tableName).fetch();
            tableStr = result.formatJSON(new JSONFormat().header(false));
        }
        catch (DataAccessException e) {
            LOG.error("Fail to read table {}", (Object)tableName);
            tableStr = "[]";
        }
        return tableStr;
    }

    @javax.annotation.Nullable
    private synchronized Result<Record> getRecords(String tableName) {
        try {
            Result result = tableName.equals("RCA") ? this.create.select(new SelectField[0]).from(tableName).orderBy(ResourceFlowUnit.ResourceFlowUnitFieldValue.RCA_NAME_FILELD.getField()).fetch() : this.create.select(new SelectField[0]).from(tableName).fetch();
            return result;
        }
        catch (DataAccessException e) {
            LOG.error("Fail to read table {}", (Object)tableName);
            return null;
        }
    }

    private JsonElement constructFullTemperatureProfile() {
        JsonObject rcaResponseJson = null;
        JsonArray nodeDimensionalSummary = null;
        String summaryName = "NodeLevelDimensionalSummary";
        for (String dimension : SQLiteQueryUtils.temperatureProfileDimensionRCASet) {
            if (rcaResponseJson == null) {
                rcaResponseJson = this.readTemperatureProfileRca(dimension).getAsJsonObject();
                JsonElement elem = rcaResponseJson.get(summaryName);
                if (elem == null) {
                    rcaResponseJson = null;
                    continue;
                }
                nodeDimensionalSummary = rcaResponseJson.get(summaryName).getAsJsonArray();
                nodeDimensionalSummary.get(0).getAsJsonObject().addProperty("timestamp", rcaResponseJson.get("timestamp").getAsString());
                continue;
            }
            JsonObject resp = this.readTemperatureProfileRca(dimension).getAsJsonObject();
            if (resp == null || resp.getAsJsonObject().get(summaryName) == null) continue;
            JsonObject obj = resp.getAsJsonObject().get(summaryName).getAsJsonArray().get(0).getAsJsonObject();
            obj.addProperty("timestamp", resp.get("timestamp").getAsString());
            nodeDimensionalSummary.add((JsonElement)obj);
        }
        if (rcaResponseJson != null) {
            rcaResponseJson.remove("rca_name");
            rcaResponseJson.remove("state");
            rcaResponseJson.remove("timestamp");
        }
        return rcaResponseJson;
    }

    private synchronized void readSummary(GenericSummary upperLevelSummary, int upperLevelPrimaryKey) {
        String upperLevelTable = upperLevelSummary.getTableName();
        if (upperLevelSummary.getNestedSummaryTables() == null) {
            return;
        }
        for (String nestedTableName : upperLevelSummary.getNestedSummaryTables()) {
            Field foreignKeyField = DSL.field((String)SQLiteQueryUtils.getPrimaryKeyColumnName(upperLevelTable), Integer.class);
            SelectJoinStep<Record> rcaQuery = SQLiteQueryUtils.buildSummaryQuery(this.create, nestedTableName, upperLevelPrimaryKey, (Field<Integer>)foreignKeyField);
            try {
                Result recordList = rcaQuery.fetch();
                for (Record record : recordList) {
                    GenericSummary summary = upperLevelSummary.buildNestedSummary(nestedTableName, record);
                    if (summary == null) continue;
                    Field primaryKeyField = DSL.field((String)SQLiteQueryUtils.getPrimaryKeyColumnName(summary.getTableName()), Integer.class);
                    this.readSummary(summary, (Integer)record.get(primaryKeyField));
                }
            }
            catch (DataAccessException de) {
                LOG.warn("Fail to read Summary table : {}, query = {}", (Object)nestedTableName, (Object)rcaQuery.toString(), (Object)de);
            }
            catch (IllegalArgumentException ie) {
                LOG.error("Reading nested summary from wrong table, message : {}", (Object)ie.getMessage());
            }
        }
    }

    private synchronized JsonElement getTemperatureRca(String rca) {
        JsonElement temperatureRcaJson;
        switch (rca) {
            case "AllTemperatureDimensions": {
                temperatureRcaJson = this.constructFullTemperatureProfile();
                break;
            }
            default: {
                temperatureRcaJson = this.readTemperatureProfileRca(rca);
            }
        }
        return temperatureRcaJson;
    }

    private synchronized JsonElement getNonTemperatureRcas(String rca) {
        RcaResponse response;
        block4: {
            response = null;
            Field primaryKeyField = DSL.field((String)SQLiteQueryUtils.getPrimaryKeyColumnName("RCA"), Integer.class);
            SelectJoinStep<Record> rcaQuery = SQLiteQueryUtils.buildRcaQuery(this.create, rca);
            try {
                Record mostRecentRecord;
                Result recordList = rcaQuery.fetch();
                if (recordList.size() > 0 && (response = RcaResponse.buildResponse(mostRecentRecord = (Record)recordList.get(0))).getState().equals(Resources.State.UNHEALTHY.toString())) {
                    this.readSummary(response, (Integer)mostRecentRecord.get(primaryKeyField));
                }
            }
            catch (DataAccessException de) {
                if (de.getMessage().contains("no such table")) break block4;
                LOG.error("Fail to read RCA : {}.", (Object)rca, (Object)de);
            }
        }
        JsonElement ret = null;
        if (response != null) {
            ret = response.toJson();
        }
        return ret;
    }

    @Override
    public synchronized JsonElement readRca(String rca) {
        JsonElement json = SQLiteQueryUtils.isTemperatureProfileRca(rca) ? this.getTemperatureRca(rca) : this.getNonTemperatureRcas(rca);
        return json;
    }

    private synchronized JsonElement readTemperatureProfileRca(String rca) {
        RcaResponse response = null;
        Field primaryKeyField = DSL.field((String)SQLiteQueryUtils.getPrimaryKeyColumnName("RCA"), Integer.class);
        SelectJoinStep<Record> rcaQuery = SQLiteQueryUtils.buildRcaQuery(this.create, rca);
        try {
            Result recordList = rcaQuery.fetch();
            if (recordList == null || recordList.isEmpty()) {
                return new JsonObject();
            }
            Record mostRecentRecord = (Record)recordList.get(0);
            response = RcaResponse.buildResponse(mostRecentRecord);
            if (rca.equals(ClusterTemperatureRca.TABLE_NAME)) {
                SelectJoinStep<Record> query = SQLiteQueryUtils.buildSummaryQuery(this.create, ClusterTemperatureSummary.TABLE_NAME, (Integer)mostRecentRecord.get(primaryKeyField), (Field<Integer>)primaryKeyField);
                Result temperatureSummary = query.fetch();
                ClusterTemperatureSummary summary = ClusterTemperatureSummary.buildSummaryFromDatabase((Result<Record>)temperatureSummary, this.create);
                response.addNestedSummaryList(summary);
            } else if (rca.equalsIgnoreCase(NodeTemperatureRca.TABLE_NAME)) {
                SelectJoinStep<Record> query = SQLiteQueryUtils.buildSummaryQuery(this.create, CompactNodeSummary.TABLE_NAME, (Integer)mostRecentRecord.get(primaryKeyField), (Field<Integer>)primaryKeyField);
                Result nodeTemperatureCompactSummary = query.fetch();
                CompactNodeSummary summary = CompactNodeSummary.buildSummaryFromDatabase((Result<Record>)nodeTemperatureCompactSummary, this.create);
                response.addNestedSummaryList(summary);
            } else {
                SelectJoinStep<Record> query = SQLiteQueryUtils.buildSummaryQuery(this.create, "NodeLevelDimensionalSummary", (Integer)mostRecentRecord.get(primaryKeyField), (Field<Integer>)primaryKeyField);
                Result result = query.fetch();
                NodeLevelDimensionalSummary nodeLevelDimSummary = NodeLevelDimensionalSummary.buildFromDb((Record)result.get(0), this.create);
                response.addNestedSummaryList(nodeLevelDimSummary);
            }
        }
        catch (DataAccessException dex) {
            JsonObject json = new JsonObject();
            if (dex.getMessage().contains("no such table")) {
                json.addProperty("error", "RCAs are not created yet.");
            } else {
                LOG.error("Failed to read temperature profile RCA for {}.", (Object)rca, (Object)dex);
                json.addProperty("error", "Failed to read temperature profile RCA.");
            }
            return json;
        }
        return response.toJson();
    }

    private static class GetterSetterPairs {
        Method getter = null;
        Method setter = null;

        private GetterSetterPairs() {
        }
    }

    private static enum GetterOrSetter {
        GETTER,
        SETTER,
        NEITHER;

    }

    private static class ColumnValuePair {
        Field<?> field;
        Object value;

        private ColumnValuePair() {
        }
    }
}

