/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core;

import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config<T> {
    private static final Logger LOG = LogManager.getLogger(Config.class);
    private String key;
    private T value;

    public Config(String key, @Nullable Map<String, Object> parentConfig, T defaultValue, Class<? extends T> clazz) {
        this(key, parentConfig, (T)defaultValue, (Predicate<? extends T>)((Predicate<Object>)s -> true), clazz);
    }

    public Config(String key, @Nullable Map<String, Object> parentConfig, T defaultValue, Predicate<T> validator, Class<? extends T> clazz) {
        this.key = key;
        this.value = defaultValue;
        if (parentConfig != null) {
            try {
                T configValue = clazz.cast(parentConfig.getOrDefault(key, defaultValue));
                if (!validator.test(configValue)) {
                    LOG.error("Config value: [{}] provided for key: [{}] is invalid", configValue, (Object)key);
                } else {
                    this.value = configValue;
                }
            }
            catch (ClassCastException e) {
                LOG.error("rca.conf contains invalid value for key: [{}], trace : [{}]", (Object)key, (Object)e.getMessage());
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }
}

