/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.action.GetAlertsRequest;
import org.opensearch.alerting.action.GetAlertsResponse;
import org.opensearch.alerting.model.Alert;
import org.opensearch.alerting.model.Table;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportGetAlertsActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014J&\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&2\b\u0010*\u001a\u0004\u0018\u00010+J\u001c\u0010,\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lorg/opensearch/alerting/transport/TransportGetAlertsAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/GetAlertsRequest;", "Lorg/opensearch/alerting/action/GetAlertsResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "getAlertsRequest", "actionListener", "Lorg/opensearch/action/ActionListener;", "resolve", "searchSourceBuilder", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "user", "Lorg/opensearch/commons/authuser/User;", "search", "opensearch-alerting"})
public final class TransportGetAlertsAction
extends HandledTransportAction<GetAlertsRequest, GetAlertsResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetAlertsAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/alerts/get", transportService, actionFilters, GetAlertsRequest::new);
        this.client = client;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.listenFilterBySettingChange(clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetAlertsRequest getAlertsRequest, @NotNull ActionListener<GetAlertsResponse> actionListener) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)getAlertsRequest), (String)"getAlertsRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        User user = this.readUserFromThreadContext(this.client);
        Table tableProp = getAlertsRequest.getTable();
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)tableProp.getSortString()).order(SortOrder.fromString((String)tableProp.getSortOrder()));
        CharSequence charSequence2 = tableProp.getMissing();
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            sortBuilder.missing((Object)tableProp.getMissing());
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!Intrinsics.areEqual((Object)getAlertsRequest.getSeverityLevel(), (Object)"ALL")) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"severity", (String)getAlertsRequest.getSeverityLevel()));
        }
        if (!Intrinsics.areEqual((Object)getAlertsRequest.getAlertState(), (Object)"ALL")) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"state", (String)getAlertsRequest.getAlertState()));
        }
        if (getAlertsRequest.getMonitorId() != null) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)getAlertsRequest.getMonitorId()));
        }
        if (!((charSequence = (CharSequence)tableProp.getSearchString()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)tableProp.getSearchString()).defaultOperator(Operator.AND).field("monitor_name").field("trigger_name"));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).sort((SortBuilder)sortBuilder).size(tableProp.getSize()).from(tableProp.getStartIndex());
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)searchSourceBuilder, (String)"searchSourceBuilder");
            this.resolve(searchSourceBuilder, actionListener, user);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void resolve(@NotNull SearchSourceBuilder searchSourceBuilder, @NotNull ActionListener<GetAlertsResponse> actionListener, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (user == null) {
            this.search(searchSourceBuilder, actionListener);
        } else if (!this.doFilterForUser(user)) {
            this.search(searchSourceBuilder, actionListener);
        } else {
            try {
                TransportGetAlertsActionKt.access$getLog$p().info("Filtering result by: " + user.getBackendRoles());
                OpenSearchExtensionsKt.addFilter((User)user, (SearchSourceBuilder)searchSourceBuilder, (String)"monitor_user.backend_roles.keyword");
                this.search(searchSourceBuilder, actionListener);
            }
            catch (IOException ex) {
                actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
            }
        }
    }

    public final void search(@NotNull SearchSourceBuilder searchSourceBuilder, @NotNull ActionListener<GetAlertsResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        String[] stringArray = new String[]{".opendistro-alerting-alert*"};
        SearchRequest searchRequest = new SearchRequest().indices(stringArray).source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(actionListener, this){
            final /* synthetic */ ActionListener<GetAlertsResponse> $actionListener;
            final /* synthetic */ TransportGetAlertsAction this$0;
            {
                this.$actionListener = $actionListener;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull SearchResponse response2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Integer n;
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                TotalHits totalHits = response2.getHits().getTotalHits();
                if (totalHits == null) {
                    n = null;
                } else {
                    long l = totalHits.value;
                    n = (int)l;
                }
                Integer totalAlertCount = n;
                Object object = response2.getHits();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.hits");
                object = (Iterable)object;
                TransportGetAlertsAction transportGetAlertsAction = this.this$0;
                boolean $i$f$map = false;
                void var8_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void hit;
                    SearchHit searchHit = (SearchHit)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)transportGetAlertsAction.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (XContentType)XContentType.JSON);
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                    String string = hit.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hit.id");
                    Alert alert = Alert.Companion.parse(xcp, string, hit.getVersion());
                    collection.add(alert);
                }
                List alerts = (List)destination$iv$iv;
                this.$actionListener.onResponse((Object)((Object)new GetAlertsResponse(alerts, totalAlertCount)));
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$actionListener.onFailure(t);
            }
        });
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }
}

