/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.BucketLevelMonitorRunner;
import org.opensearch.alerting.MonitorRunner;
import org.opensearch.alerting.MonitorRunnerExecutionContext;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.alerts.AlertError;
import org.opensearch.alerting.model.ActionRunResult;
import org.opensearch.alerting.model.Alert;
import org.opensearch.alerting.model.BucketLevelTrigger;
import org.opensearch.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.alerting.model.InputRunResults;
import org.opensearch.alerting.model.Monitor;
import org.opensearch.alerting.model.MonitorRunResult;
import org.opensearch.alerting.model.Trigger;
import org.opensearch.alerting.model.action.Action;
import org.opensearch.alerting.model.action.AlertCategory;
import org.opensearch.alerting.model.action.PerAlertActionScope;
import org.opensearch.alerting.model.action.PerExecutionActionScope;
import org.opensearch.alerting.opensearchapi.InjectorContextElement;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.script.BucketLevelTriggerExecutionContext;
import org.opensearch.alerting.script.TriggerExecutionContext;
import org.opensearch.alerting.util.AlertingUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0002J?\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/alerting/BucketLevelMonitorRunner;", "Lorg/opensearch/alerting/MonitorRunner;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getActionContextForAlertCategory", "Lorg/opensearch/alerting/script/BucketLevelTriggerExecutionContext;", "alertCategory", "Lorg/opensearch/alerting/model/action/AlertCategory;", "alert", "Lorg/opensearch/alerting/model/Alert;", "ctx", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "runMonitor", "Lorg/opensearch/alerting/model/MonitorRunResult;", "Lorg/opensearch/alerting/model/BucketLevelTriggerRunResult;", "monitor", "Lorg/opensearch/alerting/model/Monitor;", "monitorCtx", "Lorg/opensearch/alerting/MonitorRunnerExecutionContext;", "periodStart", "Ljava/time/Instant;", "periodEnd", "dryrun", "", "(Lorg/opensearch/alerting/model/Monitor;Lorg/opensearch/alerting/MonitorRunnerExecutionContext;Ljava/time/Instant;Ljava/time/Instant;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-alerting"})
public final class BucketLevelMonitorRunner
extends MonitorRunner {
    @NotNull
    public static final BucketLevelMonitorRunner INSTANCE = new BucketLevelMonitorRunner();
    private static final Logger logger = LogManager.getLogger(INSTANCE.getClass());

    private BucketLevelMonitorRunner() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public Object runMonitor(@NotNull Monitor var1_1, @NotNull MonitorRunnerExecutionContext var2_2, @NotNull Instant var3_3, @NotNull Instant var4_4, boolean var5_5, @NotNull Continuation<? super MonitorRunResult<BucketLevelTriggerRunResult>> var6_6) {
        block67: {
            block65: {
                block68: {
                    block66: {
                        if (!(var6_6 instanceof runMonitor.1)) ** GOTO lbl-1000
                        var46_7 = var6_6;
                        if ((var46_7.label & -2147483648) != 0) {
                            var46_7.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var6_6){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                Object L$5;
                                Object L$6;
                                Object L$7;
                                Object L$8;
                                Object L$9;
                                Object L$10;
                                Object L$11;
                                Object L$12;
                                Object L$13;
                                Object L$14;
                                Object L$15;
                                Object L$16;
                                Object L$17;
                                Object L$18;
                                Object L$19;
                                Object L$20;
                                Object L$21;
                                Object L$22;
                                Object L$23;
                                Object L$24;
                                Object L$25;
                                boolean Z$0;
                                boolean Z$1;
                                /* synthetic */ Object result;
                                final /* synthetic */ BucketLevelMonitorRunner this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.runMonitor((Monitor)null, (MonitorRunnerExecutionContext)null, (Instant)null, (Instant)null, false, (Continuation<? super MonitorRunResult<BucketLevelTriggerRunResult>>)((Continuation)this));
                                }
                            };
                        }
                        $result = $continuation.result;
                        var47_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                roles = MonitorRunnerService.INSTANCE.getRolesForMonitor$opensearch_alerting(monitor);
                                BucketLevelMonitorRunner.logger.debug("Running monitor: " + monitor.getName() + " with roles: " + roles + " Thread: " + Thread.currentThread().getName());
                                if (Intrinsics.areEqual((Object)periodStart, (Object)periodEnd)) {
                                    BucketLevelMonitorRunner.logger.warn("Start and end time are the same: " + periodStart + ". This monitor will probably only run once.");
                                }
                                monitorResult = new Ref.ObjectRef();
                                monitorResult.element = new MonitorRunResult<TriggerResult>(monitor.getName(), periodStart, periodEnd, null, null, null, 56, null);
                                v0 = monitorCtx.getAlertIndices();
                                Intrinsics.checkNotNull((Object)v0);
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = monitorCtx;
                                $continuation.L$3 = periodStart;
                                $continuation.L$4 = periodEnd;
                                $continuation.L$5 = roles;
                                $continuation.L$6 = monitorResult;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 1;
                                v1 = v0.createOrUpdateAlertIndex((Continuation<? super Unit>)$continuation);
                                ** if (v1 != var47_9) goto lbl34
lbl33:
                                // 1 sources

                                return var47_9;
lbl34:
                                // 1 sources

                                ** GOTO lbl48
                            }
                            case 1: {
                                dryrun = $continuation.Z$0;
                                monitorResult = (Ref.ObjectRef)$continuation.L$6;
                                roles = (List)$continuation.L$5;
                                periodEnd = (Instant)$continuation.L$4;
                                periodStart = (Instant)$continuation.L$3;
                                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (BucketLevelMonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl48:
                                // 2 sources

                                v2 = monitorCtx.getAlertIndices();
                                Intrinsics.checkNotNull((Object)v2);
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = monitorCtx;
                                $continuation.L$3 = periodStart;
                                $continuation.L$4 = periodEnd;
                                $continuation.L$5 = roles;
                                $continuation.L$6 = monitorResult;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 2;
                                v3 = v2.createOrUpdateInitialAlertHistoryIndex((Continuation<? super Unit>)$continuation);
                                ** if (v3 != var47_9) goto lbl62
lbl61:
                                // 1 sources

                                return var47_9;
lbl62:
                                // 1 sources

                                ** GOTO lbl76
                            }
                            case 2: {
                                dryrun = $continuation.Z$0;
                                monitorResult = (Ref.ObjectRef)$continuation.L$6;
                                roles = (List)$continuation.L$5;
                                periodEnd = (Instant)$continuation.L$4;
                                periodStart = (Instant)$continuation.L$3;
                                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (BucketLevelMonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl76:
                                // 2 sources

                                v4 = monitorCtx.getAlertService();
                                Intrinsics.checkNotNull((Object)v4);
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = monitorCtx;
                                $continuation.L$3 = periodStart;
                                $continuation.L$4 = periodEnd;
                                $continuation.L$5 = roles;
                                $continuation.L$6 = monitorResult;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 3;
                                v5 = v4.loadCurrentAlertsForBucketLevelMonitor(monitor, (Continuation<? super Map<Trigger, ? extends Map<String, Alert>>>)$continuation);
                                ** if (v5 != var47_9) goto lbl90
lbl89:
                                // 1 sources

                                return var47_9;
lbl90:
                                // 1 sources

                                ** GOTO lbl104
                            }
                            case 3: {
                                dryrun = $continuation.Z$0;
                                monitorResult = (Ref.ObjectRef)$continuation.L$6;
                                roles = (List)$continuation.L$5;
                                periodEnd = (Instant)$continuation.L$4;
                                periodStart = (Instant)$continuation.L$3;
                                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (BucketLevelMonitorRunner)$continuation.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
lbl104:
                                    // 2 sources

                                    var10_12 = (Map)v5;
                                }
                                catch (Exception e) {
                                    var13_15 = monitor.getId();
                                    var13_15 = StringsKt.trim((CharSequence)var13_15).toString();
                                    id = var13_15.length() == 0 != false ? "_na_" : monitor.getId();
                                    BucketLevelMonitorRunner.logger.error("Error loading alerts for monitor: " + id, (Throwable)e);
                                    return MonitorRunResult.copy$default((MonitorRunResult)monitorResult.element, null, null, null, e, null, null, 55, null);
                                }
                                currentAlerts = var10_12;
                                triggerResults = new LinkedHashMap<K, V>();
                                triggerContexts = new LinkedHashMap<K, V>();
                                nextAlerts = new LinkedHashMap<K, V>();
                                firstIteration = new Ref.BooleanRef();
                                firstIteration.element = true;
                                firstPageOfInputResults = new Ref.ObjectRef();
                                firstPageOfInputResults.element = new InputRunResults(CollectionsKt.emptyList(), null, null, 4, null);
lbl120:
                                // 2 sources

                                while (true) {
                                    v6 = monitor.getId();
                                    v7 = monitorCtx.getSettings();
                                    Intrinsics.checkNotNull((Object)v7);
                                    v8 = monitorCtx.getThreadPool();
                                    Intrinsics.checkNotNull((Object)v8);
                                    var15_21 = v8.getThreadContext();
                                    Intrinsics.checkNotNullExpressionValue(var15_21, (String)"monitorCtx.threadPool!!.threadContext");
                                    $continuation.L$0 = this;
                                    $continuation.L$1 = monitor;
                                    $continuation.L$2 = monitorCtx;
                                    $continuation.L$3 = periodStart;
                                    $continuation.L$4 = periodEnd;
                                    $continuation.L$5 = roles;
                                    $continuation.L$6 = monitorResult;
                                    $continuation.L$7 = currentAlerts;
                                    $continuation.L$8 = triggerResults;
                                    $continuation.L$9 = triggerContexts;
                                    $continuation.L$10 = nextAlerts;
                                    $continuation.L$11 = firstIteration;
                                    $continuation.L$12 = firstPageOfInputResults;
                                    $continuation.L$13 = null;
                                    $continuation.L$14 = null;
                                    $continuation.L$15 = null;
                                    $continuation.Z$0 = dryrun;
                                    $continuation.label = 4;
                                    v9 = OpenSearchExtensionsKt.withClosableContext((InjectorContextElement)new InjectorContextElement(v6, v7, var15_21, roles), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(monitorCtx, monitor, periodStart, periodEnd, (Ref.ObjectRef<MonitorRunResult<BucketLevelTriggerRunResult>>)monitorResult, firstIteration, (Ref.ObjectRef<InputRunResults>)firstPageOfInputResults, null){
                                        int label;
                                        final /* synthetic */ MonitorRunnerExecutionContext $monitorCtx;
                                        final /* synthetic */ Monitor $monitor;
                                        final /* synthetic */ Instant $periodStart;
                                        final /* synthetic */ Instant $periodEnd;
                                        final /* synthetic */ Ref.ObjectRef<MonitorRunResult<BucketLevelTriggerRunResult>> $monitorResult;
                                        final /* synthetic */ Ref.BooleanRef $firstIteration;
                                        final /* synthetic */ Ref.ObjectRef<InputRunResults> $firstPageOfInputResults;
                                        {
                                            this.$monitorCtx = $monitorCtx;
                                            this.$monitor = $monitor;
                                            this.$periodStart = $periodStart;
                                            this.$periodEnd = $periodEnd;
                                            this.$monitorResult = $monitorResult;
                                            this.$firstIteration = $firstIteration;
                                            this.$firstPageOfInputResults = $firstPageOfInputResults;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    v0 = this.$monitorCtx.getInputService();
                                                    Intrinsics.checkNotNull((Object)v0);
                                                    this.label = 1;
                                                    v1 = v0.collectInputResults(this.$monitor, this.$periodStart, this.$periodEnd, ((MonitorRunResult)this.$monitorResult.element).getInputResults(), (Continuation<? super InputRunResults>)((Continuation)this));
                                                    if (v1 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl15
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl15:
                                                    // 2 sources

                                                    inputResults = (InputRunResults)v1;
                                                    if (this.$firstIteration.element) {
                                                        this.$firstPageOfInputResults.element = inputResults;
                                                        this.$firstIteration.element = false;
                                                    }
                                                    this.$monitorResult.element = MonitorRunResult.copy$default((MonitorRunResult)this.$monitorResult.element, null, null, null, null, inputResults, null, 47, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)$continuation);
                                    if (v9 == var47_9) {
                                        return var47_9;
                                    }
                                    ** GOTO lbl167
                                    break;
                                }
                            }
                            case 4: {
                                dryrun = $continuation.Z$0;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$12;
                                firstIteration = (Ref.BooleanRef)$continuation.L$11;
                                nextAlerts = (Map)$continuation.L$10;
                                triggerContexts = (Map)$continuation.L$9;
                                triggerResults = (Map)$continuation.L$8;
                                currentAlerts = (Map)$continuation.L$7;
                                monitorResult = (Ref.ObjectRef)$continuation.L$6;
                                roles = (List)$continuation.L$5;
                                periodEnd = (Instant)$continuation.L$4;
                                periodStart = (Instant)$continuation.L$3;
                                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (BucketLevelMonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v9 = $result;
lbl167:
                                // 2 sources

                                var15_21 = monitor.getTriggers().iterator();
lbl168:
                                // 4 sources

                                while (var15_21.hasNext()) {
                                    trigger = var15_21.next();
                                    v10 = currentAlerts.get(trigger);
                                    Intrinsics.checkNotNull(v10);
                                    currentAlertsForTrigger = (Map)v10;
                                    triggerCtx = new BucketLevelTriggerExecutionContext(monitor, (BucketLevelTrigger)trigger, (MonitorRunResult)monitorResult.element, null, null, null, 56, null);
                                    var19_28 = triggerContexts;
                                    var20_29 = trigger.getId();
                                    var19_28.put(var20_29, triggerCtx);
                                    v11 = monitorCtx.getTriggerService();
                                    Intrinsics.checkNotNull((Object)v11);
                                    triggerResult = v11.runBucketLevelTrigger(monitor, (BucketLevelTrigger)trigger, triggerCtx);
                                    var20_29 = triggerResults;
                                    var21_33 = trigger.getId();
                                    var22_34 = AlertingUtilsKt.getCombinedTriggerRunResult(triggerResult, (BucketLevelTriggerRunResult)triggerResults.get(trigger.getId()));
                                    var20_29.put(var21_33, var22_34);
                                    v12 = var20_29 = (BucketLevelTriggerRunResult)triggerResults.get(trigger.getId());
                                    if ((v12 == null ? null : v12.getError()) != null) continue;
                                    v13 = monitorCtx.getAlertService();
                                    Intrinsics.checkNotNull((Object)v13);
                                    categorizedAlerts = MapsKt.toMutableMap(v13.getCategorizedAlertsForBucketLevelMonitor(monitor, (BucketLevelTrigger)trigger, (Map<String, Alert>)currentAlertsForTrigger, CollectionsKt.toList((Iterable)triggerResult.getAggregationResultBuckets().values())));
                                    dedupedAlerts = categorizedAlerts.getOrDefault((Object)AlertCategory.DEDUPED, CollectionsKt.emptyList());
                                    newAlerts = categorizedAlerts.getOrDefault((Object)AlertCategory.NEW, CollectionsKt.emptyList());
                                    if (dryrun || Intrinsics.areEqual((Object)monitor.getId(), (Object)"")) ** GOTO lbl291
                                    v14 = monitorCtx.getAlertService();
                                    Intrinsics.checkNotNull((Object)v14);
                                    v15 = monitorCtx.getRetryPolicy();
                                    Intrinsics.checkNotNull((Object)v15);
                                    $continuation.L$0 = this;
                                    $continuation.L$1 = monitor;
                                    $continuation.L$2 = monitorCtx;
                                    $continuation.L$3 = periodStart;
                                    $continuation.L$4 = periodEnd;
                                    $continuation.L$5 = roles;
                                    $continuation.L$6 = monitorResult;
                                    $continuation.L$7 = currentAlerts;
                                    $continuation.L$8 = triggerResults;
                                    $continuation.L$9 = triggerContexts;
                                    $continuation.L$10 = nextAlerts;
                                    $continuation.L$11 = firstIteration;
                                    $continuation.L$12 = firstPageOfInputResults;
                                    $continuation.L$13 = var15_21;
                                    $continuation.L$14 = trigger;
                                    $continuation.L$15 = dedupedAlerts;
                                    $continuation.L$16 = newAlerts;
                                    $continuation.Z$0 = dryrun;
                                    $continuation.label = 5;
                                    v16 = v14.saveAlerts(dedupedAlerts, v15, true, (Continuation<? super Unit>)$continuation);
                                    if (v16 == var47_9) {
                                        return var47_9;
                                    }
                                    ** GOTO lbl243
                                }
                                break;
                            }
                            case 5: {
                                dryrun = $continuation.Z$0;
                                newAlerts = (List)$continuation.L$16;
                                dedupedAlerts = (List)$continuation.L$15;
                                trigger = (Trigger)$continuation.L$14;
                                var15_21 = (Iterator)$continuation.L$13;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$12;
                                firstIteration = (Ref.BooleanRef)$continuation.L$11;
                                nextAlerts = (Map)$continuation.L$10;
                                triggerContexts = (Map)$continuation.L$9;
                                triggerResults = (Map)$continuation.L$8;
                                currentAlerts = (Map)$continuation.L$7;
                                monitorResult = (Ref.ObjectRef)$continuation.L$6;
                                roles = (List)$continuation.L$5;
                                periodEnd = (Instant)$continuation.L$4;
                                periodStart = (Instant)$continuation.L$3;
                                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (BucketLevelMonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v16 = $result;
lbl243:
                                // 2 sources

                                v17 = monitorCtx.getAlertService();
                                Intrinsics.checkNotNull((Object)v17);
                                v18 = monitorCtx.getRetryPolicy();
                                Intrinsics.checkNotNull((Object)v18);
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = monitorCtx;
                                $continuation.L$3 = periodStart;
                                $continuation.L$4 = periodEnd;
                                $continuation.L$5 = roles;
                                $continuation.L$6 = monitorResult;
                                $continuation.L$7 = currentAlerts;
                                $continuation.L$8 = triggerResults;
                                $continuation.L$9 = triggerContexts;
                                $continuation.L$10 = nextAlerts;
                                $continuation.L$11 = firstIteration;
                                $continuation.L$12 = firstPageOfInputResults;
                                $continuation.L$13 = var15_21;
                                $continuation.L$14 = trigger;
                                $continuation.L$15 = dedupedAlerts;
                                $continuation.L$16 = null;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 6;
                                v19 = v17.saveNewAlerts(newAlerts, v18, (Continuation<? super List<Alert>>)$continuation);
                                if (v19 == var47_9) {
                                    return var47_9;
                                }
                                ** GOTO lbl290
                            }
                            case 6: {
                                dryrun = $continuation.Z$0;
                                dedupedAlerts = (List)$continuation.L$15;
                                trigger = (Trigger)$continuation.L$14;
                                var15_21 = (Iterator)$continuation.L$13;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$12;
                                firstIteration = (Ref.BooleanRef)$continuation.L$11;
                                nextAlerts = (Map)$continuation.L$10;
                                triggerContexts = (Map)$continuation.L$9;
                                triggerResults = (Map)$continuation.L$8;
                                currentAlerts = (Map)$continuation.L$7;
                                monitorResult = (Ref.ObjectRef)$continuation.L$6;
                                roles = (List)$continuation.L$5;
                                periodEnd = (Instant)$continuation.L$4;
                                periodStart = (Instant)$continuation.L$3;
                                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (BucketLevelMonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v19 = $result;
lbl290:
                                // 2 sources

                                newAlerts = (List)v19;
lbl291:
                                // 2 sources

                                if (!nextAlerts.containsKey(trigger.getId())) {
                                    var23_35 = nextAlerts;
                                    var24_36 = trigger.getId();
                                    var25_37 /* !! */  = new Pair[]{TuplesKt.to((Object)AlertCategory.DEDUPED, (Object)new ArrayList<E>()), TuplesKt.to((Object)AlertCategory.NEW, (Object)new ArrayList<E>()), TuplesKt.to((Object)AlertCategory.COMPLETED, (Object)new ArrayList<E>())};
                                    var25_37 /* !! */  = MapsKt.mutableMapOf((Pair[])var25_37 /* !! */ );
                                    var23_35.put(var24_36, var25_37 /* !! */ );
                                }
                                var23_35 = (Map)nextAlerts.get(trigger.getId());
                                v20 = var23_35;
                                if (v20 == null) {
                                    v21 = null;
                                } else {
                                    v22 = var24_36 = (List)v20.get((Object)AlertCategory.DEDUPED);
                                    v21 = v22 == null ? null : Boxing.boxBoolean((boolean)v22.addAll(dedupedAlerts));
                                }
                                var23_35 = (Map)nextAlerts.get(trigger.getId());
                                v23 = var23_35;
                                if (v23 != null) ** GOTO lbl310
                                v24 = null;
                                ** GOTO lbl168
lbl310:
                                // 1 sources

                                v25 = var24_36 = (List)v23.get((Object)AlertCategory.NEW);
                                v24 = v25 == null ? null : Boxing.boxBoolean((boolean)v25.addAll(newAlerts));
                                ** GOTO lbl168
                            }
                        }
                        ** while (((MonitorRunResult)monitorResult.element).getInputResults().afterKeysPresent())
lbl314:
                        // 1 sources

                        $this$forEach$iv = currentAlerts;
                        $i$f$forEach = false;
                        currentAlertsForTrigger = $this$forEach$iv.entrySet().iterator();
                        while (currentAlertsForTrigger.hasNext()) {
                            $dstr$trigger$keysToAlertsMap = element$iv = (Map.Entry)currentAlertsForTrigger.next();
                            $i$a$-forEach-BucketLevelMonitorRunner$runMonitor$3 = false;
                            trigger = (Trigger)$dstr$trigger$keysToAlertsMap.getKey();
                            keysToAlertsMap = (Map)$dstr$trigger$keysToAlertsMap.getValue();
                            v26 = var23_35 = (BucketLevelTriggerRunResult)triggerResults.get(trigger.getId());
                            if ((v26 == null ? null : v26.getError()) != null) continue;
                            var23_35 = (Map)nextAlerts.get(trigger.getId());
                            if (var23_35 == null) {
                                v27 = null;
                                continue;
                            }
                            var24_36 = (List)var23_35.get((Object)AlertCategory.COMPLETED);
                            if (var24_36 == null) {
                                v27 = null;
                                continue;
                            }
                            v28 = monitorCtx.getAlertService();
                            Intrinsics.checkNotNull((Object)v28);
                            v27 = Boxing.boxBoolean((boolean)var24_36.addAll((Collection)v28.convertToCompletedAlerts((Map<String, Alert>)keysToAlertsMap)));
                        }
                        var15_21 = monitor.getTriggers().iterator();
lbl338:
                        // 4 sources

                        while (var15_21.hasNext()) {
                            trigger = (Trigger)var15_21.next();
                            alertsToUpdate = new LinkedHashSet<E>();
                            completedAlertsToUpdate = new LinkedHashSet<E>();
                            trigger = (Map)nextAlerts.get(trigger.getId());
                            if (trigger == null) {
                                v29 = null;
                            } else {
                                keysToAlertsMap = (List)trigger.get((Object)AlertCategory.DEDUPED);
                                if (keysToAlertsMap == null) {
                                    v29 = null;
                                } else {
                                    $this$filterNot$iv = (Iterable)keysToAlertsMap;
                                    $i$f$filterNot = false;
                                    var26_42 = $this$filterNot$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterNotTo = false;
                                    var29_46 = $this$filterNotTo$iv$iv.iterator();
                                    while (var29_46.hasNext()) {
                                        element$iv$iv = var29_46.next();
                                        it = (Alert)element$iv$iv;
                                        $i$a$-filterNot-BucketLevelMonitorRunner$runMonitor$dedupedAlerts$1 = false;
                                        if (it.getState() == Alert.State.ACKNOWLEDGED) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    var23_35 = (List)destination$iv$iv;
                                    v29 = CollectionsKt.toMutableList((Collection)((Collection)var23_35));
                                }
                            }
                            $i$a$-forEach-BucketLevelMonitorRunner$runMonitor$3 = v29;
                            dedupedAlerts = $i$a$-forEach-BucketLevelMonitorRunner$runMonitor$3 == null ? (List)new ArrayList<E>() : $i$a$-forEach-BucketLevelMonitorRunner$runMonitor$3;
                            v30 = $i$a$-forEach-BucketLevelMonitorRunner$runMonitor$3 = (Map)nextAlerts.get(trigger.getId());
                            if (v30 == null) {
                                v31 = null;
                            } else {
                                trigger = v30;
                                keysToAlertsMap = AlertCategory.DEDUPED;
                                trigger.put(keysToAlertsMap, dedupedAlerts);
                                v31 = Unit.INSTANCE;
                            }
                            v32 = keysToAlertsMap = (Map)nextAlerts.get(trigger.getId());
                            trigger = v32 == null ? null : (List)v32.get((Object)AlertCategory.NEW);
                            newAlerts = trigger == null ? (List)new ArrayList<E>() : trigger;
                            v33 = var23_35 = (Map)nextAlerts.get(trigger.getId());
                            keysToAlertsMap = v33 == null ? null : (List)v33.get((Object)AlertCategory.COMPLETED);
                            completedAlerts = keysToAlertsMap == null ? (List)new ArrayList<E>() : keysToAlertsMap;
                            completedAlertsToUpdate.addAll((Collection)completedAlerts);
                            v34 = triggerContexts.get(trigger.getId());
                            Intrinsics.checkNotNull(v34);
                            triggerCtx = (BucketLevelTriggerExecutionContext)v34;
                            v35 = triggerResults.get(trigger.getId());
                            Intrinsics.checkNotNull(v35);
                            triggerResult = (BucketLevelTriggerRunResult)v35;
                            $i$f$filterNot = ((MonitorRunResult)monitorResult.element).getError();
                            v36 = $i$f$filterNot;
                            if (v36 == null) {
                                v36 = triggerResult.getError();
                            }
                            monitorOrTriggerError = v36;
                            shouldDefaultToPerExecution = AlertingUtilsKt.defaultToPerExecutionAction(monitorCtx.getMaxActionableAlertCount(), monitor.getId(), trigger.getId(), dedupedAlerts.size() + newAlerts.size() + completedAlerts.size(), monitorOrTriggerError);
                            $this$filterNotTo$iv$iv = trigger.getActions().iterator();
lbl398:
                            // 4 sources

                            while ($this$filterNotTo$iv$iv.hasNext()) {
                                action = (Action)$this$filterNotTo$iv$iv.next();
                                v37 = AlertingUtilsKt.getActionExecutionPolicy(action, monitor);
                                Intrinsics.checkNotNull((Object)v37);
                                actionExecutionScope = v37.getActionExecutionScope();
                                if (!(actionExecutionScope instanceof PerAlertActionScope) || shouldDefaultToPerExecution) break block65;
                                var29_46 = ((PerAlertActionScope)actionExecutionScope).getActionableAlerts().iterator();
                                while (var29_46.hasNext()) {
                                    alertCategory /* !! */  = (AlertCategory)var29_46.next();
                                    v38 = var33_53 = (Map)nextAlerts.get(trigger.getId());
                                    var32_52 = v38 == null ? null : (List)v38.get((Object)alertCategory /* !! */ );
                                    alertsToExecuteActionsFor = var32_52 == null ? (List)new ArrayList<E>() : var32_52;
                                    var32_52 = alertsToExecuteActionsFor.iterator();
lbl411:
                                    // 2 sources

                                    while (var32_52.hasNext()) {
                                        alert = (Alert)var32_52.next();
                                        actionCtx = this.getActionContextForAlertCategory(alertCategory /* !! */ , (Alert)alert, triggerCtx, monitorOrTriggerError);
                                        v39 = alert.getAggregationResultBucket();
                                        Intrinsics.checkNotNull((Object)v39);
                                        alertBucketKeysHash = AlertingUtilsKt.getBucketKeysHash(v39);
                                        if (!triggerResult.getActionResultsMap().containsKey(alertBucketKeysHash)) {
                                            var36_60 = triggerResult.getActionResultsMap();
                                            var37_61 = new LinkedHashMap<K, V>();
                                            var36_60.put(alertBucketKeysHash, (Map<String, ActionRunResult>)var37_61);
                                        }
                                        if (!MonitorRunnerService.INSTANCE.isActionActionable$opensearch_alerting(action, (Alert)alert)) break block66;
                                        $continuation.L$0 = this;
                                        $continuation.L$1 = monitor;
                                        $continuation.L$2 = monitorCtx;
                                        $continuation.L$3 = monitorResult;
                                        $continuation.L$4 = currentAlerts;
                                        $continuation.L$5 = triggerResults;
                                        $continuation.L$6 = triggerContexts;
                                        $continuation.L$7 = nextAlerts;
                                        $continuation.L$8 = firstPageOfInputResults;
                                        $continuation.L$9 = var15_21;
                                        $continuation.L$10 = trigger;
                                        $continuation.L$11 = alertsToUpdate;
                                        $continuation.L$12 = completedAlertsToUpdate;
                                        $continuation.L$13 = dedupedAlerts;
                                        $continuation.L$14 = newAlerts;
                                        $continuation.L$15 = completedAlerts;
                                        $continuation.L$16 = triggerCtx;
                                        $continuation.L$17 = triggerResult;
                                        $continuation.L$18 = monitorOrTriggerError;
                                        $continuation.L$19 = $this$filterNotTo$iv$iv;
                                        $continuation.L$20 = action;
                                        $continuation.L$21 = var29_46;
                                        $continuation.L$22 = alertCategory /* !! */ ;
                                        $continuation.L$23 = var32_52;
                                        $continuation.L$24 = alert;
                                        $continuation.L$25 = alertBucketKeysHash;
                                        $continuation.Z$0 = dryrun;
                                        $continuation.Z$1 = shouldDefaultToPerExecution;
                                        $continuation.label = 7;
                                        v40 = this.runAction(action, actionCtx, monitorCtx, monitor, dryrun != false, (Continuation<? super ActionRunResult>)$continuation);
                                        if (v40 == var47_9) {
                                            return var47_9;
                                        }
                                        ** GOTO lbl491
                                    }
                                }
                            }
                            break block67;
                        }
                        {
                            break;
                            case 7: {
                                shouldDefaultToPerExecution = $continuation.Z$1;
                                dryrun = $continuation.Z$0;
                                alertBucketKeysHash = (String)$continuation.L$25;
                                alert = (Alert)$continuation.L$24;
                                var32_52 = (Iterator<E>)$continuation.L$23;
                                alertCategory /* !! */  = (AlertCategory)$continuation.L$22;
                                var29_46 = (Iterator<T>)$continuation.L$21;
                                action = (Action)$continuation.L$20;
                                $this$filterNotTo$iv$iv = (Iterator)$continuation.L$19;
                                monitorOrTriggerError = (Exception)$continuation.L$18;
                                triggerResult = (BucketLevelTriggerRunResult)$continuation.L$17;
                                triggerCtx = (BucketLevelTriggerExecutionContext)$continuation.L$16;
                                completedAlerts = (List)$continuation.L$15;
                                newAlerts = (List)$continuation.L$14;
                                dedupedAlerts = (List)$continuation.L$13;
                                completedAlertsToUpdate = (Set)$continuation.L$12;
                                alertsToUpdate = (Set)$continuation.L$11;
                                trigger = (Trigger)$continuation.L$10;
                                var15_21 = (Iterator<Trigger>)$continuation.L$9;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$8;
                                nextAlerts = (Map)$continuation.L$7;
                                triggerContexts = (Map)$continuation.L$6;
                                triggerResults = (Map)$continuation.L$5;
                                currentAlerts = (Map)$continuation.L$4;
                                monitorResult = (Ref.ObjectRef)$continuation.L$3;
                                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (BucketLevelMonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v40 = $result;
lbl491:
                                // 2 sources

                                v41 = (ActionRunResult)v40;
                                break block68;
                            }
                        }
                    }
                    v41 = new ActionRunResult(action.getId(), action.getName(), MapsKt.emptyMap(), true, null, null);
                }
                actionResult = v41;
                var37_61 = triggerResult.getActionResultsMap().get(alertBucketKeysHash);
                if (var37_61 == null) {
                    v42 = null;
                } else {
                    var39_65 = action.getId();
                    var38_62.put((String)var39_65, (ActionRunResult)actionResult);
                    v42 = Unit.INSTANCE;
                }
                alertsToUpdate.add(alert);
                completedAlertsToUpdate.remove(alert);
                ** GOTO lbl411
            }
            if (!(actionExecutionScope instanceof PerExecutionActionScope) && !shouldDefaultToPerExecution || monitorOrTriggerError == null && dedupedAlerts.isEmpty() && newAlerts.isEmpty() && completedAlerts.isEmpty()) ** GOTO lbl398
            alertCategory /* !! */  = ((MonitorRunResult)monitorResult.element).getError();
            v43 /* !! */  = alertCategory /* !! */ ;
            if (v43 /* !! */  == null) {
                v43 /* !! */  = triggerResult.getError();
            }
            actionCtx = BucketLevelTriggerExecutionContext.copy$default(triggerCtx, null, null, null, null, null, dedupedAlerts, (List)newAlerts, (List)completedAlerts, (Exception)v43 /* !! */ , 31, null);
            $continuation.L$0 = this;
            $continuation.L$1 = monitor;
            $continuation.L$2 = monitorCtx;
            $continuation.L$3 = monitorResult;
            $continuation.L$4 = currentAlerts;
            $continuation.L$5 = triggerResults;
            $continuation.L$6 = triggerContexts;
            $continuation.L$7 = nextAlerts;
            $continuation.L$8 = firstPageOfInputResults;
            $continuation.L$9 = var15_21;
            $continuation.L$10 = trigger;
            $continuation.L$11 = alertsToUpdate;
            $continuation.L$12 = completedAlertsToUpdate;
            $continuation.L$13 = dedupedAlerts;
            $continuation.L$14 = newAlerts;
            $continuation.L$15 = completedAlerts;
            $continuation.L$16 = triggerCtx;
            $continuation.L$17 = triggerResult;
            $continuation.L$18 = monitorOrTriggerError;
            $continuation.L$19 = $this$filterNotTo$iv$iv;
            $continuation.L$20 = action;
            $continuation.L$21 = null;
            $continuation.L$22 = null;
            $continuation.L$23 = null;
            $continuation.L$24 = null;
            $continuation.L$25 = null;
            $continuation.Z$0 = dryrun;
            $continuation.Z$1 = shouldDefaultToPerExecution;
            $continuation.label = 8;
            v44 = this.runAction(action, (TriggerExecutionContext)actionCtx, monitorCtx, monitor, dryrun != false, (Continuation<? super ActionRunResult>)$continuation);
            if (v44 == var47_9) {
                return var47_9;
            }
            ** GOTO lbl576
            {
                case 8: {
                    shouldDefaultToPerExecution = $continuation.Z$1;
                    dryrun = $continuation.Z$0;
                    action = (Action)$continuation.L$20;
                    $this$filterNotTo$iv$iv = (Iterator<Action>)$continuation.L$19;
                    monitorOrTriggerError = (Exception)$continuation.L$18;
                    triggerResult = (BucketLevelTriggerRunResult)$continuation.L$17;
                    triggerCtx = (BucketLevelTriggerExecutionContext)$continuation.L$16;
                    completedAlerts = (List)$continuation.L$15;
                    newAlerts = (List)$continuation.L$14;
                    dedupedAlerts = (List)$continuation.L$13;
                    completedAlertsToUpdate = (Set)$continuation.L$12;
                    alertsToUpdate = (Set)$continuation.L$11;
                    trigger = (Trigger)$continuation.L$10;
                    var15_21 = (Iterator)$continuation.L$9;
                    firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$8;
                    nextAlerts = (Map)$continuation.L$7;
                    triggerContexts = (Map)$continuation.L$6;
                    triggerResults = (Map)$continuation.L$5;
                    currentAlerts = (Map)$continuation.L$4;
                    monitorResult = (Ref.ObjectRef)$continuation.L$3;
                    monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (BucketLevelMonitorRunner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v44 = $result;
lbl576:
                    // 2 sources

                    actionResult = (ActionRunResult)v44;
                    if (monitorOrTriggerError == null) {
                        v45 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)dedupedAlerts, (Iterable)((Iterable)newAlerts)), (Iterable)((Iterable)completedAlerts));
                    } else {
                        alert = (Map)currentAlerts.get(trigger);
                        if (alert == null) {
                            v46 = null;
                        } else {
                            $i$f$map = false;
                            actionResult = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                            $i$f$mapTo = false;
                            var39_65 = $this$mapTo$iv$iv.entrySet().iterator();
                            while (var39_65.hasNext()) {
                                var41_67 = item$iv$iv = var39_65.next();
                                var43_69 = destination$iv$iv;
                                $i$a$-map-BucketLevelMonitorRunner$runMonitor$alertsToIterate$1 = false;
                                var44_70 = (Alert)it.getValue();
                                var43_69.add(var44_70);
                            }
                            v46 = (List)destination$iv$iv;
                        }
                        var32_52 = v46;
                        v45 = var32_52 == null ? CollectionsKt.emptyList() : var32_52;
                    }
                    alertsToIterate = v45;
                    for (Object alert : alertsToIterate) {
                        v47 = alert.getAggregationResultBucket();
                        Intrinsics.checkNotNull((Object)v47);
                        alertBucketKeysHash = AlertingUtilsKt.getBucketKeysHash(v47);
                        if (!triggerResult.getActionResultsMap().containsKey(alertBucketKeysHash)) {
                            $i$f$map = triggerResult.getActionResultsMap();
                            $this$mapTo$iv$iv = (Map<String, ActionRunResult>)new LinkedHashMap<K, V>();
                            $i$f$map.put((String)alertBucketKeysHash, $this$mapTo$iv$iv);
                        }
                        if (($i$f$map = triggerResult.getActionResultsMap().get(alertBucketKeysHash)) == null) {
                            v48 = null;
                        } else {
                            var37_61 = action.getId();
                            $this$mapTo$iv$iv.put((String)var37_61, actionResult);
                            v48 = Unit.INSTANCE;
                        }
                        alertsToUpdate.add(alert);
                        completedAlertsToUpdate.remove(alert);
                    }
                    ** GOTO lbl398
                }
            }
        }
        $this$map$iv = alertsToUpdate;
        $i$f$map = false;
        actionCtx = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            alertBucketKeysHash = (Alert)item$iv$iv;
            var43_69 = destination$iv$iv;
            $i$a$-map-BucketLevelMonitorRunner$runMonitor$updatedAlerts$1 = false;
            v49 = alert.getAggregationResultBucket();
            Intrinsics.checkNotNull((Object)v49);
            bucketKeysHash = AlertingUtilsKt.getBucketKeysHash(v49);
            var37_61 = triggerResult.getActionResultsMap();
            var38_64 = MapsKt.emptyMap();
            actionResults = var37_61.getOrDefault(bucketKeysHash, (Map<String, ActionRunResult>)var38_64);
            v50 = monitorCtx.getAlertService();
            Intrinsics.checkNotNull((Object)v50);
            v51 = Alert.copy$default((Alert)alert, null, 0L, 0, null, null, 0L, null, null, null, null, null, null, null, null, MonitorRunnerService.INSTANCE.currentTime$opensearch_alerting(), null, null, null, null, null, null, 0x1FBFFF, null);
            var37_61 = ((MonitorRunResult)monitorResult.element).alertError();
            v52 = var37_61;
            if (v52 == null) {
                v52 = triggerResult.alertError();
            }
            var44_70 = v50.updateActionResultsForBucketLevelAlert(v51, actionResults, (AlertError)v52);
            var43_69.add(var44_70);
        }
        updatedAlerts = (List)destination$iv$iv;
        if (dryrun || Intrinsics.areEqual((Object)monitor.getId(), (Object)"")) ** GOTO lbl338
        v53 = monitorCtx.getAlertService();
        Intrinsics.checkNotNull((Object)v53);
        v54 = monitorCtx.getRetryPolicy();
        Intrinsics.checkNotNull((Object)v54);
        $continuation.L$0 = this;
        $continuation.L$1 = monitor;
        $continuation.L$2 = monitorCtx;
        $continuation.L$3 = monitorResult;
        $continuation.L$4 = currentAlerts;
        $continuation.L$5 = triggerResults;
        $continuation.L$6 = triggerContexts;
        $continuation.L$7 = nextAlerts;
        $continuation.L$8 = firstPageOfInputResults;
        $continuation.L$9 = var15_21;
        $continuation.L$10 = completedAlertsToUpdate;
        $continuation.L$11 = null;
        $continuation.L$12 = null;
        $continuation.L$13 = null;
        $continuation.L$14 = null;
        $continuation.L$15 = null;
        $continuation.L$16 = null;
        $continuation.L$17 = null;
        $continuation.L$18 = null;
        $continuation.L$19 = null;
        $continuation.L$20 = null;
        $continuation.L$21 = null;
        $continuation.L$22 = null;
        $continuation.L$23 = null;
        $continuation.L$24 = null;
        $continuation.L$25 = null;
        $continuation.Z$0 = dryrun;
        $continuation.label = 9;
        v55 = v53.saveAlerts(updatedAlerts, v54, false, (Continuation<? super Unit>)$continuation);
        if (v55 == var47_9) {
            return var47_9;
        }
        ** GOTO lbl704
        {
            case 9: {
                dryrun = $continuation.Z$0;
                completedAlertsToUpdate = (Set)$continuation.L$10;
                var15_21 = (Iterator)$continuation.L$9;
                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$8;
                nextAlerts = (Map)$continuation.L$7;
                triggerContexts = (Map)$continuation.L$6;
                triggerResults = (Map)$continuation.L$5;
                currentAlerts = (Map)$continuation.L$4;
                monitorResult = (Ref.ObjectRef)$continuation.L$3;
                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                monitor = (Monitor)$continuation.L$1;
                this = (BucketLevelMonitorRunner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v55 = $result;
lbl704:
                // 2 sources

                v56 = monitorCtx.getAlertService();
                Intrinsics.checkNotNull((Object)v56);
                v57 = CollectionsKt.toList((Iterable)completedAlertsToUpdate);
                v58 = monitorCtx.getRetryPolicy();
                Intrinsics.checkNotNull((Object)v58);
                $continuation.L$0 = this;
                $continuation.L$1 = monitor;
                $continuation.L$2 = monitorCtx;
                $continuation.L$3 = monitorResult;
                $continuation.L$4 = currentAlerts;
                $continuation.L$5 = triggerResults;
                $continuation.L$6 = triggerContexts;
                $continuation.L$7 = nextAlerts;
                $continuation.L$8 = firstPageOfInputResults;
                $continuation.L$9 = var15_21;
                $continuation.L$10 = null;
                $continuation.Z$0 = dryrun;
                $continuation.label = 10;
                v59 = v56.saveAlerts(v57, v58, false, (Continuation<? super Unit>)$continuation);
                if (v59 != var47_9) ** GOTO lbl338
                return var47_9;
            }
            case 10: {
                dryrun = $continuation.Z$0;
                var15_21 = (Iterator<Trigger>)$continuation.L$9;
                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$8;
                nextAlerts = (Map)$continuation.L$7;
                triggerContexts = (Map)$continuation.L$6;
                triggerResults = (Map)$continuation.L$5;
                currentAlerts = (Map)$continuation.L$4;
                monitorResult = (Ref.ObjectRef)$continuation.L$3;
                monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                monitor = (Monitor)$continuation.L$1;
                this = (BucketLevelMonitorRunner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v59 = $result;
                ** GOTO lbl338
            }
        }
        return MonitorRunResult.copy$default((MonitorRunResult)monitorResult.element, null, null, null, null, (InputRunResults)firstPageOfInputResults.element, triggerResults, 15, null);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final BucketLevelTriggerExecutionContext getActionContextForAlertCategory(AlertCategory alertCategory, Alert alert, BucketLevelTriggerExecutionContext ctx, Exception error) {
        BucketLevelTriggerExecutionContext bucketLevelTriggerExecutionContext;
        switch (WhenMappings.$EnumSwitchMapping$0[alertCategory.ordinal()]) {
            case 1: {
                bucketLevelTriggerExecutionContext = BucketLevelTriggerExecutionContext.copy$default(ctx, null, null, null, null, null, CollectionsKt.listOf((Object)alert), CollectionsKt.emptyList(), CollectionsKt.emptyList(), error, 31, null);
                break;
            }
            case 2: {
                bucketLevelTriggerExecutionContext = BucketLevelTriggerExecutionContext.copy$default(ctx, null, null, null, null, null, CollectionsKt.emptyList(), CollectionsKt.listOf((Object)alert), CollectionsKt.emptyList(), error, 31, null);
                break;
            }
            case 3: {
                bucketLevelTriggerExecutionContext = BucketLevelTriggerExecutionContext.copy$default(ctx, null, null, null, null, null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.listOf((Object)alert), error, 31, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bucketLevelTriggerExecutionContext;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlertCategory.values().length];
            nArray[AlertCategory.DEDUPED.ordinal()] = 1;
            nArray[AlertCategory.NEW.ordinal()] = 2;
            nArray[AlertCategory.COMPLETED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

