/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\u0012\u001a\u0004\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fJ\u0010\u0010\u0013\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\u0014\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/reportsscheduler/security/UserAccessManager;", "", "()V", "BACKEND_ROLE_TAG", "", "DEFAULT_TENANT", "PRIVATE_TENANT", "ROLE_TAG", "USER_TAG", "doesUserHasAccess", "", "user", "Lorg/opensearch/commons/authuser/User;", "tenant", "access", "", "getAllAccessInfo", "getSearchAccessInfo", "getUserFromAccess", "getUserTenant", "isUserPrivateTenant", "validateUser", "", "opensearch-reports-scheduler"})
public final class UserAccessManager {
    @NotNull
    public static final UserAccessManager INSTANCE = new UserAccessManager();
    @NotNull
    private static final String USER_TAG = "User:";
    @NotNull
    private static final String ROLE_TAG = "Role:";
    @NotNull
    private static final String BACKEND_ROLE_TAG = "BERole:";
    @NotNull
    private static final String PRIVATE_TENANT = "__user__";
    @NotNull
    public static final String DEFAULT_TENANT = "";

    private UserAccessManager() {
    }

    public final void validateUser(@Nullable User user) {
        if (this.isUserPrivateTenant(user)) {
            User user2 = user;
            if ((user2 == null ? null : user2.getName()) == null) {
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw new OpenSearchStatusException("User name not provided for private tenant access", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
        if (PluginSettings.INSTANCE.isRbacEnabled()) {
            User user3 = user;
            Collection collection = (Collection)(user3 == null ? null : user3.getBackendRoles());
            if (collection == null || collection.isEmpty()) {
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getUserTenant(@Nullable User user) {
        void var2_2;
        User user2 = user;
        String requestedTenant = user2 == null ? null : user2.getRequestedTenant();
        return requestedTenant == null ? DEFAULT_TENANT : var2_2;
    }

    @NotNull
    public final List<String> getAllAccessInfo(@Nullable User user) {
        String it;
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        List retList = new ArrayList();
        if (user.getName() != null) {
            retList.add(USER_TAG + user.getName());
        }
        List list = user.getRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.roles");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(ROLE_TAG + it);
        }
        $this$forEach$iv = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"user.backendRoles");
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(BACKEND_ROLE_TAG + it);
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final User getUserFromAccess(@NotNull List<String> access) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        String it;
        void $this$filterTo$iv$iv2;
        Object object;
        Object object2;
        Object v0;
        block8: {
            Intrinsics.checkNotNullParameter(access, (String)"access");
            if (((Collection)access).isEmpty()) {
                return null;
            }
            for (Object t : (Iterable)access) {
                String it2 = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it2, (String)USER_TAG, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        String string = v0;
        if (string == null) {
            object2 = null;
        } else {
            object = string.substring(USER_TAG.length());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
            object2 = object;
        }
        Object name = object2;
        Iterable $this$filter$iv = access;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)ROLE_TAG, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.substring(ROLE_TAG.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            collection.add(string2);
        }
        List backendRoles = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = access;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it3 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it3, (String)BACKEND_ROLE_TAG, (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it3 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            String string3 = it3.substring(BACKEND_ROLE_TAG.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            collection.add(string3);
        }
        List roles = (List)destination$iv$iv2;
        return new User((String)name, backendRoles, roles, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSearchAccessInfo(@Nullable User user) {
        List list;
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        if (this.isUserPrivateTenant(user)) {
            return CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
        }
        if (PluginSettings.INSTANCE.isRbacEnabled()) {
            void $this$mapTo$iv$iv;
            List list2 = user.getBackendRoles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"user.backendRoles");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BACKEND_ROLE_TAG + (String)it);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean doesUserHasAccess(@Nullable User user, @NotNull String tenant, @NotNull List<String> access) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
            Intrinsics.checkNotNullParameter(access, (String)"access");
            if (user == null) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)tenant)) {
                return false;
            }
            if (PluginSettings.INSTANCE.isRbacEnabled()) {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                List list = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(BACKEND_ROLE_TAG + (String)it);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!access.contains(it)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isUserPrivateTenant(User user) {
        return Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)PRIVATE_TENANT);
    }
}

