/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.operator.predicate;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.operator.predicate.UnaryPredicateOperator;
import org.opensearch.sql.utils.OperatorUtils;

public final class BinaryPredicateOperator {
    private static Table<ExprValue, ExprValue, ExprValue> andTable = new ImmutableTable.Builder().put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).build();
    private static Table<ExprValue, ExprValue, ExprValue> orTable = new ImmutableTable.Builder().put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).build();
    private static Table<ExprValue, ExprValue, ExprValue> xorTable = new ImmutableTable.Builder().put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).build();

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(BinaryPredicateOperator.and());
        repository.register(BinaryPredicateOperator.or());
        repository.register(BinaryPredicateOperator.xor());
        repository.register(BinaryPredicateOperator.equal());
        repository.register(BinaryPredicateOperator.notEqual());
        repository.register(BinaryPredicateOperator.less());
        repository.register(BinaryPredicateOperator.lte());
        repository.register(BinaryPredicateOperator.greater());
        repository.register(BinaryPredicateOperator.gte());
        repository.register(BinaryPredicateOperator.like());
        repository.register(BinaryPredicateOperator.notLike());
        repository.register(BinaryPredicateOperator.regexp());
    }

    private static FunctionResolver and() {
        return FunctionDSL.define(BuiltinFunctionName.AND.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperator.lookupTableFunction(v1, v2, andTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static FunctionResolver or() {
        return FunctionDSL.define(BuiltinFunctionName.OR.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperator.lookupTableFunction(v1, v2, orTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static FunctionResolver xor() {
        return FunctionDSL.define(BuiltinFunctionName.XOR.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperator.lookupTableFunction(v1, v2, xorTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static FunctionResolver equal() {
        return FunctionDSL.define(BuiltinFunctionName.EQUAL.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.equals(v2))), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static FunctionResolver notEqual() {
        return FunctionDSL.define(BuiltinFunctionName.NOTEQUAL.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(!v1.equals(v2))), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static FunctionResolver less() {
        return FunctionDSL.define(BuiltinFunctionName.LESS.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) < 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static FunctionResolver lte() {
        return FunctionDSL.define(BuiltinFunctionName.LTE.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) <= 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static FunctionResolver greater() {
        return FunctionDSL.define(BuiltinFunctionName.GREATER.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) > 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static FunctionResolver gte() {
        return FunctionDSL.define(BuiltinFunctionName.GTE.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) >= 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static FunctionResolver like() {
        return FunctionDSL.define(BuiltinFunctionName.LIKE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(OperatorUtils::matches), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver regexp() {
        return FunctionDSL.define(BuiltinFunctionName.REGEXP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(OperatorUtils::matchesRegexp), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver notLike() {
        return FunctionDSL.define(BuiltinFunctionName.NOT_LIKE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> UnaryPredicateOperator.not(OperatorUtils.matches(v1, v2))), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static ExprValue lookupTableFunction(ExprValue arg1, ExprValue arg2, Table<ExprValue, ExprValue, ExprValue> table) {
        if (table.contains((Object)arg1, (Object)arg2)) {
            return (ExprValue)table.get((Object)arg1, (Object)arg2);
        }
        return (ExprValue)table.get((Object)arg2, (Object)arg1);
    }

    @Generated
    private BinaryPredicateOperator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

