/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.HighlightExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;

public final class OpenSearchFunctions {
    public static final int MATCH_MAX_NUM_PARAMETERS = 14;
    public static final int MATCH_BOOL_PREFIX_MAX_NUM_PARAMETERS = 9;
    public static final int MATCH_PHRASE_MAX_NUM_PARAMETERS = 5;
    public static final int MIN_NUM_PARAMETERS = 2;
    public static final int MULTI_MATCH_MAX_NUM_PARAMETERS = 17;
    public static final int SIMPLE_QUERY_STRING_MAX_NUM_PARAMETERS = 14;
    public static final int QUERY_STRING_MAX_NUM_PARAMETERS = 25;
    public static final int MATCH_PHRASE_PREFIX_MAX_NUM_PARAMETERS = 7;

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(OpenSearchFunctions.match_bool_prefix());
        repository.register(OpenSearchFunctions.match());
        repository.register(OpenSearchFunctions.multi_match());
        repository.register(OpenSearchFunctions.simple_query_string());
        repository.register(OpenSearchFunctions.query_string());
        repository.register(OpenSearchFunctions.match_phrase(BuiltinFunctionName.MATCH_PHRASE));
        repository.register(OpenSearchFunctions.match_phrase(BuiltinFunctionName.MATCHPHRASE));
        repository.register(OpenSearchFunctions.match_phrase_prefix());
        repository.register(OpenSearchFunctions.highlight());
    }

    private static FunctionResolver highlight() {
        FunctionName functionName = BuiltinFunctionName.HIGHLIGHT.getName();
        FunctionSignature functionSignature = new FunctionSignature(functionName, List.of(ExprCoreType.STRING));
        FunctionBuilder functionBuilder = arguments -> new HighlightExpression((Expression)arguments.get(0));
        return new FunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)ImmutableMap.of((Object)functionSignature, (Object)functionBuilder));
    }

    private static FunctionResolver match_bool_prefix() {
        FunctionName name = BuiltinFunctionName.MATCH_BOOL_PREFIX.getName();
        return OpenSearchFunctions.getRelevanceFunctionResolver(name, 9, ExprCoreType.STRING);
    }

    private static FunctionResolver match() {
        FunctionName funcName = BuiltinFunctionName.MATCH.getName();
        return OpenSearchFunctions.getRelevanceFunctionResolver(funcName, 14, ExprCoreType.STRING);
    }

    private static FunctionResolver match_phrase_prefix() {
        FunctionName funcName = BuiltinFunctionName.MATCH_PHRASE_PREFIX.getName();
        return OpenSearchFunctions.getRelevanceFunctionResolver(funcName, 7, ExprCoreType.STRING);
    }

    private static FunctionResolver match_phrase(BuiltinFunctionName matchPhrase) {
        FunctionName funcName = matchPhrase.getName();
        return OpenSearchFunctions.getRelevanceFunctionResolver(funcName, 5, ExprCoreType.STRING);
    }

    private static FunctionResolver multi_match() {
        FunctionName funcName = BuiltinFunctionName.MULTI_MATCH.getName();
        return OpenSearchFunctions.getRelevanceFunctionResolver(funcName, 17, ExprCoreType.STRUCT);
    }

    private static FunctionResolver simple_query_string() {
        FunctionName funcName = BuiltinFunctionName.SIMPLE_QUERY_STRING.getName();
        return OpenSearchFunctions.getRelevanceFunctionResolver(funcName, 14, ExprCoreType.STRUCT);
    }

    private static FunctionResolver query_string() {
        FunctionName funcName = BuiltinFunctionName.QUERY_STRING.getName();
        return OpenSearchFunctions.getRelevanceFunctionResolver(funcName, 25, ExprCoreType.STRUCT);
    }

    private static FunctionResolver getRelevanceFunctionResolver(FunctionName funcName, int maxNumParameters, ExprCoreType firstArgType) {
        return new FunctionResolver(funcName, OpenSearchFunctions.getRelevanceFunctionSignatureMap(funcName, maxNumParameters, firstArgType));
    }

    private static Map<FunctionSignature, FunctionBuilder> getRelevanceFunctionSignatureMap(FunctionName funcName, int maxNumParameters, ExprCoreType firstArgType) {
        FunctionBuilder buildFunction = args -> new OpenSearchFunction(funcName, args);
        ImmutableMap.Builder signatureMapBuilder = ImmutableMap.builder();
        for (int numParameters = 2; numParameters <= maxNumParameters; ++numParameters) {
            ArrayList<ExprType> args2 = new ArrayList<ExprType>(Collections.nCopies(numParameters - 1, ExprCoreType.STRING));
            args2.add(0, firstArgType);
            signatureMapBuilder.put((Object)new FunctionSignature(funcName, args2), (Object)buildFunction);
        }
        return signatureMapBuilder.build();
    }

    @Generated
    private OpenSearchFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class OpenSearchFunction
    extends FunctionExpression {
        private final FunctionName functionName;
        private final List<Expression> arguments;

        public OpenSearchFunction(FunctionName functionName, List<Expression> arguments) {
            super(functionName, arguments);
            this.functionName = functionName;
            this.arguments = arguments;
        }

        @Override
        public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
            throw new UnsupportedOperationException(String.format("OpenSearch defined function [%s] is only supported in WHERE and HAVING clause.", this.functionName));
        }

        @Override
        public ExprType type() {
            return ExprCoreType.BOOLEAN;
        }

        @Override
        public String toString() {
            List args = this.arguments.stream().map(arg -> String.format("%s=%s", ((NamedArgumentExpression)arg).getArgName(), ((NamedArgumentExpression)arg).getValue().toString())).collect(Collectors.toList());
            return String.format("%s(%s)", this.functionName, String.join((CharSequence)", ", args));
        }
    }
}

