/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.data.type.WideningTypeRule;
import org.opensearch.sql.expression.function.FunctionName;

public class FunctionSignature {
    public static final Integer NOT_MATCH = Integer.MAX_VALUE;
    public static final Integer EXACTLY_MATCH = 0;
    private final FunctionName functionName;
    private final List<ExprType> paramTypeList;

    public int match(FunctionSignature functionSignature) {
        List<ExprType> functionTypeList = functionSignature.getParamTypeList();
        if (!this.functionName.equals(functionSignature.getFunctionName()) || this.paramTypeList.size() != functionTypeList.size()) {
            return NOT_MATCH;
        }
        int matchDegree = EXACTLY_MATCH;
        for (int i = 0; i < this.paramTypeList.size(); ++i) {
            ExprType funcType;
            ExprType paramType = this.paramTypeList.get(i);
            int match = WideningTypeRule.distance(paramType, funcType = functionTypeList.get(i));
            if (match == Integer.MAX_VALUE) {
                return NOT_MATCH;
            }
            matchDegree += match;
        }
        return matchDegree;
    }

    public String formatTypes() {
        return this.getParamTypeList().stream().map(ExprType::typeName).collect(Collectors.joining(",", "[", "]"));
    }

    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Generated
    public List<ExprType> getParamTypeList() {
        return this.paramTypeList;
    }

    @Generated
    public FunctionSignature(FunctionName functionName, List<ExprType> paramTypeList) {
        this.functionName = functionName;
        this.paramTypeList = paramTypeList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionSignature)) {
            return false;
        }
        FunctionSignature other = (FunctionSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        List<ExprType> this$paramTypeList = this.getParamTypeList();
        List<ExprType> other$paramTypeList = other.getParamTypeList();
        return !(this$paramTypeList == null ? other$paramTypeList != null : !((Object)this$paramTypeList).equals(other$paramTypeList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionSignature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        List<ExprType> $paramTypeList = this.getParamTypeList();
        result = result * 59 + ($paramTypeList == null ? 43 : ((Object)$paramTypeList).hashCode());
        return result;
    }
}

