/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import java.time.Duration;
import java.time.Period;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprIntervalValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionResolver;

public final class IntervalClause {
    private static final String MICRO_SECOND = "microsecond";
    private static final String SECOND = "second";
    private static final String MINUTE = "minute";
    private static final String HOUR = "hour";
    private static final String DAY = "day";
    private static final String WEEK = "week";
    private static final String MONTH = "month";
    private static final String QUARTER = "quarter";
    private static final String YEAR = "year";

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(IntervalClause.interval());
    }

    private static FunctionResolver interval() {
        return FunctionDSL.define(BuiltinFunctionName.INTERVAL.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(IntervalClause::interval), ExprCoreType.INTERVAL, ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(IntervalClause::interval), ExprCoreType.INTERVAL, ExprCoreType.LONG, ExprCoreType.STRING));
    }

    private static ExprValue interval(ExprValue value, ExprValue unit) {
        switch (ExprValueUtils.getStringValue(unit).toLowerCase()) {
            case "microsecond": {
                return IntervalClause.microsecond(value);
            }
            case "second": {
                return IntervalClause.second(value);
            }
            case "minute": {
                return IntervalClause.minute(value);
            }
            case "hour": {
                return IntervalClause.hour(value);
            }
            case "day": {
                return IntervalClause.day(value);
            }
            case "week": {
                return IntervalClause.week(value);
            }
            case "month": {
                return IntervalClause.month(value);
            }
            case "quarter": {
                return IntervalClause.quarter(value);
            }
            case "year": {
                return IntervalClause.year(value);
            }
        }
        throw new ExpressionEvaluationException(String.format("interval unit %s is not supported", ExprValueUtils.getStringValue(unit)));
    }

    private static ExprValue microsecond(ExprValue value) {
        return new ExprIntervalValue(Duration.ofNanos(ExprValueUtils.getLongValue(value) * 1000L));
    }

    private static ExprValue second(ExprValue value) {
        return new ExprIntervalValue(Duration.ofSeconds(ExprValueUtils.getLongValue(value)));
    }

    private static ExprValue minute(ExprValue value) {
        return new ExprIntervalValue(Duration.ofMinutes(ExprValueUtils.getLongValue(value)));
    }

    private static ExprValue hour(ExprValue value) {
        return new ExprIntervalValue(Duration.ofHours(ExprValueUtils.getLongValue(value)));
    }

    private static ExprValue day(ExprValue value) {
        return new ExprIntervalValue(Duration.ofDays(ExprValueUtils.getIntegerValue(value).intValue()));
    }

    private static ExprValue week(ExprValue value) {
        return new ExprIntervalValue(Period.ofWeeks(ExprValueUtils.getIntegerValue(value)));
    }

    private static ExprValue month(ExprValue value) {
        return new ExprIntervalValue(Period.ofMonths(ExprValueUtils.getIntegerValue(value)));
    }

    private static ExprValue quarter(ExprValue value) {
        return new ExprIntervalValue(Period.ofMonths(ExprValueUtils.getIntegerValue(value) * 3));
    }

    private static ExprValue year(ExprValue value) {
        return new ExprIntervalValue(Period.ofYears(ExprValueUtils.getIntegerValue(value)));
    }

    @Generated
    private IntervalClause() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

