/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.core.JobSweeperMetrics;
import org.opensearch.alerting.core.ShardNodes;
import org.opensearch.alerting.core.model.ScheduledJob;
import org.opensearch.alerting.core.schedule.JobScheduler;
import org.opensearch.alerting.core.settings.ScheduledJobSettings;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.component.LifecycleListener;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.index.shard.ShardId;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\b\u00102\u001a\u000200H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u000200J\u0006\u00107\u001a\u000200J\b\u00108\u001a\u00020\u001cH\u0002J\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u000200H\u0002J\u001c\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-H\u0002J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020AH\u0002J\u0006\u0010B\u001a\u00020(JD\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010E\u001a\u00060\u0018j\u0002`.2\u0006\u0010F\u001a\u00020G2\b\b\u0002\u0010H\u001a\u00020(H\u0002J0\u0010I\u001a\u00020D2\u0006\u0010@\u001a\u00020A2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010E\u001a\u00060\u0018j\u0002`.2\u0006\u0010H\u001a\u00020(H\u0002J \u0010J\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J \u0010O\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010P\u001a\u00020Q2\u0006\u0010M\u001a\u00020RH\u0016J<\u0010S\u001a\u0002002\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010T\u001a\u00060\u0018j\u0002`.2\b\u0010U\u001a\u0004\u0018\u00010D2\b\b\u0002\u0010V\u001a\u00020(H\u0002J\b\u0010W\u001a\u000200H\u0002J\"\u0010X\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010Y\u001a\u00020Z2\b\b\u0002\u0010[\u001a\u00020\u0012H\u0002J;\u0010\\\u001a\u00020(2\n\u0010T\u001a\u00060\u0018j\u0002`.2\u000e\u0010]\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`.2\u0006\u0010^\u001a\u00020(2\b\u0010U\u001a\u0004\u0018\u00010DH\u0002\u00a2\u0006\u0002\u0010_R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\n \u0016*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0018\u0010#\u001a\n \u0016*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0016\u0010$\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n \u0016*\u0004\u0018\u00010&0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010'\u001a\n \u0016*\u0004\u0018\u00010(0(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R.\u0010*\u001a\"\u0012\u0004\u0012\u00020,\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0012j\u0002`-\u0012\b\u0012\u00060\u0018j\u0002`.0+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/opensearch/alerting/core/JobSweeper;", "Lorg/opensearch/cluster/ClusterStateListener;", "Lorg/opensearch/index/shard/IndexingOperationListener;", "Lorg/opensearch/common/component/LifecycleListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "scheduler", "Lorg/opensearch/alerting/core/schedule/JobScheduler;", "sweepableJobTypes", "", "", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/common/xcontent/NamedXContentRegistry;Lorg/opensearch/alerting/core/schedule/JobScheduler;Ljava/util/List;)V", "fullSweepExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "lastFullSweepTimeNano", "", "logger", "Lorg/apache/logging/log4j/Logger;", "requestTimeout", "Lorg/opensearch/common/unit/TimeValue;", "scheduledFullSweep", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "sweepBackoffMillis", "sweepBackoffRetryCount", "", "Ljava/lang/Integer;", "sweepPageSize", "sweepPeriod", "sweepSearchBackoff", "Lorg/opensearch/action/bulk/BackoffPolicy;", "sweeperEnabled", "", "Ljava/lang/Boolean;", "sweptJobs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/opensearch/index/shard/ShardId;", "Lorg/opensearch/alerting/core/JobId;", "Lorg/opensearch/alerting/core/JobVersion;", "afterStart", "", "beforeClose", "beforeStop", "clusterChanged", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "disable", "enable", "getFullSweepElapsedTime", "getJobSweeperMetrics", "Lorg/opensearch/alerting/core/JobSweeperMetrics;", "initBackgroundSweep", "isOwningNode", "shardId", "jobId", "isSweepableJobType", "xcp", "Lorg/opensearch/common/xcontent/XContentParser;", "isSweepingEnabled", "parseAndSweepJob", "Lorg/opensearch/alerting/core/model/ScheduledJob;", "jobVersion", "jobSource", "Lorg/opensearch/common/bytes/BytesReference;", "typeIsParsed", "parseScheduledJob", "postDelete", "delete", "Lorg/opensearch/index/engine/Engine$Delete;", "result", "Lorg/opensearch/index/engine/Engine$DeleteResult;", "postIndex", "index", "Lorg/opensearch/index/engine/Engine$Index;", "Lorg/opensearch/index/engine/Engine$IndexResult;", "sweep", "newVersion", "job", "failedToParse", "sweepAllShards", "sweepShard", "shardNodes", "Lorg/opensearch/alerting/core/ShardNodes;", "startAfter", "unchangedJobToBeRescheduled", "currentVersion", "jobCurrentlyScheduled", "(JLjava/lang/Long;ZLorg/opensearch/alerting/core/model/ScheduledJob;)Z", "alerting-core"})
public final class JobSweeper
extends LifecycleListener
implements ClusterStateListener,
IndexingOperationListener {
    @NotNull
    private final Settings settings;
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final JobScheduler scheduler;
    @NotNull
    private final List<String> sweepableJobTypes;
    private final Logger logger;
    private final ExecutorService fullSweepExecutor;
    @NotNull
    private final ConcurrentHashMap<ShardId, ConcurrentHashMap<String, Long>> sweptJobs;
    @Nullable
    private Scheduler.Cancellable scheduledFullSweep;
    private volatile long lastFullSweepTimeNano;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue sweepPeriod;
    private volatile Boolean sweeperEnabled;
    private volatile Integer sweepPageSize;
    private volatile TimeValue sweepBackoffMillis;
    private volatile Integer sweepBackoffRetryCount;
    private volatile BackoffPolicy sweepSearchBackoff;

    public JobSweeper(@NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull NamedXContentRegistry xContentRegistry, @NotNull JobScheduler scheduler, @NotNull List<String> sweepableJobTypes) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter(sweepableJobTypes, (String)"sweepableJobTypes");
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.scheduler = scheduler;
        this.sweepableJobTypes = sweepableJobTypes;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.fullSweepExecutor = Executors.newSingleThreadExecutor(OpenSearchExecutors.daemonThreadFactory((String)"opendistro_job_sweeper"));
        this.sweptJobs = new ConcurrentHashMap();
        this.lastFullSweepTimeNano = System.nanoTime();
        this.requestTimeout = (TimeValue)ScheduledJobSettings.Companion.getREQUEST_TIMEOUT().get(this.settings);
        this.sweepPeriod = (TimeValue)ScheduledJobSettings.Companion.getSWEEP_PERIOD().get(this.settings);
        this.sweeperEnabled = (Boolean)ScheduledJobSettings.Companion.getSWEEPER_ENABLED().get(this.settings);
        this.sweepPageSize = (Integer)ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE().get(this.settings);
        this.sweepBackoffMillis = (TimeValue)ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS().get(this.settings);
        Integer n = this.sweepBackoffRetryCount = (Integer)ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT().get(this.settings);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"sweepBackoffRetryCount");
        this.sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)this.sweepBackoffMillis, (int)((Number)n).intValue());
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.addLifecycleListener((LifecycleListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_PERIOD(), arg_0 -> JobSweeper._init_$lambda-0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEPER_ENABLED(), arg_0 -> JobSweeper._init_$lambda-1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS(), arg_0 -> JobSweeper._init_$lambda-2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT(), arg_0 -> JobSweeper._init_$lambda-3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE(), arg_0 -> JobSweeper._init_$lambda-4(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> JobSweeper._init_$lambda-5(this, arg_0));
    }

    public void afterStart() {
        this.initBackgroundSweep();
    }

    public void beforeStop() {
        Scheduler.Cancellable cancellable = this.scheduledFullSweep;
        if (cancellable != null) {
            cancellable.cancel();
        }
    }

    public void beforeClose() {
        this.fullSweepExecutor.shutdown();
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (!event.indexRoutingTableChanged(".opendistro-alerting-config")) {
            return;
        }
        this.logger.debug("Scheduled Jobs routing table changed. Running full sweep...");
        this.fullSweepExecutor.submit(() -> JobSweeper.clusterChanged$lambda-6(this));
    }

    public void postIndex(@NotNull ShardId shardId, @NotNull Engine.Index index, @NotNull Engine.IndexResult result) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (result.getResultType() != Engine.Result.Type.SUCCESS) {
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.get(shardId);
            Map shardJobs = concurrentHashMap == null ? MapsKt.emptyMap() : (Map)concurrentHashMap;
            Long l = (Long)shardJobs.get(index.id());
            long currentVersion = l == null ? -1L : l;
            this.logger.debug("Indexing failed for ScheduledJob: " + index.id() + ". Continuing with current version " + currentVersion);
            return;
        }
        String shardJobs = index.id();
        Intrinsics.checkNotNullExpressionValue((Object)shardJobs, (String)"index.id()");
        if (this.isOwningNode(shardId, shardJobs)) {
            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)index.source(), (XContentType)XContentType.JSON);
            Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
            if (this.isSweepableJobType(xcp)) {
                String string = index.id();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"index.id()");
                String string2 = string;
                long l = result.getVersion();
                string = index.source();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"index.source()");
                ScheduledJob job = this.parseAndSweepJob(xcp, shardId, string2, l, (BytesReference)string, true);
                if (job != null) {
                    this.scheduler.postIndex(job);
                }
            } else {
                this.logger.debug("Not a valid job type in document " + index.id() + " to sweep.");
            }
        }
    }

    public void postDelete(@NotNull ShardId shardId, @NotNull Engine.Delete delete, @NotNull Engine.DeleteResult result) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        Intrinsics.checkNotNullParameter((Object)delete, (String)"delete");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (result.getResultType() != Engine.Result.Type.SUCCESS) {
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.get(shardId);
            Map shardJobs = concurrentHashMap == null ? MapsKt.emptyMap() : (Map)concurrentHashMap;
            Long l = (Long)shardJobs.get(delete.id());
            long currentVersion = l == null ? -1L : l;
            this.logger.debug("Deletion failed for ScheduledJob: " + delete.id() + ". Continuing with current version " + currentVersion);
            return;
        }
        String string = delete.id();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delete.id()");
        if (this.isOwningNode(shardId, string)) {
            if (this.scheduler.scheduledJobs().contains(delete.id())) {
                string = delete.id();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delete.id()");
                JobSweeper.sweep$default(this, shardId, string, result.getVersion(), null, false, 16, null);
            }
            string = delete.id();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delete.id()");
            this.scheduler.postDelete(string);
        }
    }

    public final void enable() {
        this.initBackgroundSweep();
        this.sweeperEnabled = true;
    }

    public final void disable() {
        Scheduler.Cancellable cancellable = this.scheduledFullSweep;
        if (cancellable != null) {
            cancellable.cancel();
        }
        this.logger.info("Descheduling all jobs as sweeping is disabled");
        this.scheduler.deschedule((Collection<String>)this.scheduler.scheduledJobs());
        this.sweeperEnabled = false;
    }

    public final boolean isSweepingEnabled() {
        return Intrinsics.areEqual((Object)this.sweeperEnabled, (Object)true);
    }

    private final void initBackgroundSweep() {
        if (!this.isSweepingEnabled()) {
            return;
        }
        Scheduler.Cancellable cancellable = this.scheduledFullSweep;
        if (cancellable != null) {
            cancellable.cancel();
        }
        this.logger.debug("Performing sweep of scheduled jobs.");
        this.fullSweepExecutor.submit(() -> JobSweeper.initBackgroundSweep$lambda-7(this));
        Runnable scheduledSweep = () -> JobSweeper.initBackgroundSweep$lambda-9(this);
        this.scheduledFullSweep = this.threadPool.scheduleWithFixedDelay(scheduledSweep, this.sweepPeriod, "same");
    }

    /*
     * WARNING - void declaration
     */
    private final void sweepAllShards() {
        Iterable shards;
        Iterable $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        ShardRouting it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ClusterState clusterState = this.clusterService.state();
        if (!clusterState.getRoutingTable().hasIndex(".opendistro-alerting-config")) {
            this.scheduler.deschedule((Collection<String>)this.scheduler.scheduledJobs());
            this.sweptJobs.clear();
            this.lastFullSweepTimeNano = System.nanoTime();
            return;
        }
        String localNodeId = clusterState.getNodes().getLocalNodeId();
        Iterable iterable = clusterState.getRoutingTable().allShards(".opendistro-alerting-config");
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"clusterState.routingTabl\u2026Job.SCHEDULED_JOBS_INDEX)");
        iterable = iterable;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            if (!it.active()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            ShardId key$iv$iv = it.shardId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block14: {
                Object $dstr$_u24__u24$shards = element$iv$iv = (Map.Entry)iterator.next();
                boolean bl3 = false;
                shards = (List)$dstr$_u24__u24$shards.getValue();
                Iterable $this$any$iv = shards;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ShardRouting it2 = (ShardRouting)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it2.currentNodeId(), (Object)localNodeId)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object localShards = destination$iv$iv;
        Set $i$f$filter2 = this.sweptJobs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter2, (String)"sweptJobs.keys");
        Set removedShards = SetsKt.minus((Set)$i$f$filter2, (Iterable)localShards.keySet());
        Object $this$forEach$iv = removedShards;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            ShardId shardId = (ShardId)element$iv;
            boolean bl = false;
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.remove(shardId);
            Map shardJobs = concurrentHashMap == null ? MapsKt.emptyMap() : (Map)concurrentHashMap;
            this.scheduler.deschedule(shardJobs.keySet());
        }
        $this$forEach$iv = localShards;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$shardId$shards = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            ShardId shardId = (ShardId)$dstr$shardId$shards.getKey();
            List shards2 = (List)$dstr$shardId$shards.getValue();
            try {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue((Object)shardId, (String)"shardId");
                Intrinsics.checkNotNullExpressionValue((Object)localNodeId, (String)"localNodeId");
                shards = shards2;
                String string = localNodeId;
                ShardId shardId2 = shardId;
                JobSweeper jobSweeper = this;
                boolean $i$f$map = false;
                void var20_32 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    ShardRouting shardRouting = (ShardRouting)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(it3.currentNodeId());
                }
                collection = (List)destination$iv$iv2;
                Collection collection2 = collection;
                String string2 = string;
                JobSweeper.sweepShard$default(jobSweeper, shardId2, new ShardNodes(string2, collection2), null, 4, null);
            }
            catch (Exception e) {
                Logger shardLogger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)shardId, (String[])new String[0]);
                shardLogger.error("Error while sweeping shard " + shardId, (Throwable)e);
            }
        }
        this.lastFullSweepTimeNano = System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    private final void sweepShard(ShardId shardId, ShardNodes shardNodes, String startAfter) {
        void $this$forEach$iv;
        Iterator $this$filterNotTo$iv$iv;
        Object object;
        Object default$iv;
        Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)shardId, (String[])new String[0]);
        logger.debug("Sweeping shard " + shardId);
        Object $this$getOrPut$iv = this.sweptJobs;
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv.get(shardId);
        if (object2 == null) {
            boolean bl = false;
            default$iv = new ConcurrentHashMap();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(shardId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        } else {
            object = object2;
        }
        ConcurrentHashMap currentJobs = (ConcurrentHashMap)object;
        $this$getOrPut$iv = currentJobs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)$this$getOrPut$iv, (String)"currentJobs.keys");
        Iterable $this$filterNot$iv = (Iterable)$this$getOrPut$iv;
        boolean $i$f$filterNot = false;
        object2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        default$iv = $this$filterNotTo$iv$iv.iterator();
        while (default$iv.hasNext()) {
            Object element$iv$iv = default$iv.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (shardNodes.isOwningNode(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.scheduler.deschedule(it);
            currentJobs.remove(it);
        }
        String searchAfter = startAfter;
        while (searchAfter != null) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            Iterable $this$forEach$iv2 = this.sweepableJobTypes;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl = false;
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.existsQuery((String)it));
            }
            Object $i$f$forEach22 = new String[]{".opendistro-alerting-config"};
            SearchRequest searchRequest = new SearchRequest().indices((String[])$i$f$forEach22).preference("_shards:" + shardId.getId() + "|_only_local");
            $i$f$forEach22 = new String[]{searchAfter};
            SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().version(Boolean.valueOf(true)).sort((SortBuilder)new FieldSortBuilder("_id").unmappedType("keyword").missing((Object)"_last")).searchAfter($i$f$forEach22);
            $i$f$forEach22 = this.sweepPageSize;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach22, (String)"sweepPageSize");
            SearchRequest jobSearchRequest = searchRequest.source(searchSourceBuilder.size(((Number)$i$f$forEach22).intValue()).query((QueryBuilder)boolQueryBuilder));
            BackoffPolicy backoffPolicy = this.sweepSearchBackoff;
            Intrinsics.checkNotNullExpressionValue((Object)backoffPolicy, (String)"sweepSearchBackoff");
            SearchResponse response2 = (SearchResponse)OpenSearchExtensionsKt.retry(backoffPolicy, (Function0)new Function0<SearchResponse>(this, jobSearchRequest){
                final /* synthetic */ JobSweeper this$0;
                final /* synthetic */ SearchRequest $jobSearchRequest;
                {
                    this.this$0 = $receiver;
                    this.$jobSearchRequest = $jobSearchRequest;
                    super(0);
                }

                public final SearchResponse invoke() {
                    return (SearchResponse)JobSweeper.access$getClient$p(this.this$0).search(this.$jobSearchRequest).actionGet(JobSweeper.access$getRequestTimeout$p(this.this$0));
                }
            });
            if (response2.status() != RestStatus.OK) {
                String string = "Error sweeping shard " + shardId + ".";
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                logger.error(string, (Object)OpenSearchExtensionsKt.firstFailureOrNull(response2));
                return;
            }
            for (SearchHit hit : response2.getHits()) {
                String it = hit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"hit.id");
                if (!shardNodes.isOwningNode(it)) continue;
                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (XContentType)XContentType.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                String string = hit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hit.id");
                String string2 = string;
                long l = hit.getVersion();
                string = hit.getSourceRef();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hit.sourceRef");
                JobSweeper.parseAndSweepJob$default(this, xcp, shardId, string2, l, (BytesReference)string, false, 32, null);
            }
            SearchHits searchHits = response2.getHits();
            Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"response.hits");
            SearchHit searchHit = (SearchHit)CollectionsKt.lastOrNull((Iterable)((Iterable)searchHits));
            searchAfter = searchHit == null ? null : searchHit.getId();
        }
    }

    static /* synthetic */ void sweepShard$default(JobSweeper jobSweeper, ShardId shardId, ShardNodes shardNodes, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        jobSweeper.sweepShard(shardId, shardNodes, string);
    }

    private final void sweep(ShardId shardId, String jobId, long newVersion, ScheduledJob job, boolean failedToParse) {
        Object object;
        ConcurrentMap $this$getOrPut$iv = this.sweptJobs;
        boolean $i$f$getOrPut = false;
        Object v = $this$getOrPut$iv.get(shardId);
        if (v == null) {
            boolean bl = false;
            ConcurrentHashMap default$iv = new ConcurrentHashMap();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(shardId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        } else {
            object = v;
        }
        ((ConcurrentHashMap)object).compute(jobId, (arg_0, arg_1) -> JobSweeper.sweep$lambda-22(this, jobId, newVersion, job, failedToParse, arg_0, arg_1));
    }

    static /* synthetic */ void sweep$default(JobSweeper jobSweeper, ShardId shardId, String string, long l, ScheduledJob scheduledJob, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        jobSweeper.sweep(shardId, string, l, scheduledJob, bl);
    }

    private final boolean unchangedJobToBeRescheduled(long newVersion, Long currentVersion, boolean jobCurrentlyScheduled, ScheduledJob job) {
        boolean bl;
        Long l = currentVersion;
        boolean versionWasUnchanged = newVersion == (l == null ? -1L : l);
        ScheduledJob scheduledJob = job;
        boolean jobEnabled = scheduledJob == null ? false : (bl = scheduledJob.getEnabled());
        return versionWasUnchanged && !jobCurrentlyScheduled && jobEnabled;
    }

    private final ScheduledJob parseAndSweepJob(XContentParser xcp, ShardId shardId, String jobId, long jobVersion, BytesReference jobSource, boolean typeIsParsed) {
        ScheduledJob scheduledJob;
        try {
            ScheduledJob job = this.parseScheduledJob(xcp, jobId, jobVersion, typeIsParsed);
            JobSweeper.sweep$default(this, shardId, jobId, jobVersion, job, false, 16, null);
            scheduledJob = job;
        }
        catch (Exception e) {
            this.logger.warn("Unable to parse ScheduledJob source: {}", (Object)Strings.cleanTruncate((String)jobSource.utf8ToString(), (int)1000));
            this.sweep(shardId, jobId, jobVersion, null, true);
            scheduledJob = null;
        }
        return scheduledJob;
    }

    static /* synthetic */ ScheduledJob parseAndSweepJob$default(JobSweeper jobSweeper, XContentParser xContentParser, ShardId shardId, String string, long l, BytesReference bytesReference, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return jobSweeper.parseAndSweepJob(xContentParser, shardId, string, l, bytesReference, bl);
    }

    private final ScheduledJob parseScheduledJob(XContentParser xcp, String jobId, long jobVersion, boolean typeIsParsed) {
        ScheduledJob scheduledJob;
        if (typeIsParsed) {
            String string = xcp.currentName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xcp.currentName()");
            scheduledJob = ScheduledJob.Companion.parse(xcp, string, jobId, jobVersion);
        } else {
            scheduledJob = ScheduledJob.Companion.parse(xcp, jobId, jobVersion);
        }
        return scheduledJob;
    }

    private final TimeValue getFullSweepElapsedTime() {
        TimeValue timeValue = TimeValue.timeValueNanos((long)(System.nanoTime() - this.lastFullSweepTimeNano));
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"timeValueNanos(System.na\u2026 - lastFullSweepTimeNano)");
        return timeValue;
    }

    @NotNull
    public final JobSweeperMetrics getJobSweeperMetrics() {
        if (!this.isSweepingEnabled()) {
            return new JobSweeperMetrics(-1L, true);
        }
        TimeValue elapsedTime = this.getFullSweepElapsedTime();
        return new JobSweeperMetrics(elapsedTime.getMillis(), elapsedTime.getMillis() <= this.sweepPeriod.getMillis());
    }

    private final boolean isSweepableJobType(XContentParser xcp) {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        String jobType = xcp.currentName();
        return this.sweepableJobTypes.contains(jobType);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOwningNode(ShardId shardId, String jobId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ShardRouting it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String localNodeId = this.clusterService.localNode().getId();
        Object object = this.clusterService.state().getRoutingTable().shardRoutingTable(shardId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterService.state().r\u2026hardRoutingTable(shardId)");
        object = (Iterable)object;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            if (!it.active()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ShardRouting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.currentNodeId());
        }
        List shardNodeIds = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)localNodeId, (String)"localNodeId");
        ShardNodes shardNodes = new ShardNodes(localNodeId, shardNodeIds);
        return shardNodes.isOwningNode(jobId);
    }

    private static final void _init_$lambda-0(JobSweeper this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.debug("Reinitializing background full sweep with period: " + this$0.sweepPeriod.minutes());
        this$0.sweepPeriod = it;
        this$0.initBackgroundSweep();
    }

    private static final void _init_$lambda-1(JobSweeper this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweeperEnabled = it;
        if (!this$0.sweeperEnabled.booleanValue()) {
            this$0.disable();
        } else {
            this$0.enable();
        }
    }

    private static final void _init_$lambda-2(JobSweeper this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TimeValue timeValue = this$0.sweepBackoffMillis = it;
        Integer n = this$0.sweepBackoffRetryCount;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"sweepBackoffRetryCount");
        this$0.sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)timeValue, (int)((Number)n).intValue());
    }

    private static final void _init_$lambda-3(JobSweeper this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepBackoffRetryCount = it;
        TimeValue timeValue = this$0.sweepBackoffMillis;
        Integer n = this$0.sweepBackoffRetryCount;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"sweepBackoffRetryCount");
        this$0.sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)timeValue, (int)((Number)n).intValue());
    }

    private static final void _init_$lambda-4(JobSweeper this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepPageSize = it;
    }

    private static final void _init_$lambda-5(JobSweeper this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.requestTimeout = it;
    }

    private static final void clusterChanged$lambda-6(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepAllShards();
    }

    private static final void initBackgroundSweep$lambda-7(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepAllShards();
    }

    private static final void initBackgroundSweep$lambda-9$lambda-8(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.debug("Performing background sweep of scheduled jobs.");
        this$0.sweepAllShards();
    }

    private static final void initBackgroundSweep$lambda-9(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TimeValue elapsedTime = this$0.getFullSweepElapsedTime();
        long delta = this$0.sweepPeriod.getMillis() - elapsedTime.getMillis();
        if (delta < 20L) {
            this$0.fullSweepExecutor.submit(() -> JobSweeper.initBackgroundSweep$lambda-9$lambda-8(this$0));
        }
    }

    private static final Long sweep$lambda-22(JobSweeper this$0, String $jobId, long $newVersion, ScheduledJob $job, boolean $failedToParse, String $noName_0, Long currentVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jobId, (String)"$jobId");
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        boolean jobCurrentlyScheduled = this$0.scheduler.scheduledJobs().contains($jobId);
        Long l = currentVersion;
        if (l == null) {
            l = -1L;
        }
        if ($newVersion <= ((Number)l).longValue()) {
            if (this$0.unchangedJobToBeRescheduled($newVersion, currentVersion, jobCurrentlyScheduled, $job)) {
                this$0.logger.debug("Not skipping job " + $jobId + " since it is an unchanged job slated to be rescheduled");
            } else {
                this$0.logger.debug("Skipping job " + $jobId + ", " + $newVersion + " <= " + currentVersion);
                return currentVersion;
            }
        }
        if (jobCurrentlyScheduled) {
            this$0.scheduler.deschedule($jobId);
        }
        if ($failedToParse) {
            return currentVersion;
        }
        if ($job != null) {
            if ($job.getEnabled()) {
                this$0.scheduler.schedule($job);
            }
            return $newVersion;
        }
        return null;
    }

    public static final /* synthetic */ Client access$getClient$p(JobSweeper $this) {
        return $this.client;
    }

    public static final /* synthetic */ TimeValue access$getRequestTimeout$p(JobSweeper $this) {
        return $this.requestTimeout;
    }
}

