/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public abstract class Node<T extends GenericFlowUnit> {
    private List<Node<?>> downStreams = new ArrayList();
    protected List<Node<?>> upStreams;
    private int level;
    private int graphId;
    protected long evaluationIntervalSeconds;
    protected List<T> flowUnits;
    protected T localFlowUnit;
    private Map<String, String> tags;
    private AppContext appContext;

    Node(int level, long evaluationIntervalSeconds) {
        this.level = level;
        this.evaluationIntervalSeconds = evaluationIntervalSeconds;
        this.tags = new HashMap<String, String>();
    }

    void addDownstream(Node<?> downStreamNode) {
        this.downStreams.add(downStreamNode);
    }

    void setLevel(int level) {
        this.level = level;
    }

    int getLevel() {
        return this.level;
    }

    public void setGraphId(int graphId) {
        this.graphId = graphId;
    }

    public int getGraphId() {
        return this.graphId;
    }

    public long getEvaluationIntervalSeconds() {
        return this.evaluationIntervalSeconds;
    }

    @VisibleForTesting
    public void setEvaluationIntervalSeconds(long value) {
        this.evaluationIntervalSeconds = value;
    }

    int getUpStreamNodesCount() {
        if (this.upStreams == null) {
            return 0;
        }
        return this.upStreams.size();
    }

    List<Node<?>> getDownStreams() {
        if (this.downStreams == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.downStreams);
    }

    public List<Node<?>> getUpstreams() {
        if (this.upStreams == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.upStreams);
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public void addTag(String key, String value) {
        this.tags.put(key, value);
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public abstract void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper var1);

    public abstract void persistFlowUnit(FlowUnitOperationArgWrapper var1);

    public abstract void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper var1);

    public abstract void handleNodeMuted();

    public void setEmptyFlowUnitList() {
        this.flowUnits = Collections.emptyList();
    }

    public void setEmptyLocalFlowUnit() {
        this.localFlowUnit = null;
    }

    public String toString() {
        return this.name();
    }

    public @NonNull List<T> getFlowUnits() {
        ArrayList<T> allFlowUnits;
        ArrayList<T> arrayList = allFlowUnits = this.flowUnits == null ? new ArrayList<T>() : new ArrayList<T>(this.flowUnits);
        if (this.localFlowUnit != null) {
            allFlowUnits.add(this.localFlowUnit);
        }
        return allFlowUnits;
    }

    public void setFlowUnits(List<T> flowUnits) {
        this.flowUnits = flowUnits;
    }

    public void setLocalFlowUnit(T localFlowUnit) {
        this.localFlowUnit = localFlowUnit;
    }

    public void readRcaConf(RcaConf conf) {
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    protected AppContext getAppContext() {
        return this.appContext;
    }

    public InstanceDetails getInstanceDetails() {
        InstanceDetails ret = new InstanceDetails(AllMetrics.NodeRole.UNKNOWN);
        if (this.appContext != null) {
            ret = this.appContext.getMyInstanceDetails();
        }
        return ret;
    }

    public List<InstanceDetails> getAllClusterInstances() {
        List<InstanceDetails> ret = Collections.EMPTY_LIST;
        if (this.appContext != null) {
            ret = this.appContext.getAllClusterInstances();
        }
        return ret;
    }

    public List<InstanceDetails> getDataNodeInstances() {
        List ret = Collections.EMPTY_LIST;
        if (this.appContext != null) {
            return this.appContext.getDataNodeInstances();
        }
        return ret;
    }
}

