/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.aggregators;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;

public class SlidingWindow<E extends SlidingWindowData> {
    protected final Deque<E> windowDeque = new LinkedList();
    protected final long SLIDING_WINDOW_SIZE;
    protected double sum;

    public SlidingWindow(int SLIDING_WINDOW_SIZE_IN_TIMESTAMP, TimeUnit timeUnit) {
        this.SLIDING_WINDOW_SIZE = timeUnit.toSeconds(SLIDING_WINDOW_SIZE_IN_TIMESTAMP);
        this.sum = 0.0;
    }

    protected void add(E e) {
        this.sum += ((SlidingWindowData)e).getValue();
    }

    protected void remove(E e) {
        this.sum -= ((SlidingWindowData)e).getValue();
    }

    protected void pruneExpiredEntries(long endTimeStamp) {
        while (!this.windowDeque.isEmpty() && TimeUnit.MILLISECONDS.toSeconds(endTimeStamp - ((SlidingWindowData)this.windowDeque.peekLast()).getTimeStamp()) > this.SLIDING_WINDOW_SIZE) {
            SlidingWindowData lastData = (SlidingWindowData)this.windowDeque.pollLast();
            this.remove(lastData);
        }
    }

    public void next(E e) {
        this.pruneExpiredEntries(((SlidingWindowData)e).getTimeStamp());
        this.add(e);
        this.windowDeque.addFirst(e);
    }

    public double readAvg() {
        if (!this.windowDeque.isEmpty()) {
            return this.sum / (double)this.windowDeque.size();
        }
        return Double.NaN;
    }

    public double readAvg(TimeUnit timeUnit) {
        if (this.windowDeque.isEmpty()) {
            return Double.NaN;
        }
        long timeStampDiff = ((SlidingWindowData)this.windowDeque.peekFirst()).getTimeStamp() - ((SlidingWindowData)this.windowDeque.peekLast()).getTimeStamp();
        if (timeStampDiff > 0L) {
            return this.sum / ((double)timeStampDiff / (double)timeUnit.toMillis(1L));
        }
        return Double.NaN;
    }

    public double readSum() {
        return this.sum;
    }

    public int size() {
        return this.windowDeque.size();
    }

    public void clear() {
        this.windowDeque.clear();
    }
}

