/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.RcaConsts;

public class RcaControllerHelper {
    private static final Logger LOG = LogManager.getLogger(RcaControllerHelper.class);
    public static final String CAT_MASTER_URL = "http://localhost:9200/_cat/master?h=ip";
    private static String ELECTED_MASTER_RCA_CONF_PATH = RcaConsts.RCA_CONF_MASTER_PATH;
    private static String MASTER_RCA_CONF_PATH = RcaConsts.RCA_CONF_IDLE_MASTER_PATH;
    private static String RCA_CONF_PATH = RcaConsts.RCA_CONF_PATH;

    public static RcaConf pickRcaConfForRole(AllMetrics.NodeRole nodeRole) {
        if (AllMetrics.NodeRole.ELECTED_MASTER == nodeRole) {
            LOG.debug("picking elected master conf");
            return new RcaConf(ELECTED_MASTER_RCA_CONF_PATH);
        }
        if (AllMetrics.NodeRole.MASTER == nodeRole) {
            LOG.debug("picking idle master conf");
            return new RcaConf(MASTER_RCA_CONF_PATH);
        }
        if (AllMetrics.NodeRole.DATA == nodeRole) {
            LOG.debug("picking data node conf");
            return new RcaConf(RCA_CONF_PATH);
        }
        LOG.debug("picking default conf");
        return new RcaConf(RCA_CONF_PATH);
    }

    public static String getElectedMasterHostAddress() {
        try {
            LOG.info("Making _cat/master call");
            PerformanceAnalyzerApp.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat(RcaRuntimeMetrics.OPEN_SEARCH_APIS_CALLED, "catMaster", 1);
            URL url = new URL(CAT_MASTER_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String inputLine = in.readLine();
            in.close();
            return inputLine;
        }
        catch (IOException e) {
            LOG.error("Could not get the elected master node", (Throwable)e);
            return "";
        }
    }

    public static ExecutorService buildNetworkThreadPool(int queueLength) {
        ThreadFactory rcaNetThreadFactory = new ThreadFactoryBuilder().setNameFormat("rca-net-%d").setDaemon(true).build();
        LinkedBlockingQueue<Runnable> threadPoolQueue = new LinkedBlockingQueue<Runnable>(queueLength);
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, threadPoolQueue, rcaNetThreadFactory);
    }

    public static void set(String rcaConfPath, String rcaMaterConfPath, String rcaElectedMasterConfPath) {
        RCA_CONF_PATH = rcaConfPath;
        MASTER_RCA_CONF_PATH = rcaMaterConfPath;
        ELECTED_MASTER_RCA_CONF_PATH = rcaElectedMasterConfPath;
    }

    public static List<String> getAllConfFilePaths() {
        return ImmutableList.of((Object)ELECTED_MASTER_RCA_CONF_PATH, (Object)MASTER_RCA_CONF_PATH, (Object)RCA_CONF_PATH);
    }
}

