/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.actions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import org.opensearch.performanceanalyzer.decisionmaker.actions.SuppressibleAction;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class HeapSizeIncreaseAction
extends SuppressibleAction {
    public static final String NAME = "HeapSizeIncreaseAction";
    private static final String ID_KEY = "Id";
    private static final String IP_KEY = "Ip";
    private final NodeKey node;
    private static final long DEFAULT_COOL_OFF_PERIOD_IN_MILLIS = TimeUnit.DAYS.toMillis(3L);

    public HeapSizeIncreaseAction(@Nonnull AppContext appContext) {
        super(appContext);
        this.node = new NodeKey(appContext.getMyInstanceDetails());
    }

    public HeapSizeIncreaseAction(NodeKey nodeKey, AppContext appContext) {
        super(appContext);
        this.node = nodeKey;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public long coolOffPeriodInMillis() {
        return DEFAULT_COOL_OFF_PERIOD_IN_MILLIS;
    }

    @Override
    public List<NodeKey> impactedNodes() {
        return this.appContext.getDataNodeInstances().stream().map(NodeKey::new).collect(Collectors.toList());
    }

    @Override
    public Map<NodeKey, ImpactVector> impact() {
        HashMap<NodeKey, ImpactVector> impactMap = new HashMap<NodeKey, ImpactVector>();
        for (NodeKey nodeKey : this.impactedNodes()) {
            ImpactVector impactVector = new ImpactVector();
            impactVector.decreasesPressure(ImpactVector.Dimension.HEAP);
            impactMap.put(nodeKey, impactVector);
        }
        return impactMap;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String summary() {
        JsonObject summaryJson = new JsonObject();
        summaryJson.addProperty(ID_KEY, this.node.getNodeId().toString());
        summaryJson.addProperty(IP_KEY, this.node.getHostAddress().toString());
        return summaryJson.toString();
    }

    public static HeapSizeIncreaseAction fromSummary(@Nonnull String summary, @Nonnull AppContext appContext) {
        JsonObject jsonObject = JsonParser.parseString((String)summary).getAsJsonObject();
        NodeKey node = new NodeKey(new InstanceDetails.Id(jsonObject.get(ID_KEY).getAsString()), new InstanceDetails.Ip(jsonObject.get(IP_KEY).getAsString()));
        return new HeapSizeIncreaseAction(node, appContext);
    }
}

