/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.core.Util;

public abstract class PerformanceAnalyzerMetricsCollector
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerMetricsCollector.class);
    private int timeInterval;
    private long startTime;
    private String collectorName;
    protected StringBuilder value;
    protected State state;
    private boolean threadContentionMonitoringEnabled;
    private AtomicBoolean bInProgress = new AtomicBoolean(false);

    protected PerformanceAnalyzerMetricsCollector(int timeInterval, String collectorName) {
        this.timeInterval = timeInterval;
        this.collectorName = collectorName;
        this.value = new StringBuilder();
        this.state = State.HEALTHY;
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public boolean inProgress() {
        return this.bInProgress.get();
    }

    public String getCollectorName() {
        return this.collectorName;
    }

    abstract void collectMetrics(long var1);

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.bInProgress.set(true);
    }

    @Override
    public void run() {
        try {
            Util.invokePrivileged(() -> this.collectMetrics(this.startTime));
        }
        catch (Exception ex) {
            LOG.error("Error In Collect Metrics: {} with ExceptionCode: {}", new Supplier[]{() -> ex.toString(), () -> StatExceptionCode.OTHER_COLLECTION_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.OTHER_COLLECTION_ERROR);
        }
        finally {
            this.bInProgress.set(false);
        }
    }

    @VisibleForTesting
    public StringBuilder getValue() {
        return this.value;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setThreadContentionMonitoringEnabled(boolean enabled) {
        this.threadContentionMonitoringEnabled = enabled;
    }

    public boolean getThreadContentionMonitoringEnabled() {
        return this.threadContentionMonitoringEnabled;
    }

    static enum State {
        HEALTHY,
        SLOW,
        MUTED;

    }
}

