/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.replication.task.ReplicationState;
import org.opensearch.replication.task.index.CompletedState;
import org.opensearch.replication.task.index.FailedState;
import org.opensearch.replication.task.index.FollowingState;
import org.opensearch.replication.task.index.InitFollowState;
import org.opensearch.replication.task.index.InitialState;
import org.opensearch.replication.task.index.MonitoringState;
import org.opensearch.replication.task.index.RestoreState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u0082\u0001\u0007\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/replication/task/index/IndexReplicationState;", "Lorg/opensearch/persistent/PersistentTaskState;", "state", "Lorg/opensearch/replication/task/ReplicationState;", "(Lorg/opensearch/replication/task/ReplicationState;)V", "getState", "()Lorg/opensearch/replication/task/ReplicationState;", "setState", "getWriteableName", "", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Builder", "Companion", "Lorg/opensearch/replication/task/index/InitialState;", "Lorg/opensearch/replication/task/index/RestoreState;", "Lorg/opensearch/replication/task/index/InitFollowState;", "Lorg/opensearch/replication/task/index/CompletedState;", "Lorg/opensearch/replication/task/index/MonitoringState;", "Lorg/opensearch/replication/task/index/FailedState;", "Lorg/opensearch/replication/task/index/FollowingState;", "opensearch-cross-cluster-replication"})
public abstract class IndexReplicationState
implements PersistentTaskState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ReplicationState state;
    @NotNull
    public static final String NAME = "cluster:indices/admin/replication";
    @NotNull
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:indices/admin/replication", true, IndexReplicationState::PARSER$lambda-0);

    @NotNull
    public final ReplicationState getState() {
        return this.state;
    }

    public final void setState(@NotNull ReplicationState replicationState) {
        Intrinsics.checkNotNullParameter((Object)((Object)replicationState), (String)"<set-?>");
        this.state = replicationState;
    }

    private IndexReplicationState(ReplicationState state) {
        this.state = state;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeEnum((Enum)this.state);
    }

    @NotNull
    public final String getWriteableName() {
        return NAME;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        XContentBuilder xContentBuilder = builder.startObject().field("state", (ToXContent)this.state).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    private static final Builder PARSER$lambda-0() {
        return new Builder();
    }

    public /* synthetic */ IndexReplicationState(ReplicationState state, DefaultConstructorMarker $constructor_marker) {
        this(state);
    }

    static {
        PARSER.declareString(Builder::setIndexTaskState, new ParseField("state", new String[0]));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/replication/task/index/IndexReplicationState$Companion;", "", "()V", "NAME", "", "PARSER", "Lorg/opensearch/common/xcontent/ObjectParser;", "Lorg/opensearch/replication/task/index/IndexReplicationState$Builder;", "Ljava/lang/Void;", "fromXContent", "Lorg/opensearch/replication/task/index/IndexReplicationState;", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "reader", "inp", "Lorg/opensearch/common/io/stream/StreamInput;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IndexReplicationState reader(@NotNull StreamInput inp) {
            IndexReplicationState indexReplicationState;
            Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
            Enum enum_ = inp.readEnum(ReplicationState.class);
            Intrinsics.checkNotNull((Object)enum_);
            ReplicationState state = (ReplicationState)enum_;
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    indexReplicationState = InitialState.INSTANCE;
                    break;
                }
                case 2: {
                    indexReplicationState = RestoreState.INSTANCE;
                    break;
                }
                case 3: {
                    indexReplicationState = InitFollowState.INSTANCE;
                    break;
                }
                case 4: {
                    indexReplicationState = new FollowingState(inp);
                    break;
                }
                case 5: {
                    indexReplicationState = CompletedState.INSTANCE;
                    break;
                }
                case 6: {
                    indexReplicationState = MonitoringState.INSTANCE;
                    break;
                }
                case 7: {
                    indexReplicationState = new FailedState(inp);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return indexReplicationState;
        }

        @NotNull
        public final IndexReplicationState fromXContent(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            return ((Builder)PARSER.parse(parser, null)).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReplicationState.values().length];
                nArray[ReplicationState.INIT.ordinal()] = 1;
                nArray[ReplicationState.RESTORING.ordinal()] = 2;
                nArray[ReplicationState.INIT_FOLLOW.ordinal()] = 3;
                nArray[ReplicationState.FOLLOWING.ordinal()] = 4;
                nArray[ReplicationState.COMPLETED.ordinal()] = 5;
                nArray[ReplicationState.MONITORING.ordinal()] = 6;
                nArray[ReplicationState.FAILED.ordinal()] = 7;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/opensearch/replication/task/index/IndexReplicationState$Builder;", "", "()V", "state", "", "getState", "()Ljava/lang/String;", "setState", "(Ljava/lang/String;)V", "build", "Lorg/opensearch/replication/task/index/IndexReplicationState;", "setIndexTaskState", "", "opensearch-cross-cluster-replication"})
    public static final class Builder {
        public String state;

        @NotNull
        public final String getState() {
            String string = this.state;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            return null;
        }

        public final void setState(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.state = string;
        }

        public final void setIndexTaskState(@NotNull String state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.setState(state);
        }

        @NotNull
        public final IndexReplicationState build() {
            IndexReplicationState indexReplicationState;
            this.setState(this.state == null ? ReplicationState.MONITORING.name() : this.getState());
            String string = this.getState();
            if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.INIT.name())) {
                indexReplicationState = InitialState.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.RESTORING.name())) {
                indexReplicationState = RestoreState.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.INIT_FOLLOW.name())) {
                indexReplicationState = InitFollowState.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.FOLLOWING.name())) {
                indexReplicationState = new FollowingState(MapsKt.emptyMap());
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.COMPLETED.name())) {
                indexReplicationState = CompletedState.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.MONITORING.name())) {
                indexReplicationState = MonitoringState.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.FAILED.name())) {
                indexReplicationState = new FailedState(MapsKt.emptyMap(), "");
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)this.getState(), (Object)" - Not a valid state for index replication task"));
            }
            return indexReplicationState;
        }
    }
}

