/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedSignatureOperatorUsingSecureRandomFactory<T extends Parameters>
implements SignatureOperatorFactory<T> {
    GuardedSignatureOperatorUsingSecureRandomFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public final OutputSignerUsingSecureRandom<T> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return this.doCreateSigner(asymmetricPrivateKey, t);
    }

    @Override
    public final OutputVerifier<T> createVerifier(AsymmetricPublicKey asymmetricPublicKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return this.doCreateVerifier(asymmetricPublicKey, t);
    }

    protected abstract OutputSignerUsingSecureRandom<T> doCreateSigner(AsymmetricPrivateKey var1, T var2);

    protected abstract OutputVerifier<T> doCreateVerifier(AsymmetricPublicKey var1, T var2);
}

