/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class MultiCollector
implements Collector {
    private final boolean cacheScores;
    private final Collector[] collectors;

    public static Collector wrap(Collector ... collectors) {
        return MultiCollector.wrap(Arrays.asList(collectors));
    }

    public static Collector wrap(Iterable<? extends Collector> collectors) {
        int n = 0;
        for (Collector collector : collectors) {
            if (collector == null) continue;
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("At least 1 collector must not be null");
        }
        if (n == 1) {
            Collector col = null;
            for (Collector collector : collectors) {
                if (collector == null) continue;
                col = collector;
                break;
            }
            return col;
        }
        Collector[] colls = new Collector[n];
        n = 0;
        for (Collector collector : collectors) {
            if (collector == null) continue;
            colls[n++] = collector;
        }
        return new MultiCollector(colls);
    }

    private MultiCollector(Collector ... collectors) {
        this.collectors = collectors;
        int numNeedsScores = 0;
        for (Collector collector : collectors) {
            if (!collector.scoreMode().needsScores()) continue;
            ++numNeedsScores;
        }
        this.cacheScores = numNeedsScores >= 2;
    }

    @Override
    public ScoreMode scoreMode() {
        ScoreMode scoreMode = null;
        for (Collector collector : this.collectors) {
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            return ScoreMode.COMPLETE;
        }
        return scoreMode;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        ArrayList<LeafCollector> leafCollectors = new ArrayList<LeafCollector>(this.collectors.length);
        ScoreMode leafScoreMode = null;
        for (Collector collector : this.collectors) {
            LeafCollector leafCollector;
            try {
                leafCollector = collector.getLeafCollector(context);
            }
            catch (CollectionTerminatedException e) {
                continue;
            }
            if (leafScoreMode == null) {
                leafScoreMode = collector.scoreMode();
            } else if (leafScoreMode != collector.scoreMode()) {
                leafScoreMode = ScoreMode.COMPLETE;
            }
            leafCollectors.add(leafCollector);
        }
        if (leafCollectors.isEmpty()) {
            throw new CollectionTerminatedException();
        }
        if (leafCollectors.size() == 1 && (this.scoreMode() == ScoreMode.TOP_SCORES || leafScoreMode != ScoreMode.TOP_SCORES)) {
            return (LeafCollector)leafCollectors.get(0);
        }
        return new MultiLeafCollector(leafCollectors, this.cacheScores, this.scoreMode() == ScoreMode.TOP_SCORES);
    }

    @Override
    public void setWeight(Weight weight) {
        for (Collector collector : this.collectors) {
            collector.setWeight(weight);
        }
    }

    public Collector[] getCollectors() {
        return this.collectors;
    }

    static final class MinCompetitiveScoreAwareScorable
    extends FilterScorable {
        private final int idx;
        private final float[] minScores;

        MinCompetitiveScoreAwareScorable(Scorable in, int idx, float[] minScores) {
            super(in);
            this.idx = idx;
            this.minScores = minScores;
        }

        @Override
        public void setMinCompetitiveScore(float minScore) throws IOException {
            if (minScore > this.minScores[this.idx]) {
                this.minScores[this.idx] = minScore;
                this.in.setMinCompetitiveScore(this.minScore());
            }
        }

        private float minScore() {
            float min = Float.MAX_VALUE;
            for (int i = 0; i < this.minScores.length; ++i) {
                if (!(this.minScores[i] < min)) continue;
                min = this.minScores[i];
            }
            return min;
        }
    }

    private static class MultiLeafCollector
    implements LeafCollector {
        private final boolean cacheScores;
        private final LeafCollector[] collectors;
        private final float[] minScores;
        private final boolean skipNonCompetitiveScores;

        private MultiLeafCollector(List<LeafCollector> collectors, boolean cacheScores, boolean skipNonCompetitive) {
            this.collectors = collectors.toArray(new LeafCollector[collectors.size()]);
            this.cacheScores = cacheScores;
            this.skipNonCompetitiveScores = skipNonCompetitive;
            this.minScores = this.skipNonCompetitiveScores ? new float[this.collectors.length] : null;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.cacheScores) {
                scorer = ScoreCachingWrappingScorer.wrap(scorer);
            }
            if (this.skipNonCompetitiveScores) {
                for (int i = 0; i < this.collectors.length; ++i) {
                    LeafCollector c = this.collectors[i];
                    if (c == null) continue;
                    c.setScorer(new MinCompetitiveScoreAwareScorable(scorer, i, this.minScores));
                }
            } else {
                scorer = new FilterScorable(scorer){

                    @Override
                    public void setMinCompetitiveScore(float minScore) throws IOException {
                    }
                };
                for (int i = 0; i < this.collectors.length; ++i) {
                    LeafCollector c = this.collectors[i];
                    if (c == null) continue;
                    c.setScorer(scorer);
                }
            }
        }

        @Override
        public void collect(int doc) throws IOException {
            for (int i = 0; i < this.collectors.length; ++i) {
                LeafCollector collector = this.collectors[i];
                if (collector == null) continue;
                try {
                    collector.collect(doc);
                    continue;
                }
                catch (CollectionTerminatedException e) {
                    this.collectors[i] = null;
                    if (!this.allCollectorsTerminated()) continue;
                    throw new CollectionTerminatedException();
                }
            }
        }

        private boolean allCollectorsTerminated() {
            for (int i = 0; i < this.collectors.length; ++i) {
                if (this.collectors[i] == null) continue;
                return false;
            }
            return true;
        }
    }
}

