/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.common.concurrent.AutoCloseableRefCounted;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.replication.common.ReplicationTarget;
import org.opensearch.threadpool.ThreadPool;

public class ReplicationCollection<T extends ReplicationTarget> {
    private final ConcurrentMap<Long, T> onGoingTargetEvents = ConcurrentCollections.newConcurrentMap();
    private final Logger logger;
    private final ThreadPool threadPool;

    public ReplicationCollection(Logger logger, ThreadPool threadPool) {
        this.logger = logger;
        this.threadPool = threadPool;
    }

    public long start(T target, TimeValue activityTimeout) {
        this.startInternal(target, activityTimeout);
        return ((ReplicationTarget)((Object)target)).getId();
    }

    private void startInternal(T target, TimeValue activityTimeout) {
        ReplicationTarget existingTarget = (ReplicationTarget)((Object)this.onGoingTargetEvents.putIfAbsent(((ReplicationTarget)((Object)target)).getId(), target));
        assert (existingTarget == null) : "found two Target instances with the same id";
        this.logger.trace("started {}", (Object)((ReplicationTarget)((Object)target)).description());
        this.threadPool.schedule(new ReplicationMonitor(((ReplicationTarget)((Object)target)).getId(), ((ReplicationTarget)((Object)target)).lastAccessTime(), activityTimeout), activityTimeout, "generic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T reset(long id, TimeValue activityTimeout) {
        ReplicationTarget oldTarget = null;
        try {
            ReplicationTarget newTarget;
            ConcurrentMap<Long, T> concurrentMap = this.onGoingTargetEvents;
            synchronized (concurrentMap) {
                oldTarget = (ReplicationTarget)((Object)this.onGoingTargetEvents.remove(id));
                if (oldTarget == null) {
                    return null;
                }
                newTarget = oldTarget.retryCopy();
                this.startInternal(newTarget, activityTimeout);
            }
            boolean successfulReset = oldTarget.reset(newTarget.cancellableThreads());
            if (successfulReset) {
                this.logger.trace("restarted {}, previous id [{}]", (Object)newTarget.description(), (Object)oldTarget.getId());
                return (T)((Object)newTarget);
            }
            this.logger.trace("{} could not be reset as it is already cancelled, previous id [{}]", (Object)newTarget.description(), (Object)oldTarget.getId());
            this.cancel(newTarget.getId(), "cancelled during reset");
            return null;
        }
        catch (Exception e) {
            assert (oldTarget != null);
            oldTarget.notifyListener(new OpenSearchException("Unable to reset target", (Throwable)e, new Object[0]), true);
            return null;
        }
    }

    public T getTarget(long id) {
        return (T)((Object)((ReplicationTarget)((Object)this.onGoingTargetEvents.get(id))));
    }

    public ReplicationRef<T> get(long id) {
        ReplicationTarget status = (ReplicationTarget)((Object)this.onGoingTargetEvents.get(id));
        if (status != null && status.tryIncRef()) {
            return new ReplicationRef<ReplicationTarget>(status);
        }
        return null;
    }

    public ReplicationRef<T> getSafe(long id, ShardId shardId) {
        ReplicationRef<T> ref = this.get(id);
        if (ref == null) {
            throw new IndexShardClosedException(shardId);
        }
        assert (((ReplicationTarget)((Object)ref.get())).indexShard().shardId().equals(shardId));
        return ref;
    }

    public boolean cancel(long id, String reason) {
        ReplicationTarget removed = (ReplicationTarget)((Object)this.onGoingTargetEvents.remove(id));
        boolean cancelled = false;
        if (removed != null) {
            this.logger.trace("canceled {} (reason [{}])", (Object)removed.description(), (Object)reason);
            removed.cancel(reason);
            cancelled = true;
        }
        return cancelled;
    }

    public void fail(long id, OpenSearchException e, boolean sendShardFailure) {
        ReplicationTarget removed = (ReplicationTarget)((Object)this.onGoingTargetEvents.remove(id));
        if (removed != null) {
            this.logger.trace("failing {}. Send shard failure: [{}]", (Object)removed.description(), (Object)sendShardFailure);
            removed.fail(e, sendShardFailure);
        }
    }

    public void markAsDone(long id) {
        ReplicationTarget removed = (ReplicationTarget)((Object)this.onGoingTargetEvents.remove(id));
        if (removed != null) {
            this.logger.trace("Marking {} as done", (Object)removed.description());
            removed.markAsDone();
        }
    }

    public int size() {
        return this.onGoingTargetEvents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelForShard(ShardId shardId, String reason) {
        boolean cancelled = false;
        ArrayList<ReplicationTarget> matchedTargets = new ArrayList<ReplicationTarget>();
        ConcurrentMap<Long, T> concurrentMap = this.onGoingTargetEvents;
        synchronized (concurrentMap) {
            Iterator it = this.onGoingTargetEvents.values().iterator();
            while (it.hasNext()) {
                ReplicationTarget status = (ReplicationTarget)((Object)it.next());
                if (!status.indexShard().shardId().equals(shardId)) continue;
                matchedTargets.add(status);
                it.remove();
            }
        }
        for (ReplicationTarget removed : matchedTargets) {
            this.logger.trace("canceled {} (reason [{}])", (Object)removed.description(), (Object)reason);
            removed.cancel(reason);
            cancelled = true;
        }
        return cancelled;
    }

    private class ReplicationMonitor
    extends AbstractRunnable {
        private final long id;
        private final TimeValue checkInterval;
        private volatile long lastSeenAccessTime;

        private ReplicationMonitor(long id, long lastSeenAccessTime, TimeValue checkInterval) {
            this.id = id;
            this.checkInterval = checkInterval;
            this.lastSeenAccessTime = lastSeenAccessTime;
        }

        @Override
        public void onFailure(Exception e) {
            ReplicationCollection.this.logger.error(() -> new ParameterizedMessage("unexpected error while monitoring [{}]", (Object)this.id), (Throwable)e);
        }

        @Override
        protected void doRun() throws Exception {
            ReplicationTarget status = (ReplicationTarget)((Object)ReplicationCollection.this.onGoingTargetEvents.get(this.id));
            if (status == null) {
                ReplicationCollection.this.logger.trace("[monitor] no status found for [{}], shutting down", (Object)this.id);
                return;
            }
            long accessTime = status.lastAccessTime();
            if (accessTime == this.lastSeenAccessTime) {
                String message = "no activity after [" + this.checkInterval + "]";
                ReplicationCollection.this.fail(this.id, new OpenSearchTimeoutException(message, new Object[0]), true);
                return;
            }
            this.lastSeenAccessTime = accessTime;
            ReplicationCollection.this.logger.trace("[monitor] rescheduling check for [{}]. last access time is [{}]", (Object)this.id, (Object)this.lastSeenAccessTime);
            ReplicationCollection.this.threadPool.schedule(this, this.checkInterval, "generic");
        }
    }

    public static class ReplicationRef<T extends ReplicationTarget>
    extends AutoCloseableRefCounted<T> {
        public ReplicationRef(T status) {
            super(status);
            ((ReplicationTarget)((Object)status)).setLastAccessTime();
        }
    }
}

