/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.support.replication.ReplicationTask;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.checkpoint.PublishCheckpointRequest;
import org.opensearch.node.NodeClosedException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class PublishCheckpointAction
extends TransportReplicationAction<PublishCheckpointRequest, PublishCheckpointRequest, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/publishCheckpoint";
    protected static Logger logger = LogManager.getLogger(PublishCheckpointAction.class);

    @Inject
    public PublishCheckpointAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, PublishCheckpointRequest::new, PublishCheckpointRequest::new, "refresh");
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void doExecute(Task task, PublishCheckpointRequest request, ActionListener<ReplicationResponse> listener) {
        assert (false) : "use PublishCheckpointAction#publish";
    }

    final void publish(final IndexShard indexShard) {
        String primaryAllocationId = indexShard.routingEntry().allocationId().getId();
        long primaryTerm = indexShard.getPendingPrimaryTerm();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            PublishCheckpointRequest request = new PublishCheckpointRequest(indexShard.getLatestReplicationCheckpoint());
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "segrep_publish_checkpoint", request);
            this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<PublishCheckpointRequest>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){

                @Override
                public ReplicationResponse read(StreamInput in) throws IOException {
                    return PublishCheckpointAction.this.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister(task);
                }

                @Override
                public void handleException(TransportException e) {
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister(task);
                    if (ExceptionsHelper.unwrap(e, NodeClosedException.class) != null) {
                        return;
                    }
                    if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class) != null) {
                        return;
                    }
                    logger.warn((Message)new ParameterizedMessage("{} segment replication checkpoint publishing failed", (Object)indexShard.shardId()), (Throwable)e);
                }
            });
        }
    }

    @Override
    protected void shardOperationOnPrimary(PublishCheckpointRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<PublishCheckpointRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> new TransportReplicationAction.PrimaryResult<PublishCheckpointRequest, ReplicationResponse>(request, new ReplicationResponse()));
    }

    @Override
    protected void shardOperationOnReplica(PublishCheckpointRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(replica);
        ActionListener.completeWith(listener, () -> {
            logger.trace("Checkpoint received on replica {}", (Object)request);
            if (request.getCheckpoint().getShardId().equals(replica.shardId())) {
                replica.onNewCheckpoint(request);
            }
            return new TransportReplicationAction.ReplicaResult();
        });
    }
}

