/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.common.Nullable;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.recovery.FileChunkRequest;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.replication.SegmentReplicationSourceFactory;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.SegmentReplicationTarget;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationCollection;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportService;

public final class SegmentReplicationTargetService
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SegmentReplicationTargetService.class);
    private final ThreadPool threadPool;
    private final RecoverySettings recoverySettings;
    private final ReplicationCollection<SegmentReplicationTarget> onGoingReplications;
    private final SegmentReplicationSourceFactory sourceFactory;

    public SegmentReplicationTargetService(ThreadPool threadPool, RecoverySettings recoverySettings, TransportService transportService, SegmentReplicationSourceFactory sourceFactory) {
        this.threadPool = threadPool;
        this.recoverySettings = recoverySettings;
        this.onGoingReplications = new ReplicationCollection(logger, threadPool);
        this.sourceFactory = sourceFactory;
        transportService.registerRequestHandler("internal:index/shard/replication/file_chunk", "generic", FileChunkRequest::new, new FileChunkTransportRequestHandler());
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.onGoingReplications.cancelForShard(shardId, "shard closed");
        }
    }

    public void startReplication(ReplicationCheckpoint checkpoint, IndexShard indexShard, SegmentReplicationListener listener) {
        this.startReplication(new SegmentReplicationTarget(checkpoint, indexShard, this.sourceFactory.get(indexShard), listener));
    }

    public void startReplication(SegmentReplicationTarget target) {
        long replicationId = this.onGoingReplications.start(target, this.recoverySettings.activityTimeout());
        logger.trace(() -> new ParameterizedMessage("Starting replication {}", (Object)replicationId));
        this.threadPool.generic().execute(new ReplicationRunner(replicationId));
    }

    private void start(final long replicationId) {
        try (ReplicationCollection.ReplicationRef<SegmentReplicationTarget> replicationRef = this.onGoingReplications.get(replicationId);){
            ((SegmentReplicationTarget)((Object)replicationRef.get())).startReplication(new ActionListener<Void>(){

                @Override
                public void onResponse(Void o) {
                    SegmentReplicationTargetService.this.onGoingReplications.markAsDone(replicationId);
                }

                @Override
                public void onFailure(Exception e) {
                    SegmentReplicationTargetService.this.onGoingReplications.fail(replicationId, new OpenSearchException("Segment Replication failed", (Throwable)e, new Object[0]), true);
                }
            });
        }
    }

    public static class Actions {
        public static final String FILE_CHUNK = "internal:index/shard/replication/file_chunk";
    }

    private class FileChunkTransportRequestHandler
    implements TransportRequestHandler<FileChunkRequest> {
        final AtomicLong bytesSinceLastPause = new AtomicLong();

        private FileChunkTransportRequestHandler() {
        }

        @Override
        public void messageReceived(FileChunkRequest request, TransportChannel channel, Task task) throws Exception {
            try (ReplicationCollection.ReplicationRef<SegmentReplicationTarget> ref = SegmentReplicationTargetService.this.onGoingReplications.getSafe(request.recoveryId(), request.shardId());){
                SegmentReplicationTarget target = (SegmentReplicationTarget)((Object)ref.get());
                ActionListener<Void> listener = target.createOrFinishListener(channel, "internal:index/shard/replication/file_chunk", request);
                target.handleFileChunk(request, target, this.bytesSinceLastPause, SegmentReplicationTargetService.this.recoverySettings.rateLimiter(), listener);
            }
        }
    }

    public static interface SegmentReplicationListener
    extends ReplicationListener {
        @Override
        default public void onDone(ReplicationState state) {
            this.onReplicationDone((SegmentReplicationState)state);
        }

        @Override
        default public void onFailure(ReplicationState state, OpenSearchException e, boolean sendShardFailure) {
            this.onReplicationFailure((SegmentReplicationState)state, e, sendShardFailure);
        }

        public void onReplicationDone(SegmentReplicationState var1);

        public void onReplicationFailure(SegmentReplicationState var1, OpenSearchException var2, boolean var3);
    }

    private class ReplicationRunner
    implements Runnable {
        final long replicationId;

        public ReplicationRunner(long replicationId) {
            this.replicationId = replicationId;
        }

        @Override
        public void run() {
            SegmentReplicationTargetService.this.start(this.replicationId);
        }
    }
}

