/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.IOException;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.indices.replication.common.ReplicationTarget;

public class SegmentReplicationTarget
extends ReplicationTarget {
    private final ReplicationCheckpoint checkpoint;
    private final SegmentReplicationSource source;
    private final SegmentReplicationState state;

    public SegmentReplicationTarget(ReplicationCheckpoint checkpoint, IndexShard indexShard, SegmentReplicationSource source, SegmentReplicationTargetService.SegmentReplicationListener listener) {
        super("replication_target", indexShard, new ReplicationLuceneIndex(), listener);
        this.checkpoint = checkpoint;
        this.source = source;
        this.state = new SegmentReplicationState();
    }

    protected void closeInternal() {
    }

    @Override
    protected String getPrefix() {
        return null;
    }

    @Override
    protected void onDone() {
        this.state.setStage(SegmentReplicationState.Stage.DONE);
    }

    @Override
    protected void onCancel(String reason) {
    }

    @Override
    public ReplicationState state() {
        return this.state;
    }

    @Override
    public ReplicationTarget retryCopy() {
        return null;
    }

    @Override
    public String description() {
        return null;
    }

    @Override
    public void notifyListener(OpenSearchException e, boolean sendShardFailure) {
        this.listener.onFailure(this.state(), e, sendShardFailure);
    }

    @Override
    public boolean reset(CancellableThreads newTargetCancellableThreads) throws IOException {
        return false;
    }

    @Override
    public void writeFileChunk(StoreFileMetadata metadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
    }

    public void startReplication(ActionListener<Void> listener) {
    }
}

