/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.IOException;
import java.util.Set;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.transport.TransportResponse;

public class CheckpointInfoResponse
extends TransportResponse {
    private final ReplicationCheckpoint checkpoint;
    private final Store.MetadataSnapshot snapshot;
    private final byte[] infosBytes;
    private final Set<StoreFileMetadata> pendingDeleteFiles;

    public CheckpointInfoResponse(ReplicationCheckpoint checkpoint, Store.MetadataSnapshot snapshot, byte[] infosBytes, Set<StoreFileMetadata> additionalFiles) {
        this.checkpoint = checkpoint;
        this.snapshot = snapshot;
        this.infosBytes = infosBytes;
        this.pendingDeleteFiles = additionalFiles;
    }

    public CheckpointInfoResponse(StreamInput in) throws IOException {
        this.checkpoint = new ReplicationCheckpoint(in);
        this.snapshot = new Store.MetadataSnapshot(in);
        this.infosBytes = in.readByteArray();
        this.pendingDeleteFiles = in.readSet(StoreFileMetadata::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.checkpoint.writeTo(out);
        this.snapshot.writeTo(out);
        out.writeByteArray(this.infosBytes);
        out.writeCollection(this.pendingDeleteFiles);
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public Store.MetadataSnapshot getSnapshot() {
        return this.snapshot;
    }

    public byte[] getInfosBytes() {
        return this.infosBytes;
    }

    public Set<StoreFileMetadata> getPendingDeleteFiles() {
        return this.pendingDeleteFiles;
    }
}

