/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.SetOnce;
import org.opensearch.ExceptionsHelper;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateApplier;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.coordination.CoordinationState;
import org.opensearch.cluster.coordination.InMemoryPersistedState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.Manifest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.env.NodeMetadata;
import org.opensearch.gateway.ClusterStateUpdaters;
import org.opensearch.gateway.IncrementalClusterStateWriter;
import org.opensearch.gateway.MetaStateService;
import org.opensearch.gateway.PersistedClusterStateService;
import org.opensearch.gateway.WriteStateException;
import org.opensearch.node.Node;
import org.opensearch.plugins.MetadataUpgrader;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class GatewayMetaState
implements Closeable {
    public static final String STALE_STATE_CONFIG_NODE_ID = "STALE_STATE_CONFIG";
    private final SetOnce<CoordinationState.PersistedState> persistedState = new SetOnce();

    public CoordinationState.PersistedState getPersistedState() {
        CoordinationState.PersistedState persistedState = (CoordinationState.PersistedState)this.persistedState.get();
        assert (persistedState != null) : "not started";
        return persistedState;
    }

    public Metadata getMetadata() {
        return this.getPersistedState().getLastAcceptedState().metadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Settings settings, TransportService transportService, ClusterService clusterService, MetaStateService metaStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader, PersistedClusterStateService persistedClusterStateService) {
        assert (this.persistedState.get() == null) : "should only start once, but already have " + this.persistedState.get();
        if (DiscoveryNode.isClusterManagerNode(settings) || DiscoveryNode.isDataNode(settings)) {
            try {
                void var14_20;
                block24: {
                    PersistedClusterStateService.OnDiskState onDiskState = persistedClusterStateService.loadBestOnDiskState();
                    Metadata metadata = onDiskState.metadata;
                    long lastAcceptedVersion = onDiskState.lastAcceptedVersion;
                    long currentTerm = onDiskState.currentTerm;
                    if (onDiskState.empty()) {
                        assert (Version.CURRENT.major <= LegacyESVersion.V_7_0_0.major + 1) : "legacy metadata loader is not needed anymore from v9 onwards";
                        Tuple<Manifest, Metadata> tuple = metaStateService.loadFullState();
                        if (!((Manifest)tuple.v1()).isEmpty()) {
                            metadata = (Metadata)tuple.v2();
                            lastAcceptedVersion = ((Manifest)tuple.v1()).getClusterStateVersion();
                            currentTerm = ((Manifest)tuple.v1()).getCurrentTerm();
                        }
                    }
                    Closeable closeable = null;
                    boolean success = false;
                    try {
                        ClusterState clusterState = this.prepareInitialClusterState(transportService, clusterService, ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(settings)).version(lastAcceptedVersion).metadata(this.upgradeMetadataForNode(metadata, metadataIndexUpgradeService, metadataUpgrader)).build());
                        if (DiscoveryNode.isClusterManagerNode(settings)) {
                            LucenePersistedState lucenePersistedState = new LucenePersistedState(persistedClusterStateService, currentTerm, clusterState);
                        } else {
                            AsyncLucenePersistedState asyncLucenePersistedState = new AsyncLucenePersistedState(settings, transportService.getThreadPool(), new LucenePersistedState(persistedClusterStateService, currentTerm, clusterState));
                        }
                        if (DiscoveryNode.isDataNode(settings)) {
                            metaStateService.unreferenceAll();
                        } else {
                            metaStateService.deleteAll();
                        }
                        NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT), persistedClusterStateService.getDataPaths());
                        success = true;
                        if (success) break block24;
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        IOUtils.closeWhileHandlingException(closeable);
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable)var14_20);
                }
                this.persistedState.set((Object)var14_20);
                return;
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to load metadata", (Throwable)e, new Object[0]);
            }
        }
        long currentTerm = 0L;
        ClusterState clusterState = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(settings)).build();
        if (persistedClusterStateService.getDataPaths().length > 0) {
            try (PersistedClusterStateService.Writer persistenceWriter = persistedClusterStateService.createWriter();){
                persistenceWriter.writeFullStateAndCommit(0L, clusterState);
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to load metadata", (Throwable)e, new Object[0]);
            }
            try {
                metaStateService.deleteAll();
                NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT), persistedClusterStateService.getDataPaths());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.persistedState.set((Object)new InMemoryPersistedState(0L, clusterState));
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        assert (clusterState.nodes().getLocalNode() == null) : "prepareInitialClusterState must only be called once";
        assert (transportService.getLocalNode() != null) : "transport service is not yet started";
        return Function.identity().andThen(ClusterStateUpdaters::addStateNotRecoveredBlock).andThen(state -> ClusterStateUpdaters.setLocalNode(state, transportService.getLocalNode())).andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, clusterService.getClusterSettings())).andThen(ClusterStateUpdaters::recoverClusterBlocks).apply(clusterState);
    }

    Metadata upgradeMetadataForNode(Metadata metadata, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        return GatewayMetaState.upgradeMetadata(metadata, metadataIndexUpgradeService, metadataUpgrader);
    }

    static Metadata upgradeMetadata(Metadata metadata, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        boolean changed = false;
        Metadata.Builder upgradedMetadata = Metadata.builder(metadata);
        for (IndexMetadata indexMetadata : metadata) {
            IndexMetadata newMetadata;
            changed |= indexMetadata != (newMetadata = metadataIndexUpgradeService.upgradeIndexMetadata(indexMetadata, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetadata.put(newMetadata, false);
        }
        if (GatewayMetaState.applyPluginUpgraders(metadata.getTemplates(), metadataUpgrader.indexTemplateMetadataUpgraders, upgradedMetadata::removeTemplate, (s, indexTemplateMetadata) -> upgradedMetadata.put((IndexTemplateMetadata)indexTemplateMetadata))) {
            changed = true;
        }
        return changed ? upgradedMetadata.build() : metadata;
    }

    private static boolean applyPluginUpgraders(ImmutableOpenMap<String, IndexTemplateMetadata> existingData, UnaryOperator<Map<String, IndexTemplateMetadata>> upgrader, Consumer<String> removeData, BiConsumer<String, IndexTemplateMetadata> putData) {
        HashMap<String, IndexTemplateMetadata> existingMap = new HashMap<String, IndexTemplateMetadata>();
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : existingData) {
            existingMap.put((String)objectObjectCursor.key, (IndexTemplateMetadata)objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), (IndexTemplateMetadata)upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)((Closeable)this.persistedState.get()));
    }

    public boolean allPendingAsyncStatesWritten() {
        CoordinationState.PersistedState ps = (CoordinationState.PersistedState)this.persistedState.get();
        if (ps instanceof AsyncLucenePersistedState) {
            return ((AsyncLucenePersistedState)ps).allPendingAsyncStatesWritten();
        }
        return true;
    }

    static class LucenePersistedState
    implements CoordinationState.PersistedState {
        private long currentTerm;
        private ClusterState lastAcceptedState;
        private final PersistedClusterStateService persistedClusterStateService;
        private final AtomicReference<PersistedClusterStateService.Writer> persistenceWriter = new AtomicReference();
        boolean writeNextStateFully;

        LucenePersistedState(PersistedClusterStateService persistedClusterStateService, long currentTerm, ClusterState lastAcceptedState) throws IOException {
            this.persistedClusterStateService = persistedClusterStateService;
            this.currentTerm = currentTerm;
            this.lastAcceptedState = lastAcceptedState;
            PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();
            try {
                writer.writeFullStateAndCommit(currentTerm, lastAcceptedState);
            }
            catch (Exception e) {
                try {
                    writer.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            this.persistenceWriter.set(writer);
        }

        @Override
        public long getCurrentTerm() {
            return this.currentTerm;
        }

        @Override
        public ClusterState getLastAcceptedState() {
            return this.lastAcceptedState;
        }

        @Override
        public void setCurrentTerm(long currentTerm) {
            try {
                if (this.writeNextStateFully) {
                    this.getWriterSafe().writeFullStateAndCommit(currentTerm, this.lastAcceptedState);
                    this.writeNextStateFully = false;
                } else {
                    this.getWriterSafe().writeIncrementalTermUpdateAndCommit(currentTerm, this.lastAcceptedState.version());
                }
            }
            catch (Exception e) {
                this.handleExceptionOnWrite(e);
            }
            this.currentTerm = currentTerm;
        }

        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            try {
                if (this.writeNextStateFully) {
                    this.getWriterSafe().writeFullStateAndCommit(this.currentTerm, clusterState);
                    this.writeNextStateFully = false;
                } else if (clusterState.term() != this.lastAcceptedState.term()) {
                    assert (clusterState.term() > this.lastAcceptedState.term()) : clusterState.term() + " vs " + this.lastAcceptedState.term();
                    this.getWriterSafe().writeFullStateAndCommit(this.currentTerm, clusterState);
                } else {
                    this.getWriterSafe().writeIncrementalStateAndCommit(this.currentTerm, this.lastAcceptedState, clusterState);
                }
            }
            catch (Exception e) {
                this.handleExceptionOnWrite(e);
            }
            this.lastAcceptedState = clusterState;
        }

        private PersistedClusterStateService.Writer getWriterSafe() {
            PersistedClusterStateService.Writer writer = this.persistenceWriter.get();
            if (writer == null) {
                throw new AlreadyClosedException("persisted state has been closed");
            }
            if (writer.isOpen()) {
                return writer;
            }
            try {
                PersistedClusterStateService.Writer newWriter = this.persistedClusterStateService.createWriter();
                if (this.persistenceWriter.compareAndSet(writer, newWriter)) {
                    return newWriter;
                }
                assert (this.persistenceWriter.get() == null) : "expected no concurrent calls to getWriterSafe";
                newWriter.close();
                throw new AlreadyClosedException("persisted state has been closed");
            }
            catch (Exception e) {
                throw ExceptionsHelper.convertToRuntime(e);
            }
        }

        private void handleExceptionOnWrite(Exception e) {
            this.writeNextStateFully = true;
            throw ExceptionsHelper.convertToRuntime(e);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable)this.persistenceWriter.getAndSet(null));
        }
    }

    static class AsyncLucenePersistedState
    extends InMemoryPersistedState {
        private static final Logger logger = LogManager.getLogger(AsyncLucenePersistedState.class);
        static final String THREAD_NAME = "AsyncLucenePersistedState#updateTask";
        private final OpenSearchThreadPoolExecutor threadPoolExecutor;
        private final CoordinationState.PersistedState persistedState;
        boolean newCurrentTermQueued = false;
        boolean newStateQueued = false;
        private final Object mutex = new Object();
        static final CoordinationMetadata.VotingConfiguration staleStateConfiguration = new CoordinationMetadata.VotingConfiguration(Collections.singleton("STALE_STATE_CONFIG"));

        AsyncLucenePersistedState(Settings settings, ThreadPool threadPool, CoordinationState.PersistedState persistedState) {
            super(persistedState.getCurrentTerm(), persistedState.getLastAcceptedState());
            String nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
            this.threadPoolExecutor = OpenSearchExecutors.newFixed(nodeName + "/AsyncLucenePersistedState#updateTask", 1, 1, OpenSearchExecutors.daemonThreadFactory(nodeName, THREAD_NAME), threadPool.getThreadContext());
            this.persistedState = persistedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCurrentTerm(long currentTerm) {
            Object object = this.mutex;
            synchronized (object) {
                super.setCurrentTerm(currentTerm);
                if (this.newCurrentTermQueued) {
                    logger.trace("term update already queued (setting term to {})", (Object)currentTerm);
                } else {
                    logger.trace("queuing term update (setting term to {})", (Object)currentTerm);
                    this.newCurrentTermQueued = true;
                    if (!this.newStateQueued) {
                        this.scheduleUpdate();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            Object object = this.mutex;
            synchronized (object) {
                super.setLastAcceptedState(clusterState);
                if (this.newStateQueued) {
                    logger.trace("cluster state update already queued (setting cluster state to {})", (Object)clusterState.version());
                } else {
                    logger.trace("queuing cluster state update (setting cluster state to {})", (Object)clusterState.version());
                    this.newStateQueued = true;
                    if (!this.newCurrentTermQueued) {
                        this.scheduleUpdate();
                    }
                }
            }
        }

        private void scheduleUpdate() {
            assert (Thread.holdsLock(this.mutex));
            assert (this.threadPoolExecutor.getQueue().isEmpty()) : "threadPoolExecutor queue not empty";
            this.threadPoolExecutor.execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.error("Exception occurred when storing new meta data", (Throwable)e);
                }

                @Override
                public void onRejection(Exception e) {
                    assert (threadPoolExecutor.isShutdown()) : "only expect rejections when shutting down";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doRun() {
                    ClusterState clusterState;
                    Long term;
                    Object object = mutex;
                    synchronized (object) {
                        if (newCurrentTermQueued) {
                            term = this.getCurrentTerm();
                            logger.trace("resetting newCurrentTermQueued");
                            newCurrentTermQueued = false;
                        } else {
                            term = null;
                        }
                        if (newStateQueued) {
                            clusterState = this.getLastAcceptedState();
                            logger.trace("resetting newStateQueued");
                            newStateQueued = false;
                        } else {
                            clusterState = null;
                        }
                    }
                    if (term != null) {
                        persistedState.setCurrentTerm(term);
                    }
                    if (clusterState != null) {
                        persistedState.setLastAcceptedState(AsyncLucenePersistedState.resetVotingConfiguration(clusterState));
                    }
                }
            });
        }

        static ClusterState resetVotingConfiguration(ClusterState clusterState) {
            CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(clusterState.coordinationMetadata()).lastAcceptedConfiguration(staleStateConfiguration).lastCommittedConfiguration(staleStateConfiguration).build();
            return ClusterState.builder(clusterState).metadata(Metadata.builder(clusterState.metadata()).coordinationMetadata(newCoordinationMetadata).build()).build();
        }

        @Override
        public void close() throws IOException {
            try {
                ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
            }
            finally {
                this.persistedState.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean allPendingAsyncStatesWritten() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.newCurrentTermQueued || this.newStateQueued) {
                    return false;
                }
                return this.threadPoolExecutor.getActiveCount() == 0;
            }
        }
    }

    private static class GatewayClusterApplier
    implements ClusterStateApplier {
        private static final Logger logger = LogManager.getLogger(GatewayClusterApplier.class);
        private final IncrementalClusterStateWriter incrementalClusterStateWriter;

        private GatewayClusterApplier(IncrementalClusterStateWriter incrementalClusterStateWriter) {
            this.incrementalClusterStateWriter = incrementalClusterStateWriter;
        }

        @Override
        public void applyClusterState(ClusterChangedEvent event) {
            if (event.state().blocks().disableStatePersistence()) {
                this.incrementalClusterStateWriter.setIncrementalWrite(false);
                return;
            }
            try {
                if (event.state().term() > this.incrementalClusterStateWriter.getPreviousManifest().getCurrentTerm()) {
                    this.incrementalClusterStateWriter.setCurrentTerm(event.state().term());
                }
                this.incrementalClusterStateWriter.updateClusterState(event.state());
                this.incrementalClusterStateWriter.setIncrementalWrite(true);
            }
            catch (WriteStateException e) {
                logger.warn("Exception occurred when storing new meta data", (Throwable)e);
            }
        }
    }
}

