/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;

public class ByteArrayIndexInput
extends IndexInput {
    private final byte[] bytes;
    private int pos;
    private int offset;
    private int length;

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes) {
        this(resourceDesc, bytes, 0, bytes.length);
    }

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes, int offset, int length) {
        super(resourceDesc);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Seeking to negative position: " + this.pos);
        }
        if (l > (long)this.length) {
            throw new EOFException("seek past EOF");
        }
        this.pos = (int)l;
    }

    public long length() {
        return this.length;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset >= 0L && length >= 0L && offset + length <= (long)this.length) {
            return new ByteArrayIndexInput(sliceDescription, this.bytes, this.offset + (int)offset, (int)length);
        }
        throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + this);
    }

    public byte readByte() throws IOException {
        if (this.pos >= this.offset + this.length) {
            throw new EOFException("seek past EOF");
        }
        return this.bytes[this.offset + this.pos++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.pos + len > this.offset + this.length) {
            throw new EOFException("seek past EOF");
        }
        System.arraycopy(this.bytes, this.offset + this.pos, b, offset, len);
        this.pos += len;
    }
}

