/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.io.stream.StreamInput;

public class BytesStreamInput
extends StreamInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public BytesStreamInput(byte[] bytes) {
        this.reset(bytes);
    }

    public BytesStreamInput(byte[] bytes, int offset, int len) {
        this.reset(bytes, offset, len);
    }

    public BytesStreamInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public boolean eof() {
        return this.pos == this.limit;
    }

    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos + count);
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.limit - this.pos;
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        int available = this.available();
        if (length > available) {
            throw new EOFException("attempting to read " + length + " bytes but only " + available + " bytes are available");
        }
    }

    @Override
    public int read() throws IOException {
        return this.bytes[this.pos++] & 0xFF;
    }
}

