/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.Locale;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class ThrottlingAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(ThrottlingAllocationDecider.class);
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES = 2;
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_RECOVERIES = 4;
    public static final String NAME = "throttling";
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_recoveries", Integer.toString(2), s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING = Setting.intSetting("cluster.routing.allocation.node_initial_primaries_recoveries", 4, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_REPLICAS_RECOVERIES_SETTING = Setting.intSetting("cluster.routing.allocation.node_initial_replicas_recoveries", 4, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_incoming_recoveries", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_incoming_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_outgoing_recoveries", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_outgoing_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int primariesInitialRecoveries;
    private volatile int concurrentIncomingRecoveries;
    private volatile int concurrentOutgoingRecoveries;
    private volatile int replicasInitialRecoveries;

    public ThrottlingAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.primariesInitialRecoveries = CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING.get(settings);
        this.replicasInitialRecoveries = CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_REPLICAS_RECOVERIES_SETTING.get(settings);
        this.concurrentIncomingRecoveries = CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.get(settings);
        this.concurrentOutgoingRecoveries = CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING, this::setPrimariesInitialRecoveries);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING, this::setConcurrentIncomingRecoverries);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING, this::setConcurrentOutgoingRecoverries);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_REPLICAS_RECOVERIES_SETTING, this::setReplicasInitialRecoveries);
        logger.debug("using node_concurrent_outgoing_recoveries [{}], node_concurrent_incoming_recoveries [{}], node_initial_primaries_recoveries [{}], node_initial_replicas_recoveries [{}]", (Object)this.concurrentOutgoingRecoveries, (Object)this.concurrentIncomingRecoveries, (Object)this.primariesInitialRecoveries, (Object)this.replicasInitialRecoveries);
    }

    private void setConcurrentIncomingRecoverries(int concurrentIncomingRecoveries) {
        this.concurrentIncomingRecoveries = concurrentIncomingRecoveries;
    }

    private void setConcurrentOutgoingRecoverries(int concurrentOutgoingRecoveries) {
        this.concurrentOutgoingRecoveries = concurrentOutgoingRecoveries;
    }

    private void setPrimariesInitialRecoveries(int primariesInitialRecoveries) {
        this.primariesInitialRecoveries = primariesInitialRecoveries;
    }

    private void setReplicasInitialRecoveries(int replicasInitialRecoveries) {
        this.replicasInitialRecoveries = replicasInitialRecoveries;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary() && shardRouting.unassigned()) {
            assert (this.initializingShard(shardRouting, node.nodeId()).recoverySource().getType() != RecoverySource.Type.PEER);
            int primariesInRecovery = allocation.routingNodes().getInitialPrimariesIncomingRecoveries(node.nodeId());
            if (primariesInRecovery >= this.primariesInitialRecoveries) {
                return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of ongoing initial primary recoveries [%d], cluster setting [%s=%d]", primariesInRecovery, CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING.getKey(), this.primariesInitialRecoveries);
            }
            return allocation.decision(Decision.YES, NAME, "below primary recovery limit of [%d]", this.primariesInitialRecoveries);
        }
        assert (this.initializingShard(shardRouting, node.nodeId()).recoverySource().getType() == RecoverySource.Type.PEER);
        if (shardRouting.unassignedReasonIndexCreated()) {
            return this.allocateInitialShardCopies(shardRouting, node, allocation);
        }
        return this.allocateNonInitialShardCopies(shardRouting, node, allocation);
    }

    private Decision allocateInitialShardCopies(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        int currentInRecoveries = allocation.routingNodes().getInitialIncomingRecoveries(node.nodeId());
        assert (shardRouting.unassignedReasonIndexCreated() && !shardRouting.primary());
        return this.allocateShardCopies(shardRouting, allocation, currentInRecoveries, this.replicasInitialRecoveries, (x, y) -> this.getInitialPrimaryNodeOutgoingRecoveries((ShardRouting)x, (RoutingAllocation)y), this.replicasInitialRecoveries, String.format(Locale.ROOT, "[%s=%d]", CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_REPLICAS_RECOVERIES_SETTING.getKey(), this.replicasInitialRecoveries), String.format(Locale.ROOT, "[%s=%d]", CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_REPLICAS_RECOVERIES_SETTING.getKey(), this.replicasInitialRecoveries));
    }

    private Decision allocateNonInitialShardCopies(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (!shardRouting.unassignedReasonIndexCreated());
        int currentInRecoveries = allocation.routingNodes().getIncomingRecoveries(node.nodeId());
        return this.allocateShardCopies(shardRouting, allocation, currentInRecoveries, this.concurrentIncomingRecoveries, (x, y) -> this.getPrimaryNodeOutgoingRecoveries((ShardRouting)x, (RoutingAllocation)y), this.concurrentOutgoingRecoveries, String.format(Locale.ROOT, "[%s=%d] (can also be set via [%s])", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), this.concurrentIncomingRecoveries, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING.getKey()), String.format(Locale.ROOT, "[%s=%d] (can also be set via [%s])", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), this.concurrentOutgoingRecoveries, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING.getKey()));
    }

    private Integer getPrimaryNodeOutgoingRecoveries(ShardRouting shardRouting, RoutingAllocation allocation) {
        ShardRouting primaryShard = allocation.routingNodes().activePrimary(shardRouting.shardId());
        return allocation.routingNodes().getOutgoingRecoveries(primaryShard.currentNodeId());
    }

    private Integer getInitialPrimaryNodeOutgoingRecoveries(ShardRouting shardRouting, RoutingAllocation allocation) {
        ShardRouting primaryShard = allocation.routingNodes().activePrimary(shardRouting.shardId());
        return allocation.routingNodes().getInitialOutgoingRecoveries(primaryShard.currentNodeId());
    }

    private Decision allocateShardCopies(ShardRouting shardRouting, RoutingAllocation allocation, int currentInRecoveries, int inRecoveriesLimit, BiFunction<ShardRouting, RoutingAllocation, Integer> primaryNodeOutRecoveriesFunc, int outRecoveriesLimit, String incomingRecoveriesSettingMsg, String outGoingRecoveriesSettingMsg) {
        if (currentInRecoveries >= inRecoveriesLimit) {
            return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of incoming shard recoveries [%d], cluster setting %s", currentInRecoveries, incomingRecoveriesSettingMsg);
        }
        ShardRouting primaryShard = allocation.routingNodes().activePrimary(shardRouting.shardId());
        if (primaryShard == null) {
            return allocation.decision(Decision.NO, NAME, "primary shard for this replica is not yet active", new Object[0]);
        }
        int primaryNodeOutRecoveries = primaryNodeOutRecoveriesFunc.apply(shardRouting, allocation);
        if (primaryNodeOutRecoveries >= outRecoveriesLimit) {
            return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of outgoing shard recoveries [%d] on the node [%s] which holds the primary, cluster setting %s", primaryNodeOutRecoveries, primaryShard.currentNodeId(), outGoingRecoveriesSettingMsg);
        }
        return allocation.decision(Decision.YES, NAME, "below shard recovery limit of outgoing: [%d < %d] incoming: [%d < %d]", primaryNodeOutRecoveries, outRecoveriesLimit, currentInRecoveries, inRecoveriesLimit);
    }

    private ShardRouting initializingShard(ShardRouting shardRouting, String currentNodeId) {
        ShardRouting initializingShard;
        if (shardRouting.unassigned()) {
            initializingShard = shardRouting.initialize(currentNodeId, null, -1L);
        } else if (shardRouting.initializing()) {
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (unassignedInfo == null) {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.ALLOCATION_FAILED, "fake");
            }
            initializingShard = shardRouting.moveToUnassigned(unassignedInfo).initialize(currentNodeId, null, -1L);
        } else if (shardRouting.relocating()) {
            initializingShard = shardRouting.cancelRelocation().relocate(currentNodeId, -1L).getTargetRelocatingShard();
        } else {
            assert (shardRouting.started());
            initializingShard = shardRouting.relocate(currentNodeId, -1L).getTargetRelocatingShard();
        }
        assert (initializingShard.initializing());
        return initializingShard;
    }

    @Override
    public Decision canMoveAway(ShardRouting shardRouting, RoutingAllocation allocation) {
        int outgoingRecoveries = 0;
        if (!shardRouting.primary()) {
            ShardRouting primaryShard = allocation.routingNodes().activePrimary(shardRouting.shardId());
            outgoingRecoveries = allocation.routingNodes().getOutgoingRecoveries(primaryShard.currentNodeId());
        } else {
            outgoingRecoveries = allocation.routingNodes().getOutgoingRecoveries(shardRouting.currentNodeId());
        }
        if (outgoingRecoveries >= this.concurrentOutgoingRecoveries) {
            return allocation.decision(Decision.THROTTLE, NAME, "too many outgoing shards are currently recovering [%d], limit: [%d] cluster setting [%s=%d]", outgoingRecoveries, this.concurrentOutgoingRecoveries, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), this.concurrentOutgoingRecoveries);
        }
        return allocation.decision(Decision.YES, NAME, "below shard recovery limit of outgoing: [%d < %d]", outgoingRecoveries, this.concurrentOutgoingRecoveries);
    }

    @Override
    public Decision canAllocateAnyShardToNode(RoutingNode node, RoutingAllocation allocation) {
        int incomingRecoveries = allocation.routingNodes().getIncomingRecoveries(node.nodeId());
        if (incomingRecoveries >= this.concurrentIncomingRecoveries) {
            return allocation.decision(Decision.THROTTLE, NAME, "too many incoming shards are currently recovering [%d], limit: [%d] cluster setting [%s=%d]", incomingRecoveries, this.concurrentIncomingRecoveries, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), this.concurrentIncomingRecoveries);
        }
        return allocation.decision(Decision.YES, NAME, "below shard recovery limit of incoming: [%d < %d]", incomingRecoveries, this.concurrentIncomingRecoveries);
    }
}

