/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.utils;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.ThreadContext;

public class LogUtils {
    private static final String REQUEST_ID_KEY = "request_id";
    private static final String EMPTY_ID = "ID";

    public static void addRequestId() {
        ThreadContext.put((String)REQUEST_ID_KEY, (String)UUID.randomUUID().toString());
    }

    public static String getRequestId() {
        return Optional.ofNullable(ThreadContext.get((String)REQUEST_ID_KEY)).orElseGet(() -> EMPTY_ID);
    }

    public static Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }

    private LogUtils() {
        throw new AssertionError((Object)(this.getClass().getCanonicalName() + " is a utility class and must not be initialized"));
    }
}

