/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.TransformMetadataService;
import org.opensearch.indexmanagement.transform.exceptions.TransformMetadataException;
import org.opensearch.indexmanagement.transform.model.ContinuousTransformStats;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.transform.model.TransformMetadata;
import org.opensearch.indexmanagement.transform.model.TransformStats;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformMetadataService;", "", "client", "Lorg/opensearch/client/Client;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/client/Client;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "createMetadata", "Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMetadata", "writeMetadata", "metadata", "updating", "", "(Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class TransformMetadataService {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private final Logger logger;

    public TransformMetadataService(@NotNull Client client, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.logger = LogManager.getLogger(this.getClass());
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getMetadata(@NotNull Transform var1_1, @NotNull Continuation<? super TransformMetadata> var2_2) {
        if (!(var2_2 instanceof getMetadata.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransformMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getMetadata(null, (Continuation<? super TransformMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (transform.getMetadataId() == null) break;
                getRequest = new GetRequest(".opendistro-ism-config", transform.getMetadataId()).routing(transform.getId());
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(getRequest){
                    final /* synthetic */ GetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.get(this.$getRequest, it);
                    }
                }, $continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (TransformMetadataService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((metadataSource = (response = (GetResponse)v0).getSourceAsBytesRef()) != null) ** GOTO lbl27
                v1 = null;
                ** GOTO lbl40
lbl27:
                // 1 sources

                $i$a$-let-TransformMetadataService$getMetadata$transformMetadata$1 = false;
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransformMetadata>, Object>(this, metadataSource, response, null){
                    int label;
                    final /* synthetic */ TransformMetadataService this$0;
                    final /* synthetic */ BytesReference $metadataSource;
                    final /* synthetic */ GetResponse $response;
                    {
                        this.this$0 = $receiver;
                        this.$metadataSource = $metadataSource;
                        this.$response = $response;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)this.$metadataSource, (XContentType)XContentType.JSON);
                                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                                String string = this.$response.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                                return OpenSearchExtensionsKt.parseWithType(xcp, string, this.$response.getSeqNo(), this.$response.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, TransformMetadata>((Object)TransformMetadata.Companion){

                                    @NotNull
                                    public final TransformMetadata invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                        return ((TransformMetadata.Companion)this.receiver).parse(p0, p1, p2, p3);
                                    }
                                });
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TransformMetadata> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                $i$a$-let-TransformMetadataService$getMetadata$transformMetadata$1 = false;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                v1 = (TransformMetadata)v2;
lbl40:
                // 2 sources

                v3 = transformMetadata = v1;
                if (v3 != null) break;
                throw new TransformMetadataException("Failed to parse the existing metadata document", null, 2, null);
            }
        }
        this.logger.debug("Creating metadata doc as none exists at the moment for transform job [" + transform.getId() + "]");
        $continuation.label = 3;
        v4 = this.createMetadata((Transform)transform, (Continuation<? super TransformMetadata>)$continuation);
        if (v4 == var10_5) {
            return var10_5;
        }
        ** GOTO lbl52
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl52:
                // 2 sources

                return v4;
            }
        }
        return v3;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object createMetadata(Transform transform2, Continuation<? super TransformMetadata> $completion) {
        String id2 = IndexUtils.Companion.hashToFixedSize("TransformMetadata#" + transform2.getId() + "#" + transform2.getLastUpdateTime());
        String string = transform2.getId();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        TransformMetadata metadata2 = new TransformMetadata(id2, 0L, 0L, string, null, instant, TransformMetadata.Status.INIT, null, new TransformStats(0L, 0L, 0L, 0L, 0L), null, transform2.getContinuous() ? new ContinuousTransformStats(null, null) : null, 662, null);
        return TransformMetadataService.writeMetadata$default(this, metadata2, false, $completion, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object writeMetadata(@NotNull TransformMetadata var1_1, boolean var2_2, @NotNull Continuation<? super TransformMetadata> var3_3) {
        if (!(var3_3 instanceof writeMetadata.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TransformMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.writeMetadata(null, false, (Continuation<? super TransformMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage = "Failed to " + (updating != false ? "update" : "create") + " metadata doc " + metadata.getId() + " for transform job " + metadata.getTransformId();
                var6_8 = XContentFactory.jsonBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"jsonBuilder()");
                v0 = var6_8;
                var6_8 = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"EMPTY_PARAMS");
                builder = metadata.toXContent(v0, (ToXContent.Params)var6_8);
                indexRequest = new IndexRequest(".opendistro-ism-config").source(builder).id(metadata.getId()).routing(metadata.getTransformId());
                if (updating != false) {
                    indexRequest.setIfSeqNo(metadata.getSeqNo()).setIfPrimaryTerm(metadata.getPrimaryTerm());
                } else {
                    indexRequest.opType(DocWriteRequest.OpType.CREATE);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = metadata;
                $continuation.L$2 = errorMessage;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(indexRequest){
                    final /* synthetic */ IndexRequest $indexRequest;
                    {
                        this.$indexRequest = $indexRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.index(this.$indexRequest, it);
                    }
                }, $continuation);
                ** if (v1 != var10_6) goto lbl35
lbl34:
                // 1 sources

                return var10_6;
lbl35:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                errorMessage = (String)$continuation.L$2;
                metadata = (TransformMetadata)$continuation.L$1;
                this = (TransformMetadataService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl44:
                    // 2 sources

                    response = (IndexResponse)v1;
                    v2 = response.getResult();
                    switch (v2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            this.logger.error((String)errorMessage);
                            v3 = response.getResult();
                            throw new TransformMetadataException("Failed to write metadata, received " + (String)(v3 == null ? null : v3.getLowercase()) + " status", null, 2, null);
                        }
                    }
                    return TransformMetadata.copy$default(metadata, null, response.getSeqNo(), response.getPrimaryTerm(), null, null, null, null, null, null, null, null, 2041, null);
                }
                catch (RemoteTransportException e) {
                    v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (v4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    unwrappedException = (Exception)v4;
                    this.logger.error((String)errorMessage, (Throwable)unwrappedException);
                    throw new TransformMetadataException((String)errorMessage, unwrappedException);
                }
                catch (Exception e) {
                    this.logger.error((String)errorMessage, (Throwable)e);
                    throw new TransformMetadataException((String)errorMessage, e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object writeMetadata$default(TransformMetadataService transformMetadataService, TransformMetadata transformMetadata2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return transformMetadataService.writeMetadata(transformMetadata2, bl, (Continuation<? super TransformMetadata>)continuation);
    }

    public static final /* synthetic */ Object access$createMetadata(TransformMetadataService $this, Transform transform2, Continuation $completion) {
        return $this.createMetadata(transform2, (Continuation<? super TransformMetadata>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocWriteResponse.Result.values().length];
            nArray[DocWriteResponse.Result.CREATED.ordinal()] = 1;
            nArray[DocWriteResponse.Result.UPDATED.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

