/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.RollupIndexResult;
import org.opensearch.indexmanagement.rollup.RollupIndexer;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupStats;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.transport.RemoteTransportException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J!\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupIndexer;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/client/Client;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/client/Client;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "retryIngestPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "convertResponseToRequests", "", "Lorg/opensearch/action/DocWriteRequest;", "job", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "internalComposite", "Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;", "indexRollups", "Lorg/opensearch/indexmanagement/rollup/RollupIndexResult;", "rollup", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class RollupIndexer {
    @NotNull
    private final Client client;
    private final Logger logger;
    private volatile BackoffPolicy retryIngestPolicy;

    public RollupIndexer(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_MILLIS().get(settings);
        Object object = RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_COUNT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROLLUP_INGEST_BACKOFF_COUNT.get(settings)");
        this.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_MILLIS(), RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_COUNT(), (arg_0, arg_1) -> RollupIndexer._init_$lambda-0(this, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object indexRollups(@NotNull Rollup var1_1, @NotNull InternalComposite var2_2, @NotNull Continuation<? super RollupIndexResult> var3_3) {
        if (!(var3_3 instanceof indexRollups.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RollupIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.indexRollups(null, null, (Continuation<? super RollupIndexResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestsToRetry = new Ref.ObjectRef();
                requestsToRetry.element = this.convertResponseToRequests((Rollup)rollup, (InternalComposite)internalComposite);
                stats = new Ref.ObjectRef();
                stats.element = new RollupStats(0L, 0L, ((List)requestsToRetry.element).size(), 0L, 0L);
                nonRetryableFailures = new ArrayList<E>();
                if (!(((Collection)requestsToRetry.element).isEmpty() == false)) ** GOTO lbl41
                var7_12 = this.retryIngestPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var7_12, (String)"retryIngestPolicy");
                v0 = var7_12;
                var7_12 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var7_12, (String)"logger");
                $continuation.L$0 = this;
                $continuation.L$1 = stats;
                $continuation.L$2 = nonRetryableFailures;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.retry((BackoffPolicy)v0, (Logger)var7_12, CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(requestsToRetry, this, (Ref.ObjectRef<RollupStats>)stats, (List<BulkItemResponse>)nonRetryableFailures, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Ref.ObjectRef<List<DocWriteRequest<?>>> $requestsToRetry;
                    final /* synthetic */ RollupIndexer this$0;
                    final /* synthetic */ Ref.ObjectRef<RollupStats> $stats;
                    final /* synthetic */ List<BulkItemResponse> $nonRetryableFailures;
                    {
                        this.$requestsToRetry = $requestsToRetry;
                        this.this$0 = $receiver;
                        this.$stats = $stats;
                        this.$nonRetryableFailures = $nonRetryableFailures;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                it = (TimeValue)this.L$0;
                                if (it.getSeconds() >= 900L) {
                                    var3_4 = ExceptionsHelper.convertToOpenSearchException((Exception)new IllegalStateException("Cannot retry ingestion with a delay more than half of the rollup lock TTL"));
                                    Intrinsics.checkNotNullExpressionValue((Object)var3_4, (String)"convertToOpenSearchExcep\u2026                        )");
                                    throw (Throwable)var3_4;
                                }
                                bulkRequest = new BulkRequest().add((Iterable)this.$requestsToRetry.element);
                                this.L$0 = bulkRequest;
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)RollupIndexer.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                                    final /* synthetic */ BulkRequest $bulkRequest;
                                    {
                                        this.$bulkRequest = $bulkRequest;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.bulk(this.$bulkRequest, it);
                                    }
                                }, (Continuation)this);
                                if (v0 == var19_2) {
                                    return var19_2;
                                }
                                ** GOTO lbl21
                            }
                            case 1: {
                                bulkRequest = (BulkRequest)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl21:
                                // 2 sources

                                bulkResponse = (BulkResponse)v0;
                                this.$stats.element = RollupStats.copy$default((RollupStats)this.$stats.element, 0L, 0L, 0L, ((RollupStats)this.$stats.element).getIndexTimeInMillis() + bulkResponse.getTook().getMillis(), 0L, 23, null);
                                retryableFailures = new ArrayList<E>();
                                v1 = bulkResponse.getItems();
                                if (v1 == null) {
                                    v1 = new BulkItemResponse[]{};
                                }
                                $this$filter$iv = v1;
                                $i$f$filter = false;
                                var8_13 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (void element$iv$iv : $this$filterTo$iv$iv) {
                                    it = element$iv$iv;
                                    $i$a$-filter-RollupIndexer$indexRollups$2$1 = false;
                                    if (!it.isFailed()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$forEach$iv = (List)destination$iv$iv;
                                $i$f$filter = this.$nonRetryableFailures;
                                $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    failedResponse = (BulkItemResponse)element$iv;
                                    $i$a$-forEach-RollupIndexer$indexRollups$2$2 = false;
                                    if (failedResponse.status() == RestStatus.TOO_MANY_REQUESTS) {
                                        Intrinsics.checkNotNullExpressionValue((Object)failedResponse, (String)"failedResponse");
                                        retryableFailures.add(failedResponse);
                                        continue;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)failedResponse, (String)"failedResponse");
                                    $i$f$filter.add(failedResponse);
                                }
                                $this$forEach$iv = retryableFailures;
                                var17_28 = this.$requestsToRetry;
                                $i$f$map = false;
                                $i$f$forEach = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var13_23 = (BulkItemResponse)item$iv$iv;
                                    var18_29 = destination$iv$iv;
                                    $i$a$-map-RollupIndexer$indexRollups$2$3 = false;
                                    v2 = bulkRequest.requests().get(retryableFailure.getItemId());
                                    if (v2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type org.opensearch.action.index.IndexRequest");
                                    }
                                    var18_29.add((IndexRequest)v2);
                                }
                                var17_28.element = (List)destination$iv$iv;
                                if (((Collection)this.$requestsToRetry.element).isEmpty() == false) {
                                    retryCause = ((BulkItemResponse)CollectionsKt.first((List)retryableFailures)).getFailure().getCause();
                                    var7_12 = ExceptionsHelper.convertToOpenSearchException((Exception)retryCause);
                                    Intrinsics.checkNotNullExpressionValue((Object)var7_12, (String)"convertToOpenSearchException(retryCause)");
                                    throw (Throwable)var7_12;
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v1 != var10_6) goto lbl32
lbl31:
                // 1 sources

                return var10_6;
lbl32:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                nonRetryableFailures = (List)$continuation.L$2;
                stats = (Ref.ObjectRef)$continuation.L$1;
                this = (RollupIndexer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 3 sources

                    if (((Collection)nonRetryableFailures).isEmpty() == false) {
                        this.logger.error("Failed to index " + nonRetryableFailures.size() + " documents");
                        var7_12 = ExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)CollectionsKt.first((List)nonRetryableFailures)).getFailure().getCause());
                        Intrinsics.checkNotNullExpressionValue((Object)var7_12, (String)"convertToOpenSearchExcep\u2026es.first().failure.cause)");
                        throw (Throwable)var7_12;
                    }
                    return new RollupIndexResult.Success((RollupStats)stats.element);
                }
                catch (RemoteTransportException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    return new RollupIndexResult.Failure(null, (Exception)v2, 1, null);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    return new RollupIndexResult.Failure(null, e, 1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final List<DocWriteRequest<?>> convertResponseToRequests(@NotNull Rollup job, @NotNull InternalComposite internalComposite) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)internalComposite, (String)"internalComposite");
        List requests = new ArrayList();
        List list = internalComposite.getBuckets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"internalComposite.buckets");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Map.Entry it;
            InternalComposite.InternalBucket it2 = (InternalComposite.InternalBucket)element$iv;
            boolean bl = false;
            String docId2 = job.getId() + "#" + CollectionsKt.joinToString$default((Iterable)it2.getKey().entrySet(), (CharSequence)"#", null, null, (int)0, null, (Function1)convertResponseToRequests.1.docId.1.INSTANCE, (int)30, null);
            String documentId = IndexUtils.Companion.hashToFixedSize(docId2);
            Map<String, Object> mapOfKeyValues = RollupUtilsKt.getInitialDocValues(job, it2.getDocCount());
            Map aggResults = new LinkedHashMap();
            Iterable $this$forEach$iv2 = it2.getKey().entrySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Map.Entry)element$iv2;
                boolean bl2 = false;
                object = it.getKey();
                Intrinsics.checkNotNullExpressionValue(object, (String)"it.key");
                aggResults.put(object, it.getValue());
            }
            $this$forEach$iv2 = it2.getAggregations();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv2, (String)"it.aggregations");
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String string;
                it = (Aggregation)element$iv2;
                boolean bl3 = false;
                object = it;
                if (object instanceof InternalSum) {
                    string = ((InternalSum)it).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    aggResults.put(string, ((InternalSum)it).getValue());
                    continue;
                }
                if (object instanceof InternalMax) {
                    string = ((InternalMax)it).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    aggResults.put(string, ((InternalMax)it).getValue());
                    continue;
                }
                if (object instanceof InternalMin) {
                    string = ((InternalMin)it).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    aggResults.put(string, ((InternalMin)it).getValue());
                    continue;
                }
                if (object instanceof InternalValueCount) {
                    string = ((InternalValueCount)it).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    aggResults.put(string, ((InternalValueCount)it).getValue());
                    continue;
                }
                if (object instanceof InternalAvg) {
                    string = ((InternalAvg)it).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    aggResults.put(string, ((InternalAvg)it).getValue());
                    continue;
                }
                throw new IllegalStateException("Found aggregation in composite result that is not supported [" + it.getType() + " - " + it.getName() + "]");
            }
            mapOfKeyValues.putAll(aggResults);
            String targetIndexResolvedName = RollupFieldValueExpressionResolver.INSTANCE.resolve(job, job.getTargetIndex());
            IndexRequest indexRequest = new IndexRequest(targetIndexResolvedName).id(documentId).source(mapOfKeyValues, XContentType.JSON);
            Intrinsics.checkNotNullExpressionValue((Object)indexRequest, (String)"indexRequest");
            requests.add(indexRequest);
        }
        return requests;
    }

    private static final void _init_$lambda-0(RollupIndexer this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        this$0.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    public static final /* synthetic */ Client access$getClient$p(RollupIndexer $this) {
        return $this.client;
    }
}

