/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.geojson;

import java.util.Map;
import java.util.Objects;
import org.opensearch.geospatial.GeospatialParser;
import org.opensearch.geospatial.geojson.Feature;

public class FeatureFactory {
    public static Feature create(Map<String, Object> input) {
        Objects.requireNonNull(input, "input cannot be null");
        Object geoJSONType = input.get("type");
        if (geoJSONType == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (!"Feature".equalsIgnoreCase(geoJSONType.toString())) {
            throw new IllegalArgumentException("Unknown type [ " + geoJSONType + " ], expected type [ Feature ]");
        }
        return FeatureFactory.extractFeature(input).build();
    }

    private static Feature.FeatureBuilder extractFeature(Map<String, Object> input) {
        Object geometry = input.get("geometry");
        if (geometry == null) {
            throw new IllegalArgumentException("key: geometry cannot be null");
        }
        if (!(geometry instanceof Map)) {
            throw new IllegalArgumentException("key: geometry is not an instance of type Map but of type [ " + geometry.getClass().getName() + " ]");
        }
        Map<String, Object> geometryMap = GeospatialParser.toStringObjectMap(geometry);
        Feature.FeatureBuilder featureBuilder = new Feature.FeatureBuilder(geometryMap);
        Object properties = input.get("properties");
        if (properties == null) {
            return featureBuilder;
        }
        if (!(properties instanceof Map)) {
            throw new IllegalArgumentException("key: properties is not an instance of type Map but of type [ " + properties.getClass().getName() + " ]");
        }
        return featureBuilder.properties(GeospatialParser.toStringObjectMap(properties));
    }
}

