/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.ParseField;
import org.opensearch.common.Strings;
import org.opensearch.geospatial.GeospatialParser;

public final class UploadGeoJSONRequestContent {
    public static final String GEOSPATIAL_DEFAULT_FIELD_NAME = "location";
    public static final ParseField FIELD_INDEX = new ParseField("index", new String[0]);
    public static final ParseField FIELD_GEOSPATIAL = new ParseField("field", new String[0]);
    public static final ParseField FIELD_GEOSPATIAL_TYPE = new ParseField("type", new String[0]);
    public static final ParseField FIELD_DATA = new ParseField("data", new String[0]);
    public static final String ACCEPTED_INDEX_SUFFIX_PATH = "-map";
    private final String indexName;
    private final String fieldName;
    private final String fieldType;
    private final List<Object> data;

    private UploadGeoJSONRequestContent(String indexName, String fieldName, String fieldType, List<Object> data) {
        this.indexName = indexName;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.data = data;
    }

    public static UploadGeoJSONRequestContent create(Map<String, Object> input) {
        String fieldType;
        Objects.requireNonNull(input, "input cannot be null");
        String index = UploadGeoJSONRequestContent.validateIndexName(input);
        String fieldName = GeospatialParser.extractValueAsString(input, FIELD_GEOSPATIAL.getPreferredName());
        if (!Strings.hasText((String)fieldName)) {
            fieldName = GEOSPATIAL_DEFAULT_FIELD_NAME;
        }
        if (!Strings.hasText((String)(fieldType = GeospatialParser.extractValueAsString(input, FIELD_GEOSPATIAL_TYPE.getPreferredName())))) {
            throw new IllegalArgumentException("field [ " + FIELD_GEOSPATIAL_TYPE.getPreferredName() + " ] cannot be empty");
        }
        Object geoJSONData = Objects.requireNonNull(input.get(FIELD_DATA.getPreferredName()), "field [ " + FIELD_DATA.getPreferredName() + " ] cannot be empty");
        if (!(geoJSONData instanceof List)) {
            throw new IllegalArgumentException(geoJSONData + " is not an instance of List, but of type [ " + geoJSONData.getClass().getName() + " ]");
        }
        return new UploadGeoJSONRequestContent(index, fieldName, fieldType, (List)geoJSONData);
    }

    private static String validateIndexName(Map<String, Object> input) {
        String index = GeospatialParser.extractValueAsString(input, FIELD_INDEX.getPreferredName());
        if (!Strings.hasText((String)index)) {
            throw new IllegalArgumentException(String.format(Locale.getDefault(), "field [ %s ] cannot be empty", FIELD_INDEX.getPreferredName()));
        }
        if (!index.endsWith(ACCEPTED_INDEX_SUFFIX_PATH)) {
            throw new IllegalArgumentException(String.format(Locale.getDefault(), "field [ %s ] should end with suffix %s", FIELD_INDEX.getPreferredName(), ACCEPTED_INDEX_SUFFIX_PATH));
        }
        return index;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<Object> getData() {
        return this.data;
    }

    public String getFieldType() {
        return this.fieldType;
    }
}

