/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class UploadGeoJSONRequest
extends ActionRequest {
    private final RestRequest.Method method;
    private final BytesReference content;

    public UploadGeoJSONRequest(RestRequest.Method method, BytesReference content) {
        this.method = Objects.requireNonNull(method, "method cannot be null");
        this.content = Objects.requireNonNull(content, "content cannot be null");
    }

    public UploadGeoJSONRequest(StreamInput in) throws IOException {
        super(in);
        this.content = Objects.requireNonNull(in.readBytesReference(), "data is missing");
        this.method = Objects.requireNonNull((RestRequest.Method)in.readEnum(RestRequest.Method.class), "RestRequest Method is missing");
    }

    public BytesReference getContent() {
        return this.content;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.content);
        out.writeEnum((Enum)this.method);
    }
}

