/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;

public class IndexManager {
    public static final String FIELD_TYPE_KEY = "type";
    public static final String MAPPING_PROPERTIES_KEY = "properties";
    private static final Logger LOGGER = LogManager.getLogger(IndexManager.class);
    private final IndicesAdminClient client;

    public IndexManager(IndicesAdminClient client) {
        this.client = Objects.requireNonNull(client, "Index admin client cannot be null");
    }

    public void create(String indexName, Map<String, String> fieldNameTypeMap, StepListener<Void> createIndexStep) {
        try (XContentBuilder mapping = this.buildMapping(fieldNameTypeMap);){
            this.createIndex(indexName, mapping, createIndexStep);
        }
        catch (IOException mappingFailedException) {
            createIndexStep.onFailure((Exception)mappingFailedException);
        }
    }

    private XContentBuilder buildMapping(Map<String, String> fieldMap) throws IOException {
        XContentBuilder mapBuilder = XContentFactory.jsonBuilder().startObject().startObject(MAPPING_PROPERTIES_KEY);
        for (Map.Entry<String, String> field : fieldMap.entrySet()) {
            mapBuilder.startObject(field.getKey()).field(FIELD_TYPE_KEY, field.getValue()).endObject();
        }
        mapBuilder.endObject().endObject();
        return mapBuilder;
    }

    private void createIndex(String indexName, XContentBuilder mapping, StepListener<Void> createIndexStep) {
        CreateIndexRequest request = new CreateIndexRequest(indexName).mapping(mapping);
        this.client.create(request, ActionListener.wrap(createIndexResponse -> {
            StringBuilder message = new StringBuilder("Created index: ").append(indexName);
            LOGGER.info(message.toString());
            createIndexStep.onResponse(null);
        }, arg_0 -> createIndexStep.onFailure(arg_0)));
    }
}

