/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;

public class IndexUtils {
    public static final String NONEXISTENT_INDEX_STATUS = "non-existent";
    public static final String ALIAS_EXISTS_NO_INDICES_STATUS = "alias exists, but does not point to any indices";
    public static final String ALIAS_POINTS_TO_MULTIPLE_INDICES_STATUS = "alias exists, but does not point to any indices";
    private static final Logger logger = LogManager.getLogger(IndexUtils.class);
    private Client client;
    private ClientUtil clientUtil;
    private ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public IndexUtils(Client client, ClientUtil clientUtil, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.client = client;
        this.clientUtil = clientUtil;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public String getIndexHealthStatus(String indexOrAliasName) throws IllegalArgumentException {
        if (!this.clusterService.state().getRoutingTable().hasIndex(indexOrAliasName)) {
            if (this.clusterService.state().metadata().hasAlias(indexOrAliasName)) {
                List indexMetaDataList = ((IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(indexOrAliasName)).getIndices();
                if (indexMetaDataList.size() == 0) {
                    return "alias exists, but does not point to any indices";
                }
                if (indexMetaDataList.size() > 1) {
                    throw new IllegalArgumentException("Cannot get health for alias that points to multiple indices");
                }
                indexOrAliasName = ((IndexMetadata)indexMetaDataList.get(0)).getIndex().getName();
            } else {
                return NONEXISTENT_INDEX_STATUS;
            }
        }
        ClusterIndexHealth indexHealth = new ClusterIndexHealth(this.clusterService.state().metadata().index(indexOrAliasName), this.clusterService.state().getRoutingTable().index(indexOrAliasName));
        return indexHealth.getStatus().name().toLowerCase(Locale.ROOT);
    }

    @Deprecated
    public Long getNumberOfDocumentsInIndex(String indexName) {
        if (!this.clusterService.state().getRoutingTable().hasIndex(indexName)) {
            return 0L;
        }
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        Optional response = this.clientUtil.timedRequest(indicesStatsRequest, logger, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).stats(arg_0, arg_1));
        return response.map(r -> r.getIndex((String)indexName).getPrimaries().docs.getCount()).orElse(-1L);
    }

    public boolean checkIndicesBlocked(ClusterState state, ClusterBlockLevel level, String ... indices) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.lenientExpandOpen(), indices);
        return state.blocks().indicesBlockedException(level, concreteIndices) != null;
    }
}

