/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoRequest;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoResponse;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchAnomalyDetectorInfoTransportAction
extends HandledTransportAction<SearchAnomalyDetectorInfoRequest, SearchAnomalyDetectorInfoResponse> {
    private static final Logger LOG = LogManager.getLogger(SearchAnomalyDetectorInfoTransportAction.class);
    private final Client client;
    private final ClusterService clusterService;

    @Inject
    public SearchAnomalyDetectorInfoTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService) {
        super(SearchAnomalyDetectorInfoAction.NAME, transportService, actionFilters, SearchAnomalyDetectorInfoRequest::new);
        this.client = client;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, SearchAnomalyDetectorInfoRequest request, ActionListener<SearchAnomalyDetectorInfoResponse> actionListener) {
        String name = request.getName();
        String rawPath = request.getRawPath();
        final ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonErrorMessages.FAIL_TO_GET_DETECTOR_INFO);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{".opendistro-anomaly-detectors"});
            if (rawPath.endsWith("count")) {
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchRequest.source(searchSourceBuilder);
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        SearchAnomalyDetectorInfoResponse response = new SearchAnomalyDetectorInfoResponse(searchResponse.getHits().getTotalHits().value, false);
                        listener.onResponse((Object)response);
                    }

                    public void onFailure(Exception e) {
                        if (e.getClass() == IndexNotFoundException.class) {
                            SearchAnomalyDetectorInfoResponse response = new SearchAnomalyDetectorInfoResponse(0L, false);
                            listener.onResponse((Object)response);
                        } else {
                            listener.onFailure(e);
                        }
                    }
                });
            } else {
                TermsQueryBuilder query = QueryBuilders.termsQuery((String)"name.keyword", (String[])new String[]{name});
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query);
                searchRequest.source(searchSourceBuilder);
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        boolean nameExists = false;
                        nameExists = searchResponse.getHits().getTotalHits().value > 0L;
                        SearchAnomalyDetectorInfoResponse response = new SearchAnomalyDetectorInfoResponse(0L, nameExists);
                        listener.onResponse((Object)response);
                    }

                    public void onFailure(Exception e) {
                        if (e.getClass() == IndexNotFoundException.class) {
                            SearchAnomalyDetectorInfoResponse response = new SearchAnomalyDetectorInfoResponse(0L, false);
                            listener.onResponse((Object)response);
                        } else {
                            listener.onFailure(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }
}

