/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.caching.CacheProvider;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.ml.EntityColdStarter;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.transport.DeleteModelAction;
import org.opensearch.ad.transport.DeleteModelNodeRequest;
import org.opensearch.ad.transport.DeleteModelNodeResponse;
import org.opensearch.ad.transport.DeleteModelRequest;
import org.opensearch.ad.transport.DeleteModelResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class DeleteModelTransportAction
extends TransportNodesAction<DeleteModelRequest, DeleteModelResponse, DeleteModelNodeRequest, DeleteModelNodeResponse> {
    private static final Logger LOG = LogManager.getLogger(DeleteModelTransportAction.class);
    private NodeStateManager nodeStateManager;
    private ModelManager modelManager;
    private FeatureManager featureManager;
    private CacheProvider cache;
    private ADTaskCacheManager adTaskCacheManager;
    private EntityColdStarter coldStarter;

    @Inject
    public DeleteModelTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeStateManager nodeStateManager, ModelManager modelManager, FeatureManager featureManager, CacheProvider cache, ADTaskCacheManager adTaskCacheManager, EntityColdStarter coldStarter) {
        super(DeleteModelAction.NAME, threadPool, clusterService, transportService, actionFilters, DeleteModelRequest::new, DeleteModelNodeRequest::new, "management", DeleteModelNodeResponse.class);
        this.nodeStateManager = nodeStateManager;
        this.modelManager = modelManager;
        this.featureManager = featureManager;
        this.cache = cache;
        this.adTaskCacheManager = adTaskCacheManager;
        this.coldStarter = coldStarter;
    }

    protected DeleteModelResponse newResponse(DeleteModelRequest request, List<DeleteModelNodeResponse> responses, List<FailedNodeException> failures) {
        return new DeleteModelResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected DeleteModelNodeRequest newNodeRequest(DeleteModelRequest request) {
        return new DeleteModelNodeRequest(request);
    }

    protected DeleteModelNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new DeleteModelNodeResponse(in);
    }

    protected DeleteModelNodeResponse nodeOperation(DeleteModelNodeRequest request) {
        String adID = request.getAdID();
        LOG.info("Delete model for {}", (Object)adID);
        this.modelManager.clear(adID, (ActionListener<Void>)ActionListener.wrap(r -> LOG.info("Deleted model for [{}] with response [{}] ", (Object)adID, r), e -> LOG.error("Fail to delete model for " + adID, (Throwable)e)));
        this.featureManager.clear(adID);
        this.nodeStateManager.clear(adID);
        this.cache.get().clear(adID);
        this.coldStarter.clear(adID);
        this.adTaskCacheManager.removeRealtimeTaskCache(adID);
        LOG.info("Finished deleting {}", (Object)adID);
        return new DeleteModelNodeResponse(this.clusterService.localNode());
    }
}

