/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.ad.DetectorModelSize;
import org.opensearch.ad.MemoryTracker;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.ml.CheckpointDao;
import org.opensearch.ad.ml.EntityColdStarter;
import org.opensearch.ad.ml.EntityModel;
import org.opensearch.ad.ml.ModelState;
import org.opensearch.ad.ml.SingleStreamModelIdMapper;
import org.opensearch.ad.ml.TRCFMemoryAwareConcurrentHashmap;
import org.opensearch.ad.ml.ThresholdingModel;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.util.DateUtils;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;

public class ModelManager
implements DetectorModelSize {
    protected static final String ENTITY_SAMPLE = "sp";
    protected static final String ENTITY_RCF = "rcf";
    protected static final String ENTITY_THRESHOLD = "th";
    private static final Logger logger = LogManager.getLogger(ModelManager.class);
    private TRCFMemoryAwareConcurrentHashmap<String> forests;
    private Map<String, ModelState<ThresholdingModel>> thresholds;
    private final int rcfNumTrees;
    private final int rcfNumSamplesInTree;
    private final double rcfTimeDecay;
    private final int rcfNumMinSamples;
    private final double thresholdMinPvalue;
    private final int minPreviewSize;
    private final Duration modelTtl;
    private Duration checkpointInterval;
    private final CheckpointDao checkpointDao;
    private final Clock clock;
    public FeatureManager featureManager;
    private EntityColdStarter entityColdStarter;
    private MemoryTracker memoryTracker;
    private final double initialAcceptFraction;

    public ModelManager(CheckpointDao checkpointDao, Clock clock, int rcfNumTrees, int rcfNumSamplesInTree, double rcfTimeDecay, int rcfNumMinSamples, double thresholdMinPvalue, int minPreviewSize, Duration modelTtl, Setting<TimeValue> checkpointIntervalSetting, EntityColdStarter entityColdStarter, FeatureManager featureManager, MemoryTracker memoryTracker, Settings settings, ClusterService clusterService) {
        this.checkpointDao = checkpointDao;
        this.clock = clock;
        this.rcfNumTrees = rcfNumTrees;
        this.rcfNumSamplesInTree = rcfNumSamplesInTree;
        this.rcfTimeDecay = rcfTimeDecay;
        this.rcfNumMinSamples = rcfNumMinSamples;
        this.thresholdMinPvalue = thresholdMinPvalue;
        this.minPreviewSize = minPreviewSize;
        this.modelTtl = modelTtl;
        this.checkpointInterval = DateUtils.toDuration((TimeValue)checkpointIntervalSetting.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(checkpointIntervalSetting, it -> {
            this.checkpointInterval = DateUtils.toDuration(it);
        });
        this.forests = new TRCFMemoryAwareConcurrentHashmap(memoryTracker);
        this.thresholds = new ConcurrentHashMap<String, ModelState<ThresholdingModel>>();
        this.entityColdStarter = entityColdStarter;
        this.featureManager = featureManager;
        this.memoryTracker = memoryTracker;
        this.initialAcceptFraction = (double)rcfNumMinSamples * 1.0 / (double)rcfNumSamplesInTree;
    }

    public void getTRcfResult(String detectorId, String modelId, double[] point, ActionListener<ThresholdingResult> listener) {
        if (this.forests.containsKey(modelId)) {
            this.getTRcfResult((ModelState)this.forests.get(modelId), point, listener);
        } else {
            this.checkpointDao.getTRCFModel(modelId, (ActionListener<Optional<ThresholdedRandomCutForest>>)ActionListener.wrap(restoredModel -> this.processRestoredTRcf((Optional<ThresholdedRandomCutForest>)restoredModel, modelId, detectorId, point, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void getTRcfResult(ModelState<ThresholdedRandomCutForest> modelState, double[] point, ActionListener<ThresholdingResult> listener) {
        modelState.setLastUsedTime(this.clock.instant());
        ThresholdedRandomCutForest trcf = modelState.getModel();
        try {
            AnomalyDescriptor result = trcf.process(point, 0L);
            double[] attribution = this.normalizeAttribution(trcf.getForest(), result.getRelevantAttribution());
            listener.onResponse((Object)new ThresholdingResult(result.getAnomalyGrade(), result.getDataConfidence(), result.getRCFScore(), result.getTotalUpdates(), result.getRelativeIndex(), attribution, result.getPastValues(), result.getExpectedValuesList(), result.getLikelihoodOfValues(), result.getThreshold(), result.getNumberOfTrees()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public double[] normalizeAttribution(RandomCutForest forest, double[] rawAttribution) {
        double sum;
        if (forest == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Empty forest", new Object[0]));
        }
        double[] attribution = this.createEmptyAttribution(forest);
        if (rawAttribution != null && rawAttribution.length > 0 && (sum = Arrays.stream(rawAttribution).sum()) > 0.0) {
            if (rawAttribution.length != attribution.length) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Unexpected attribution array length: expected %d but is %d", attribution.length, rawAttribution.length));
            }
            int numFeatures = rawAttribution.length;
            attribution = new double[numFeatures];
            for (int i = 0; i < numFeatures; ++i) {
                attribution[i] = rawAttribution[i] / sum;
            }
        }
        return attribution;
    }

    private double[] createEmptyAttribution(RandomCutForest forest) {
        int shingleSize = forest.getShingleSize();
        if (shingleSize <= 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "zero shingle size", new Object[0]));
        }
        int baseDimensions = forest.getDimensions() / shingleSize;
        return new double[baseDimensions];
    }

    private Optional<ModelState<ThresholdedRandomCutForest>> restoreModelState(Optional<ThresholdedRandomCutForest> rcfModel, String modelId, String detectorId) {
        if (!rcfModel.isPresent()) {
            return Optional.empty();
        }
        return rcfModel.filter(rcf -> this.memoryTracker.isHostingAllowed(detectorId, (ThresholdedRandomCutForest)rcf)).map(rcf -> ModelState.createSingleEntityModelState(rcf, modelId, detectorId, ModelType.RCF.getName(), this.clock));
    }

    private void processRestoredTRcf(Optional<ThresholdedRandomCutForest> rcfModel, String modelId, String detectorId, double[] point, ActionListener<ThresholdingResult> listener) {
        Optional<ModelState<ThresholdedRandomCutForest>> model = this.restoreModelState(rcfModel, modelId, detectorId);
        if (!model.isPresent()) {
            throw new ResourceNotFoundException(detectorId, "No checkpoints found for model id " + modelId);
        }
        this.forests.put(modelId, model.get());
        this.getTRcfResult(model.get(), point, listener);
    }

    private void processRestoredCheckpoint(Optional<ThresholdedRandomCutForest> checkpointModel, String modelId, String detectorId, ActionListener<Long> listener) {
        logger.info("Restoring checkpoint for {}", (Object)modelId);
        Optional<ModelState<ThresholdedRandomCutForest>> model = this.restoreModelState(checkpointModel, modelId, detectorId);
        if (model.isPresent()) {
            this.forests.put(modelId, model.get());
            if (model.get().getModel() != null && model.get().getModel().getForest() != null) {
                listener.onResponse((Object)model.get().getModel().getForest().getTotalUpdates());
            }
        } else {
            listener.onFailure((Exception)new ResourceNotFoundException(detectorId, "No checkpoints found for model id " + modelId));
        }
    }

    public void getThresholdingResult(String detectorId, String modelId, double score, ActionListener<ThresholdingResult> listener) {
        if (this.thresholds.containsKey(modelId)) {
            this.getThresholdingResult(this.thresholds.get(modelId), score, listener);
        } else {
            this.checkpointDao.getThresholdModel(modelId, (ActionListener<Optional<ThresholdingModel>>)ActionListener.wrap(model -> this.processThresholdCheckpoint((Optional<ThresholdingModel>)model, modelId, detectorId, score, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void getThresholdingResult(ModelState<ThresholdingModel> modelState, double score, ActionListener<ThresholdingResult> listener) {
        ThresholdingModel threshold = modelState.getModel();
        double grade = threshold.grade(score);
        double confidence = threshold.confidence();
        if (score > 0.0) {
            threshold.update(score);
        }
        modelState.setLastUsedTime(this.clock.instant());
        listener.onResponse((Object)new ThresholdingResult(grade, confidence, score));
    }

    private void processThresholdCheckpoint(Optional<ThresholdingModel> thresholdModel, String modelId, String detectorId, double score, ActionListener<ThresholdingResult> listener) {
        Optional<ModelState> model = thresholdModel.map(threshold -> ModelState.createSingleEntityModelState(threshold, modelId, detectorId, ModelType.THRESHOLD.getName(), this.clock));
        if (!model.isPresent()) {
            throw new ResourceNotFoundException(detectorId, "No checkpoints found for model id " + modelId);
        }
        this.thresholds.put(modelId, model.get());
        this.getThresholdingResult(model.get(), score, listener);
    }

    public Set<String> getAllModelIds() {
        return Stream.of(this.forests.keySet(), this.thresholds.keySet()).flatMap(set -> set.stream()).collect(Collectors.toSet());
    }

    public List<ModelState<?>> getAllModels() {
        return Stream.concat(this.forests.values().stream(), this.thresholds.values().stream()).collect(Collectors.toList());
    }

    public void stopModel(String detectorId, String modelId, ActionListener<Void> listener) {
        logger.info(String.format(Locale.ROOT, "Stopping detector %s model %s", detectorId, modelId));
        this.stopModel(this.forests, modelId, (ActionListener<Void>)ActionListener.wrap(r -> this.stopModel(this.thresholds, modelId, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private <T> void stopModel(Map<String, ModelState<T>> models, String modelId, ActionListener<Void> listener) {
        Instant now = this.clock.instant();
        Optional<ModelState> modelState = Optional.ofNullable(models.remove(modelId)).filter(model -> model.getLastCheckpointTime().plus(this.checkpointInterval).isBefore(now));
        if (modelState.isPresent()) {
            Object model2 = modelState.get().getModel();
            if (model2 instanceof ThresholdedRandomCutForest) {
                this.checkpointDao.putTRCFCheckpoint(modelId, (ThresholdedRandomCutForest)model2, (ActionListener<Void>)ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
            } else if (model2 instanceof ThresholdingModel) {
                this.checkpointDao.putThresholdCheckpoint(modelId, (ThresholdingModel)model2, (ActionListener<Void>)ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
            } else {
                listener.onFailure((Exception)new IllegalArgumentException("Unexpected model type"));
            }
        } else {
            listener.onResponse(null);
        }
    }

    public void clear(String detectorId, ActionListener<Void> listener) {
        this.clearModels(detectorId, this.forests, (ActionListener<Void>)ActionListener.wrap(r -> this.clearModels(detectorId, this.thresholds, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void clearModels(String detectorId, Map<String, ?> models, ActionListener<Void> listener) {
        Iterator<String> id = models.keySet().iterator();
        this.clearModelForIterator(detectorId, models, id, listener);
    }

    private void clearModelForIterator(String detectorId, Map<String, ?> models, Iterator<String> idIter, ActionListener<Void> listener) {
        if (idIter.hasNext()) {
            String modelId = idIter.next();
            if (SingleStreamModelIdMapper.getDetectorIdForModelId(modelId).equals(detectorId)) {
                models.remove(modelId);
                this.checkpointDao.deleteModelCheckpoint(modelId, (ActionListener<Void>)ActionListener.wrap(r -> this.clearModelForIterator(detectorId, models, idIter, listener), arg_0 -> listener.onFailure(arg_0)));
            } else {
                this.clearModelForIterator(detectorId, models, idIter, listener);
            }
        } else {
            listener.onResponse(null);
        }
    }

    public void trainModel(AnomalyDetector anomalyDetector, double[][] dataPoints, ActionListener<Void> listener) {
        if (dataPoints.length == 0 || dataPoints[0].length == 0) {
            listener.onFailure((Exception)new IllegalArgumentException("Data points must not be empty."));
        } else {
            int rcfNumFeatures = dataPoints[0].length;
            try {
                this.trainModelForStep(anomalyDetector, dataPoints, rcfNumFeatures, 0, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    private void trainModelForStep(AnomalyDetector detector, double[][] dataPoints, int rcfNumFeatures, int step, ActionListener<Void> listener) {
        ThresholdedRandomCutForest trcf = ThresholdedRandomCutForest.builder().dimensions(rcfNumFeatures).sampleSize(this.rcfNumSamplesInTree).numberOfTrees(this.rcfNumTrees).timeDecay(this.rcfTimeDecay).outputAfter(this.rcfNumMinSamples).initialAcceptFraction(this.initialAcceptFraction).parallelExecutionEnabled(false).compact(true).precision(Precision.FLOAT_32).boundingBoxCacheFraction(0.0).shingleSize(detector.getShingleSize().intValue()).anomalyRate(1.0 - this.thresholdMinPvalue).build();
        Arrays.stream(dataPoints).forEach(s -> trcf.process(s, 0L));
        String modelId = SingleStreamModelIdMapper.getRcfModelId(detector.getDetectorId(), step);
        this.checkpointDao.putTRCFCheckpoint(modelId, trcf, (ActionListener<Void>)ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }

    public void maintenance(ActionListener<Void> listener) {
        this.maintenanceForIterator(this.forests, this.forests.entrySet().iterator(), (ActionListener<Void>)ActionListener.wrap(r -> this.maintenanceForIterator(this.thresholds, this.thresholds.entrySet().iterator(), listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private <T> void maintenanceForIterator(Map<String, ModelState<T>> models, Iterator<Map.Entry<String, ModelState<T>>> iter, ActionListener<Void> listener) {
        if (iter.hasNext()) {
            Map.Entry<String, ModelState<T>> modelEntry = iter.next();
            String modelId = modelEntry.getKey();
            ModelState modelState = modelEntry.getValue();
            Instant now = this.clock.instant();
            if (modelState.expired(this.modelTtl)) {
                models.remove(modelId);
            }
            if (modelState.getLastCheckpointTime().plus(this.checkpointInterval).isBefore(now)) {
                ActionListener checkpointListener = ActionListener.wrap(r -> {
                    modelState.setLastCheckpointTime(now);
                    this.maintenanceForIterator(models, iter, listener);
                }, e -> {
                    logger.warn("Failed to finish maintenance for model id " + modelId, (Throwable)e);
                    this.maintenanceForIterator(models, iter, listener);
                });
                T model = modelState.getModel();
                if (model instanceof ThresholdedRandomCutForest) {
                    this.checkpointDao.putTRCFCheckpoint(modelId, (ThresholdedRandomCutForest)model, (ActionListener<Void>)checkpointListener);
                } else if (model instanceof ThresholdingModel) {
                    this.checkpointDao.putThresholdCheckpoint(modelId, (ThresholdingModel)model, (ActionListener<Void>)checkpointListener);
                } else {
                    checkpointListener.onFailure((Exception)new IllegalArgumentException("Unexpected model type"));
                }
            } else {
                this.maintenanceForIterator(models, iter, listener);
            }
        } else {
            listener.onResponse(null);
        }
    }

    public List<ThresholdingResult> getPreviewResults(double[][] dataPoints, int shingleSize) {
        if (dataPoints.length < this.minPreviewSize) {
            throw new IllegalArgumentException("Insufficient data for preview results. Minimum required: " + this.minPreviewSize);
        }
        int rcfNumFeatures = dataPoints[0].length;
        ThresholdedRandomCutForest trcf = ThresholdedRandomCutForest.builder().randomSeed(0L).dimensions(rcfNumFeatures).sampleSize(this.rcfNumSamplesInTree).numberOfTrees(this.rcfNumTrees).timeDecay(this.rcfTimeDecay).outputAfter(this.rcfNumMinSamples).initialAcceptFraction(this.initialAcceptFraction).parallelExecutionEnabled(false).compact(true).precision(Precision.FLOAT_32).boundingBoxCacheFraction(1.0).shingleSize(shingleSize).anomalyRate(1.0 - this.thresholdMinPvalue).build();
        return Arrays.stream(dataPoints).map(point -> {
            AnomalyDescriptor descriptor = trcf.process(point, 0L);
            return new ThresholdingResult(descriptor.getAnomalyGrade(), descriptor.getDataConfidence(), descriptor.getRCFScore(), descriptor.getTotalUpdates(), descriptor.getRelativeIndex(), this.normalizeAttribution(trcf.getForest(), descriptor.getRelevantAttribution()), descriptor.getPastValues(), descriptor.getExpectedValuesList(), descriptor.getLikelihoodOfValues(), descriptor.getThreshold(), this.rcfNumTrees);
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, Long> getModelSize(String detectorId) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        this.forests.entrySet().stream().filter(entry -> SingleStreamModelIdMapper.getDetectorIdForModelId((String)entry.getKey()).equals(detectorId)).forEach(entry -> res.put((String)entry.getKey(), this.memoryTracker.estimateTRCFModelSize((ThresholdedRandomCutForest)((ModelState)entry.getValue()).getModel())));
        this.thresholds.entrySet().stream().filter(entry -> SingleStreamModelIdMapper.getDetectorIdForModelId((String)entry.getKey()).equals(detectorId)).forEach(entry -> res.put((String)entry.getKey(), Long.valueOf(this.memoryTracker.getThresholdModelBytes())));
        return res;
    }

    public void getTotalUpdates(String modelId, String detectorId, ActionListener<Long> listener) {
        ModelState model = (ModelState)this.forests.get(modelId);
        if (model != null) {
            if (model.getModel() != null && ((ThresholdedRandomCutForest)model.getModel()).getForest() != null) {
                listener.onResponse((Object)((ThresholdedRandomCutForest)model.getModel()).getForest().getTotalUpdates());
            } else {
                listener.onResponse((Object)0L);
            }
        } else {
            this.checkpointDao.getTRCFModel(modelId, (ActionListener<Optional<ThresholdedRandomCutForest>>)ActionListener.wrap(checkpoint -> this.processRestoredCheckpoint((Optional<ThresholdedRandomCutForest>)checkpoint, modelId, detectorId, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public ThresholdingResult getAnomalyResultForEntity(double[] datapoint, ModelState<EntityModel> modelState, String modelId, Entity entity, int shingleSize) {
        ThresholdingResult result = new ThresholdingResult(0.0, 0.0, 0.0);
        if (modelState != null) {
            EntityModel entityModel = modelState.getModel();
            if (entityModel == null) {
                entityModel = new EntityModel(entity, new ArrayDeque<double[]>(), null);
                modelState.setModel(entityModel);
            }
            if (!entityModel.getTrcf().isPresent()) {
                this.entityColdStarter.trainModelFromExistingSamples(modelState, shingleSize);
            }
            if (entityModel.getTrcf().isPresent()) {
                result = this.score(datapoint, modelId, modelState);
            } else {
                entityModel.addSample(datapoint);
            }
        }
        return result;
    }

    public ThresholdingResult score(double[] feature, String modelId, ModelState<EntityModel> modelState) {
        ThresholdingResult result = new ThresholdingResult(0.0, 0.0, 0.0);
        EntityModel model = modelState.getModel();
        try {
            if (model != null && model.getTrcf().isPresent()) {
                ThresholdedRandomCutForest trcf = model.getTrcf().get();
                Optional.ofNullable(model.getSamples()).ifPresent(q -> {
                    q.stream().forEach(s -> trcf.process(s, 0L));
                    q.clear();
                });
                result = this.toResult(trcf.getForest(), trcf.process(feature, 0L));
            }
        }
        catch (Exception e) {
            logger.error((Message)new ParameterizedMessage("Fail to score for [{}]: model Id [{}], feature [{}]", new Object[]{modelState.getModel().getEntity(), modelId, Arrays.toString(feature)}), (Throwable)e);
            throw e;
        }
        finally {
            modelState.setLastUsedTime(this.clock.instant());
        }
        return result;
    }

    public ModelState<EntityModel> processEntityCheckpoint(Optional<Map.Entry<EntityModel, Instant>> checkpoint, Entity entity, String modelId, String detectorId, int shingleSize) {
        EntityModel model;
        ModelState<EntityModel> modelState = new ModelState<EntityModel>(new EntityModel(entity, new ArrayDeque<double[]>(), null), modelId, detectorId, ModelType.ENTITY.getName(), this.clock, 0.0f);
        if (checkpoint.isPresent()) {
            Map.Entry<EntityModel, Instant> modelToTime = checkpoint.get();
            EntityModel restoredModel = modelToTime.getKey();
            this.combineSamples(modelState.getModel(), restoredModel);
            modelState.setModel(restoredModel);
            modelState.setLastCheckpointTime(modelToTime.getValue());
        }
        if ((model = modelState.getModel()) == null) {
            model = new EntityModel(null, new ArrayDeque<double[]>(), null);
            modelState.setModel(model);
        }
        if (!model.getTrcf().isPresent() && model.getSamples() != null && model.getSamples().size() >= this.rcfNumMinSamples) {
            this.entityColdStarter.trainModelFromExistingSamples(modelState, shingleSize);
        }
        return modelState;
    }

    private void combineSamples(EntityModel fromModel, EntityModel toModel) {
        Queue<double[]> samples = fromModel.getSamples();
        while (samples.peek() != null) {
            toModel.addSample(samples.poll());
        }
    }

    private ThresholdingResult toResult(RandomCutForest rcf, AnomalyDescriptor anomalyDescriptor) {
        return new ThresholdingResult(anomalyDescriptor.getAnomalyGrade(), anomalyDescriptor.getDataConfidence(), anomalyDescriptor.getRCFScore(), anomalyDescriptor.getTotalUpdates(), anomalyDescriptor.getRelativeIndex(), this.normalizeAttribution(rcf, anomalyDescriptor.getRelevantAttribution()), anomalyDescriptor.getPastValues(), anomalyDescriptor.getExpectedValuesList(), anomalyDescriptor.getLikelihoodOfValues(), anomalyDescriptor.getThreshold(), this.rcfNumTrees);
    }

    public static enum ModelType {
        RCF("rcf"),
        THRESHOLD("threshold"),
        ENTITY("entity");

        private String name;

        private ModelType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

