/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.common.exception.InternalFailure;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.ADTaskState;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.DetectorProfileName;
import org.opensearch.ad.model.FeatureData;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.rest.handler.AnomalyDetectorFunction;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.AnomalyResultAction;
import org.opensearch.ad.transport.AnomalyResultRequest;
import org.opensearch.ad.transport.AnomalyResultResponse;
import org.opensearch.ad.transport.ProfileAction;
import org.opensearch.ad.transport.ProfileRequest;
import org.opensearch.ad.transport.handler.AnomalyIndexHandler;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.InjectSecurity;
import org.opensearch.commons.authuser.User;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.threadpool.ThreadPool;

public class AnomalyDetectorJobRunner
implements ScheduledJobRunner {
    private static final Logger log = LogManager.getLogger(AnomalyDetectorJobRunner.class);
    private static AnomalyDetectorJobRunner INSTANCE;
    private Settings settings;
    private int maxRetryForEndRunException;
    private Client client;
    private ThreadPool threadPool;
    private AnomalyIndexHandler<AnomalyResult> anomalyResultHandler;
    private ConcurrentHashMap<String, Integer> detectorEndRunExceptionCount = new ConcurrentHashMap();
    private AnomalyDetectionIndices anomalyDetectionIndices;
    private DiscoveryNodeFilterer nodeFilter;
    private ADTaskManager adTaskManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnomalyDetectorJobRunner getJobRunnerInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<AnomalyDetectorJobRunner> clazz = AnomalyDetectorJobRunner.class;
        synchronized (AnomalyDetectorJobRunner.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new AnomalyDetectorJobRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private AnomalyDetectorJobRunner() {
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setAnomalyResultHandler(AnomalyIndexHandler<AnomalyResult> anomalyResultHandler) {
        this.anomalyResultHandler = anomalyResultHandler;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.maxRetryForEndRunException = (Integer)AnomalyDetectorSettings.MAX_RETRY_FOR_END_RUN_EXCEPTION.get(settings);
    }

    public void setAdTaskManager(ADTaskManager adTaskManager) {
        this.adTaskManager = adTaskManager;
    }

    public void setAnomalyDetectionIndices(AnomalyDetectionIndices anomalyDetectionIndices) {
        this.anomalyDetectionIndices = anomalyDetectionIndices;
    }

    public void setNodeFilter(DiscoveryNodeFilterer nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public void runJob(ScheduledJobParameter scheduledJobParameter, JobExecutionContext context) {
        String detectorId = scheduledJobParameter.getName();
        log.info("Start to run AD job {}", (Object)detectorId);
        this.adTaskManager.refreshRealtimeJobRunTime(detectorId);
        if (!(scheduledJobParameter instanceof AnomalyDetectorJob)) {
            throw new IllegalArgumentException("Job parameter is not instance of AnomalyDetectorJob, type: " + scheduledJobParameter.getClass().getCanonicalName());
        }
        AnomalyDetectorJob jobParameter = (AnomalyDetectorJob)scheduledJobParameter;
        Instant executionStartTime = Instant.now();
        IntervalSchedule schedule = (IntervalSchedule)jobParameter.getSchedule();
        Instant detectionStartTime = executionStartTime.minus(schedule.getInterval(), schedule.getUnit());
        LockService lockService = context.getLockService();
        Runnable runnable = () -> {
            if (jobParameter.getLockDurationSeconds() != null) {
                lockService.acquireLock((ScheduledJobParameter)jobParameter, context, ActionListener.wrap(lock -> this.runAdJob(jobParameter, lockService, (LockModel)lock, detectionStartTime, executionStartTime), exception -> {
                    this.indexAnomalyResultException(jobParameter, lockService, null, detectionStartTime, executionStartTime, (Exception)exception, false);
                    throw new IllegalStateException("Failed to acquire lock for AD job: " + detectorId);
                }));
            } else {
                log.warn("Can't get lock for AD job: " + detectorId);
            }
        };
        ExecutorService executor = this.threadPool.executor("ad-threadpool");
        executor.submit(runnable);
    }

    protected void runAdJob(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime) {
        List roles;
        String user;
        String detectorId = jobParameter.getName();
        if (lock == null) {
            this.indexAnomalyResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, "Can't run AD job due to null lock", false);
            return;
        }
        this.anomalyDetectionIndices.update();
        if (jobParameter.getUser() == null) {
            user = "";
            roles = this.settings.getAsList("", (List)ImmutableList.of((Object)"all_access", (Object)"AmazonES_all_access"));
        } else {
            user = jobParameter.getUser().getName();
            roles = jobParameter.getUser().getRoles();
        }
        String resultIndex = jobParameter.getResultIndex();
        if (resultIndex == null) {
            this.runAnomalyDetectionJob(jobParameter, lockService, lock, detectionStartTime, executionStartTime, detectorId, user, roles);
            return;
        }
        ActionListener listener = ActionListener.wrap(r -> log.debug("Custom index is valid"), e -> {
            EndRunException exception = new EndRunException(detectorId, e.getMessage(), true);
            this.handleAdException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, exception);
        });
        this.anomalyDetectionIndices.validateCustomIndexForBackendJob(resultIndex, detectorId, user, roles, () -> {
            listener.onResponse((Object)true);
            this.runAnomalyDetectionJob(jobParameter, lockService, lock, detectionStartTime, executionStartTime, detectorId, user, roles);
        }, listener);
    }

    private void runAnomalyDetectionJob(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, String detectorId, String user, List<String> roles) {
        try (InjectSecurity injectSecurity = new InjectSecurity(detectorId, this.settings, this.client.threadPool().getThreadContext());){
            injectSecurity.inject(user, roles);
            AnomalyResultRequest request = new AnomalyResultRequest(detectorId, detectionStartTime.toEpochMilli(), executionStartTime.toEpochMilli());
            this.client.execute((ActionType)AnomalyResultAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> this.indexAnomalyResult(jobParameter, lockService, lock, detectionStartTime, executionStartTime, (AnomalyResultResponse)((Object)response)), exception -> this.handleAdException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, (Exception)exception)));
        }
        catch (Exception e) {
            this.indexAnomalyResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, e, true);
            log.error("Failed to execute AD job " + detectorId, (Throwable)e);
        }
    }

    protected void handleAdException(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, Exception exception) {
        String detectorId = jobParameter.getName();
        if (exception instanceof EndRunException) {
            log.error("EndRunException happened when executing anomaly result action for " + detectorId, (Throwable)exception);
            if (((EndRunException)exception).isEndNow()) {
                log.info("JobRunner will stop AD job due to EndRunException for {}", (Object)detectorId);
                this.stopAdJobForEndRunException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, (EndRunException)exception);
            } else {
                this.detectorEndRunExceptionCount.compute(detectorId, (k, v) -> {
                    if (v == null) {
                        return 1;
                    }
                    return v + 1;
                });
                log.info("EndRunException happened for {}", (Object)detectorId);
                if (this.detectorEndRunExceptionCount.get(detectorId) > this.maxRetryForEndRunException) {
                    log.info("JobRunner will stop AD job due to EndRunException retry exceeds upper limit {} for {}", (Object)this.maxRetryForEndRunException, (Object)detectorId);
                    this.stopAdJobForEndRunException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, (EndRunException)exception);
                    return;
                }
                this.indexAnomalyResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, exception.getMessage(), true);
            }
        } else {
            this.detectorEndRunExceptionCount.remove(detectorId);
            if (exception instanceof InternalFailure) {
                log.error("InternalFailure happened when executing anomaly result action for " + detectorId, (Throwable)exception);
            } else {
                log.error("Failed to execute anomaly result action for " + detectorId, (Throwable)exception);
            }
            this.indexAnomalyResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, exception, true);
        }
    }

    private void stopAdJobForEndRunException(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, EndRunException exception) {
        String detectorId = jobParameter.getName();
        this.detectorEndRunExceptionCount.remove(detectorId);
        String errorPrefix = exception.isEndNow() ? "Stopped detector: " : "Stopped detector as job failed consecutively for more than " + this.maxRetryForEndRunException + " times: ";
        String error = errorPrefix + exception.getMessage();
        this.stopAdJob(detectorId, () -> this.indexAnomalyResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, error, true, ADTaskState.STOPPED.name()));
    }

    private void stopAdJob(String detectorId, AnomalyDetectorFunction function) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs").id(detectorId);
        ActionListener listener = ActionListener.wrap(response -> {
            if (response.isExists()) {
                try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    AnomalyDetectorJob job = AnomalyDetectorJob.parse(parser);
                    if (job.isEnabled()) {
                        AnomalyDetectorJob newJob = new AnomalyDetectorJob(job.getName(), job.getSchedule(), job.getWindowDelay(), false, job.getEnabledTime(), Instant.now(), Instant.now(), job.getLockDurationSeconds(), job.getUser(), job.getResultIndex());
                        IndexRequest indexRequest = ((IndexRequest)new IndexRequest(".opendistro-anomaly-detector-jobs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(newJob.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE)).id(detectorId);
                        this.client.index(indexRequest, ActionListener.wrap(indexResponse -> {
                            if (indexResponse != null && (indexResponse.getResult() == DocWriteResponse.Result.CREATED || indexResponse.getResult() == DocWriteResponse.Result.UPDATED)) {
                                log.info("AD Job was disabled by JobRunner for " + detectorId);
                            } else {
                                log.warn("Failed to disable AD job for " + detectorId);
                            }
                        }, exception -> log.error("JobRunner failed to update AD job as disabled for " + detectorId, (Throwable)exception)));
                    } else {
                        log.info("AD Job was disabled for " + detectorId);
                    }
                }
                catch (IOException e) {
                    log.error("JobRunner failed to stop detector job " + detectorId, (Throwable)e);
                }
            } else {
                log.info("AD Job was not found for " + detectorId);
            }
        }, exception -> log.error("JobRunner failed to get detector job " + detectorId, (Throwable)exception));
        this.client.get(getRequest, ActionListener.runAfter((ActionListener)listener, () -> function.execute()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexAnomalyResult(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, AnomalyResultResponse response) {
        String detectorId = jobParameter.getName();
        this.detectorEndRunExceptionCount.remove(detectorId);
        try {
            if ((response.getAnomalyScore() <= 0.0 || Double.isNaN(response.getAnomalyScore())) && response.getError() == null) {
                this.updateRealtimeTask(response, detectorId);
                return;
            }
            IntervalTimeConfiguration windowDelay = (IntervalTimeConfiguration)jobParameter.getWindowDelay();
            Instant dataStartTime = detectionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            Instant dataEndTime = executionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            User user = jobParameter.getUser();
            if (response.getError() != null) {
                log.info("Anomaly result action run successfully for {} with error {}", (Object)detectorId, (Object)response.getError());
            }
            AnomalyResult anomalyResult = response.toAnomalyResult(detectorId, dataStartTime, dataEndTime, executionStartTime, Instant.now(), this.anomalyDetectionIndices.getSchemaVersion(ADIndex.RESULT), user, response.getError());
            String resultIndex = jobParameter.getResultIndex();
            this.anomalyResultHandler.index(anomalyResult, detectorId, resultIndex);
            this.updateRealtimeTask(response, detectorId);
        }
        catch (EndRunException e) {
            this.handleAdException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, e);
        }
        catch (Exception e) {
            log.error("Failed to index anomaly result for " + detectorId, (Throwable)e);
        }
        finally {
            this.releaseLock(jobParameter, lockService, lock);
        }
    }

    private void updateRealtimeTask(AnomalyResultResponse response, String detectorId) {
        if (response.isHCDetector() != null && response.isHCDetector().booleanValue() && !this.adTaskManager.skipUpdateHCRealtimeTask(detectorId, response.getError())) {
            DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
            HashSet<DetectorProfileName> profiles = new HashSet<DetectorProfileName>();
            profiles.add(DetectorProfileName.INIT_PROGRESS);
            ProfileRequest profileRequest = new ProfileRequest(detectorId, profiles, true, dataNodes);
            this.client.execute((ActionType)ProfileAction.INSTANCE, (ActionRequest)profileRequest, ActionListener.wrap(r -> {
                log.debug("Update latest realtime task for HC detector {}, total updates: {}", (Object)detectorId, (Object)r.getTotalUpdates());
                this.updateLatestRealtimeTask(detectorId, null, r.getTotalUpdates(), response.getDetectorIntervalInMinutes(), response.getError());
            }, e -> log.error("Failed to update latest realtime task for " + detectorId, (Throwable)e)));
        } else {
            log.debug("Update latest realtime task for SINGLE detector {}, total updates: {}", (Object)detectorId, (Object)response.getRcfTotalUpdates());
            this.updateLatestRealtimeTask(detectorId, null, response.getRcfTotalUpdates(), response.getDetectorIntervalInMinutes(), response.getError());
        }
    }

    private void indexAnomalyResultException(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, Exception exception, boolean releaseLock) {
        try {
            String errorMessage = exception instanceof AnomalyDetectionException ? exception.getMessage() : Throwables.getStackTraceAsString((Throwable)exception);
            this.indexAnomalyResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, errorMessage, releaseLock);
        }
        catch (Exception e) {
            log.error("Failed to index anomaly result for " + jobParameter.getName(), (Throwable)e);
        }
    }

    private void indexAnomalyResultException(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, String errorMessage, boolean releaseLock) {
        this.indexAnomalyResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, errorMessage, releaseLock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexAnomalyResultException(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, String errorMessage, boolean releaseLock, String taskState) {
        String detectorId = jobParameter.getName();
        try {
            IntervalTimeConfiguration windowDelay = (IntervalTimeConfiguration)jobParameter.getWindowDelay();
            Instant dataStartTime = detectionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            Instant dataEndTime = executionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            User user = jobParameter.getUser();
            AnomalyResult anomalyResult = new AnomalyResult(detectorId, null, new ArrayList<FeatureData>(), dataStartTime, dataEndTime, executionStartTime, Instant.now(), errorMessage, null, user, this.anomalyDetectionIndices.getSchemaVersion(ADIndex.RESULT), null);
            String resultIndex = jobParameter.getResultIndex();
            if (resultIndex != null && !this.anomalyDetectionIndices.doesIndexExist(resultIndex)) {
                this.anomalyResultHandler.index(anomalyResult, detectorId, null);
            } else {
                this.anomalyResultHandler.index(anomalyResult, detectorId, resultIndex);
            }
            this.updateLatestRealtimeTask(detectorId, taskState, null, null, errorMessage);
        }
        catch (Exception e) {
            log.error("Failed to index anomaly result for " + detectorId, (Throwable)e);
        }
        finally {
            if (releaseLock) {
                this.releaseLock(jobParameter, lockService, lock);
            }
        }
    }

    private void updateLatestRealtimeTask(String detectorId, String taskState, Long rcfTotalUpdates, Long detectorIntervalInMinutes, String error) {
        this.adTaskManager.updateLatestRealtimeTaskOnCoordinatingNode(detectorId, taskState, rcfTotalUpdates, detectorIntervalInMinutes, error, (ActionListener<UpdateResponse>)ActionListener.wrap(r -> {
            if (r != null) {
                log.debug("Updated latest realtime task successfully for detector {}, taskState: {}", (Object)detectorId, (Object)taskState);
            }
        }, e -> {
            if (e instanceof ResourceNotFoundException && e.getMessage().contains(CommonErrorMessages.CAN_NOT_FIND_LATEST_TASK)) {
                log.error("Can't find latest realtime task of detector " + detectorId);
                this.adTaskManager.removeRealtimeTaskCache(detectorId);
            } else {
                log.error("Failed to update latest realtime task for detector " + detectorId, (Throwable)e);
            }
        }));
    }

    private void releaseLock(AnomalyDetectorJob jobParameter, LockService lockService, LockModel lock) {
        lockService.release(lock, ActionListener.wrap(released -> log.info("Released lock for AD job {}", (Object)jobParameter.getName()), exception -> log.error("Failed to release lock for AD job: " + jobParameter.getName(), (Throwable)exception)));
    }
}

