/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.stats;

import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.plugin.stats.KNNCounter;
import org.opensearch.knn.plugin.stats.KNNStat;
import org.opensearch.knn.plugin.stats.StatNames;
import org.opensearch.knn.plugin.stats.suppliers.EventOccurredWithinThresholdSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNCircuitBreakerSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNCounterSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNInnerCacheStatsSupplier;
import org.opensearch.knn.plugin.stats.suppliers.LibraryInitializedSupplier;
import org.opensearch.knn.plugin.stats.suppliers.ModelIndexStatusSupplier;
import org.opensearch.knn.plugin.stats.suppliers.ModelIndexingDegradingSupplier;
import org.opensearch.knn.plugin.stats.suppliers.NativeMemoryCacheManagerSupplier;

public class KNNStatsConfig {
    public static Map<String, KNNStat<?>> KNN_STATS = ImmutableMap.builder().put((Object)StatNames.HIT_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::hitCount))).put((Object)StatNames.MISS_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::missCount))).put((Object)StatNames.LOAD_SUCCESS_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::loadSuccessCount))).put((Object)StatNames.LOAD_EXCEPTION_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::loadExceptionCount))).put((Object)StatNames.TOTAL_LOAD_TIME.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::totalLoadTime))).put((Object)StatNames.EVICTION_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::evictionCount))).put((Object)StatNames.GRAPH_MEMORY_USAGE.getName(), new KNNStat<Long>(false, new NativeMemoryCacheManagerSupplier<Long>(NativeMemoryCacheManager::getIndicesSizeInKilobytes))).put((Object)StatNames.GRAPH_MEMORY_USAGE_PERCENTAGE.getName(), new KNNStat<Float>(false, new NativeMemoryCacheManagerSupplier<Float>(NativeMemoryCacheManager::getIndicesSizeAsPercentage))).put((Object)StatNames.INDICES_IN_CACHE.getName(), new KNNStat<Map>(false, new NativeMemoryCacheManagerSupplier<Map>(NativeMemoryCacheManager::getIndicesCacheStats))).put((Object)StatNames.CACHE_CAPACITY_REACHED.getName(), new KNNStat<Boolean>(false, new NativeMemoryCacheManagerSupplier<Boolean>(NativeMemoryCacheManager::isCacheCapacityReached))).put((Object)StatNames.GRAPH_QUERY_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_QUERY_ERRORS))).put((Object)StatNames.GRAPH_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_QUERY_REQUESTS))).put((Object)StatNames.GRAPH_INDEX_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_INDEX_ERRORS))).put((Object)StatNames.GRAPH_INDEX_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_INDEX_REQUESTS))).put((Object)StatNames.CIRCUIT_BREAKER_TRIGGERED.getName(), new KNNStat<Boolean>(true, new KNNCircuitBreakerSupplier())).put((Object)StatNames.MODEL_INDEX_STATUS.getName(), new KNNStat<ClusterHealthStatus>(true, new ModelIndexStatusSupplier<ClusterHealthStatus>(ModelDao::getHealthStatus))).put((Object)StatNames.KNN_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.KNN_QUERY_REQUESTS))).put((Object)StatNames.SCRIPT_COMPILATIONS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_COMPILATIONS))).put((Object)StatNames.SCRIPT_COMPILATION_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_COMPILATION_ERRORS))).put((Object)StatNames.SCRIPT_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_QUERY_REQUESTS))).put((Object)StatNames.SCRIPT_QUERY_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_QUERY_ERRORS))).put((Object)StatNames.INDEXING_FROM_MODEL_DEGRADED.getName(), new KNNStat<Boolean>(false, new EventOccurredWithinThresholdSupplier(new ModelIndexingDegradingSupplier(ModelCache::getEvictedDueToSizeAt), KNNConstants.MODEL_CACHE_CAPACITY_ATROPHY_THRESHOLD_IN_MINUTES.intValue(), ChronoUnit.MINUTES))).put((Object)StatNames.FAISS_LOADED.getName(), new KNNStat<Boolean>(false, new LibraryInitializedSupplier(KNNEngine.FAISS))).put((Object)StatNames.NMSLIB_LOADED.getName(), new KNNStat<Boolean>(false, new LibraryInitializedSupplier(KNNEngine.NMSLIB))).put((Object)StatNames.TRAINING_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.TRAINING_REQUESTS))).put((Object)StatNames.TRAINING_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.TRAINING_ERRORS))).put((Object)StatNames.TRAINING_MEMORY_USAGE.getName(), new KNNStat<Long>(false, new NativeMemoryCacheManagerSupplier<Long>(NativeMemoryCacheManager::getTrainingSizeInKilobytes))).put((Object)StatNames.TRAINING_MEMORY_USAGE_PERCENTAGE.getName(), new KNNStat<Float>(false, new NativeMemoryCacheManagerSupplier<Float>(NativeMemoryCacheManager::getTrainingSizeAsPercentage))).build();
}

