/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.util.DocIdSetBuilder;
import org.opensearch.common.io.PathUtils;
import org.opensearch.knn.index.IndexUtil;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryEntryContext;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.query.KNNQueryResult;
import org.opensearch.knn.index.query.KNNScorer;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.jni.JNIService;
import org.opensearch.knn.plugin.stats.KNNCounter;

public class KNNWeight
extends Weight {
    private static Logger logger = LogManager.getLogger(KNNWeight.class);
    private static ModelDao modelDao;
    private final KNNQuery knnQuery;
    private final float boost;
    private NativeMemoryCacheManager nativeMemoryCacheManager;

    public KNNWeight(KNNQuery query, float boost) {
        super((Query)query);
        this.knnQuery = query;
        this.boost = boost;
        this.nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
    }

    public static void initialize(ModelDao modelDao) {
        KNNWeight.modelDao = modelDao;
    }

    public Explanation explain(LeafReaderContext context, int doc) {
        return Explanation.match((Number)Float.valueOf(1.0f), (String)"No Explanation", (Explanation[])new Explanation[0]);
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        KNNQueryResult[] results;
        NativeMemoryAllocation indexAllocation;
        SpaceType spaceType;
        KNNEngine knnEngine;
        SegmentReader reader = (SegmentReader)FilterLeafReader.unwrap((LeafReader)context.reader());
        String directory = ((FSDirectory)FilterDirectory.unwrap((Directory)reader.directory())).getDirectory().toString();
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(this.knnQuery.getField());
        if (fieldInfo == null) {
            logger.debug("[KNN] Field info not found for {}:{}", (Object)this.knnQuery.getField(), (Object)reader.getSegmentName());
            return null;
        }
        String modelId = fieldInfo.getAttribute("model_id");
        if (modelId != null) {
            ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
            if (modelMetadata == null) {
                throw new RuntimeException("Model \"" + modelId + "\" does not exist.");
            }
            knnEngine = modelMetadata.getKnnEngine();
            spaceType = modelMetadata.getSpaceType();
        } else {
            String engineName = fieldInfo.attributes().getOrDefault("engine", KNNEngine.NMSLIB.getName());
            knnEngine = KNNEngine.getEngine(engineName);
            String spaceTypeName = fieldInfo.attributes().getOrDefault("spaceType", SpaceType.L2.getValue());
            spaceType = SpaceType.getSpace(spaceTypeName);
        }
        Object engineExtension = reader.getSegmentInfo().info.getUseCompoundFile() ? knnEngine.getExtension() + "c" : knnEngine.getExtension();
        String engineSuffix = this.knnQuery.getField() + (String)engineExtension;
        List engineFiles = reader.getSegmentInfo().files().stream().filter(fileName -> fileName.endsWith(engineSuffix)).collect(Collectors.toList());
        if (engineFiles.isEmpty()) {
            logger.debug("[KNN] No engine index found for field {} for segment {}", (Object)this.knnQuery.getField(), (Object)reader.getSegmentName());
            return null;
        }
        Path indexPath = PathUtils.get((String)directory, (String[])new String[]{(String)engineFiles.get(0)});
        KNNCounter.GRAPH_QUERY_REQUESTS.increment();
        try {
            indexAllocation = this.nativeMemoryCacheManager.get(new NativeMemoryEntryContext.IndexEntryContext(indexPath.toString(), NativeMemoryLoadStrategy.IndexLoadStrategy.getInstance(), IndexUtil.getParametersAtLoading(spaceType, knnEngine, this.knnQuery.getIndexName()), this.knnQuery.getIndexName()), true);
        }
        catch (ExecutionException e) {
            KNNCounter.GRAPH_QUERY_ERRORS.increment();
            throw new RuntimeException(e);
        }
        indexAllocation.readLock();
        try {
            if (indexAllocation.isClosed()) {
                throw new RuntimeException("Index has already been closed");
            }
            results = JNIService.queryIndex(indexAllocation.getMemoryAddress(), this.knnQuery.getQueryVector(), this.knnQuery.getK(), knnEngine.getName());
        }
        catch (Exception e) {
            KNNCounter.GRAPH_QUERY_ERRORS.increment();
            throw new RuntimeException(e);
        }
        finally {
            indexAllocation.readUnlock();
        }
        if (results.length == 0) {
            logger.debug("[KNN] Query yielded 0 results");
            return null;
        }
        Map<Integer, Float> scores = Arrays.stream(results).collect(Collectors.toMap(KNNQueryResult::getId, result -> Float.valueOf(knnEngine.score(result.getScore(), spaceType))));
        int maxDoc = Collections.max(scores.keySet()) + 1;
        DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(maxDoc);
        DocIdSetBuilder.BulkAdder setAdder = docIdSetBuilder.grow(maxDoc);
        Arrays.stream(results).forEach(result -> setAdder.add(result.getId()));
        DocIdSetIterator docIdSetIter = docIdSetBuilder.build().iterator();
        return new KNNScorer(this, docIdSetIter, scores, this.boost);
    }

    public boolean isCacheable(LeafReaderContext context) {
        return true;
    }

    public static float normalizeScore(float score) {
        if (score >= 0.0f) {
            return 1.0f / (1.0f + score);
        }
        return -score + 1.0f;
    }
}

