/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN920Codec;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.lucene92.Lucene92HnswVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;

public class KNN920PerFieldKnnVectorsFormat
extends PerFieldKnnVectorsFormat {
    @Generated
    private static final Logger log = LogManager.getLogger(KNN920PerFieldKnnVectorsFormat.class);
    private final Optional<MapperService> mapperService;

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        if (this.isNotKnnVectorFieldType(field)) {
            log.debug(String.format("Initialize KNN vector format for field [%s] with default params [max_connections] = \"%d\" and [beam_width] = \"%d\"", field, 16, 100));
            return new Lucene92HnswVectorsFormat();
        }
        KNNVectorFieldMapper.KNNVectorFieldType type = (KNNVectorFieldMapper.KNNVectorFieldType)this.mapperService.orElseThrow(() -> new IllegalStateException(String.format("Cannot read field type for field [%s] because mapper service is not available", field))).fieldType(field);
        Map<String, Object> params = type.getKnnMethodContext().getMethodComponent().getParameters();
        int maxConnections = this.getMaxConnections(params);
        int beamWidth = this.getBeamWidth(params);
        log.debug(String.format("Initialize KNN vector format for field [%s] with params [max_connections] = \"%d\" and [beam_width] = \"%d\"", field, maxConnections, beamWidth));
        return new Lucene92HnswVectorsFormat(maxConnections, beamWidth);
    }

    private boolean isNotKnnVectorFieldType(String field) {
        return !this.mapperService.isPresent() || !(this.mapperService.get().fieldType(field) instanceof KNNVectorFieldMapper.KNNVectorFieldType);
    }

    private int getMaxConnections(Map<String, Object> params) {
        if (params != null && params.containsKey("m")) {
            return (Integer)params.get("m");
        }
        return 16;
    }

    private int getBeamWidth(Map<String, Object> params) {
        if (params != null && params.containsKey("ef_construction")) {
            return (Integer)params.get("ef_construction");
        }
        return 100;
    }

    @Generated
    public KNN920PerFieldKnnVectorsFormat(Optional<MapperService> mapperService) {
        this.mapperService = mapperService;
    }
}

