/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.observability.settings.PluginSettings;
import org.opensearch.rest.RestStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0016\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/observability/security/UserAccessManager;", "", "()V", "ALL_ACCESS_ROLE", "", "BACKEND_ROLE_TAG", "DEFAULT_TENANT", "OPENSEARCH_DASHBOARDS_SERVER_USER", "PRIVATE_TENANT", "ROLE_TAG", "USER_TAG", "canAdminViewAllItems", "", "user", "Lorg/opensearch/commons/authuser/User;", "doesUserHasAccess", "tenant", "access", "", "getAllAccessInfo", "getSearchAccessInfo", "getUserTenant", "hasAllInfoAccess", "isAdminUser", "isUserPrivateTenant", "validatePollingUser", "", "validateUser", "opensearch-observability"})
public final class UserAccessManager {
    @NotNull
    public static final UserAccessManager INSTANCE = new UserAccessManager();
    @NotNull
    private static final String USER_TAG = "User:";
    @NotNull
    private static final String ROLE_TAG = "Role:";
    @NotNull
    private static final String BACKEND_ROLE_TAG = "BERole:";
    @NotNull
    private static final String ALL_ACCESS_ROLE = "all_access";
    @NotNull
    private static final String OPENSEARCH_DASHBOARDS_SERVER_USER = "opensearchdashboardsserver";
    @NotNull
    private static final String PRIVATE_TENANT = "__user__";
    @NotNull
    public static final String DEFAULT_TENANT = "";

    private UserAccessManager() {
    }

    public final void validateUser(@Nullable User user) {
        if (this.isUserPrivateTenant(user)) {
            User user2 = user;
            if ((user2 == null ? null : user2.getName()) == null) {
                throw new OpenSearchStatusException("User name not provided for private tenant access", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                String string;
                User user3 = user;
                String string2 = string = user3 == null ? null : user3.getName();
                if (string != null) break;
                throw new OpenSearchStatusException("Filter-by enabled with security disabled", RestStatus.FORBIDDEN, new Object[0]);
            }
            case 3: {
                Collection collection;
                if (user == null || (collection = (Collection)user.getRoles()) == null || collection.isEmpty()) {
                    throw new OpenSearchStatusException("User doesn't have roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
                }
                if (user.getRoles().stream().filter(UserAccessManager::validateUser$lambda-0).count() != 0L) break;
                throw new OpenSearchStatusException("No distinguishing roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
            case 4: {
                User user4 = user;
                Collection collection = (Collection)(user4 == null ? null : user4.getBackendRoles());
                if (!(collection == null || collection.isEmpty())) break;
                throw new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
    }

    public final void validatePollingUser(@Nullable User user) {
        if (user != null && !Intrinsics.areEqual((Object)user.getName(), (Object)OPENSEARCH_DASHBOARDS_SERVER_USER)) {
            throw new OpenSearchStatusException("Permission denied", RestStatus.FORBIDDEN, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getUserTenant(@Nullable User user) {
        void var2_2;
        User user2 = user;
        String requestedTenant = user2 == null ? null : user2.getRequestedTenant();
        return requestedTenant == null ? DEFAULT_TENANT : var2_2;
    }

    @NotNull
    public final List<String> getAllAccessInfo(@Nullable User user) {
        String it;
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        List retList = new ArrayList();
        if (user.getName() != null) {
            retList.add(USER_TAG + user.getName());
        }
        List list = user.getRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.roles");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(ROLE_TAG + it);
        }
        $this$forEach$iv = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"user.backendRoles");
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(BACKEND_ROLE_TAG + it);
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSearchAccessInfo(@Nullable User user) {
        List list;
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        if (this.isUserPrivateTenant(user)) {
            return CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
        }
        if (this.canAdminViewAllItems(user)) {
            return CollectionsKt.emptyList();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
                break;
            }
            case 3: {
                List list2 = user.getRoles().stream().filter(UserAccessManager::getSearchAccessInfo$lambda-3).map(UserAccessManager::getSearchAccessInfo$lambda-4).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list2, (String)"user.roles.stream()\n    \u2026lect(Collectors.toList())");
                list = list2;
                break;
            }
            case 4: {
                void $this$mapTo$iv$iv;
                List list3 = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"user.backendRoles");
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(BACKEND_ROLE_TAG + (String)it);
                }
                list = (List)destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean doesUserHasAccess(@Nullable User user, @NotNull String tenant, @NotNull List<String> access) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        if (user == null) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)tenant)) {
            return false;
        }
        if (this.canAdminViewAllItems(user)) {
            return true;
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = access.contains(USER_TAG + user.getName());
                break;
            }
            case 3: {
                bl = user.getRoles().stream().filter(UserAccessManager::doesUserHasAccess$lambda-6).map(UserAccessManager::doesUserHasAccess$lambda-7).anyMatch(arg_0 -> UserAccessManager.doesUserHasAccess$lambda-8(access, arg_0));
                break;
            }
            case 4: {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                List list = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(BACKEND_ROLE_TAG + (String)it);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!access.contains(it)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean hasAllInfoAccess(@Nullable User user) {
        if (user == null) {
            return true;
        }
        return this.isAdminUser(user);
    }

    private final boolean canAdminViewAllItems(User user) {
        return PluginSettings.INSTANCE.getAdminAccess() == PluginSettings.AdminAccess.AllObservabilityObjects && this.isAdminUser(user);
    }

    private final boolean isAdminUser(User user) {
        return user.getRoles().contains(ALL_ACCESS_ROLE);
    }

    private final boolean isUserPrivateTenant(User user) {
        return Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)PRIVATE_TENANT);
    }

    private static final boolean validateUser$lambda-0(String it) {
        return !PluginSettings.INSTANCE.getIgnoredRoles().contains(it);
    }

    private static final boolean getSearchAccessInfo$lambda-3(String it) {
        return !PluginSettings.INSTANCE.getIgnoredRoles().contains(it);
    }

    private static final String getSearchAccessInfo$lambda-4(String it) {
        return ROLE_TAG + it;
    }

    private static final boolean doesUserHasAccess$lambda-6(String it) {
        return !PluginSettings.INSTANCE.getIgnoredRoles().contains(it);
    }

    private static final String doesUserHasAccess$lambda-7(String it) {
        return ROLE_TAG + it;
    }

    private static final boolean doesUserHasAccess$lambda-8(List $access, String it) {
        Intrinsics.checkNotNullParameter((Object)$access, (String)"$access");
        return $access.contains(it);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PluginSettings.FilterBy.values().length];
            nArray[PluginSettings.FilterBy.NoFilter.ordinal()] = 1;
            nArray[PluginSettings.FilterBy.User.ordinal()] = 2;
            nArray[PluginSettings.FilterBy.Roles.ordinal()] = 3;
            nArray[PluginSettings.FilterBy.BackendRoles.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

